/* eslint-disable */
import { IconButton, MenuItem, Popover, TableCell, TableRow } from "@mui/material"
import { useState } from "react";
import MoreVertIcon from '@mui/icons-material/MoreVert';
import EditIcon from '@mui/icons-material/Edit';
import DeleteIcon from '@mui/icons-material/Delete';

export default function CategoryTableRow({ row, labelId, handleDeleteCategoryClick, handleEditCategoryClick }: any) {
  const [open, setOpen] = useState(null);

  const handleOpenMenu = (event: any) => {
    setOpen(event.currentTarget);
  };

  const handleEditButton = () => {
    handleEditCategoryClick(row)
    setOpen(null);
  };

  const handleDeleteButton = () => {
    handleDeleteCategoryClick(row.id || row._id)
    setOpen(null);
  };

  return (
    <>
      <TableRow hover>
        <TableCell 
          component="th" 
          id={labelId} 
          scope="row"
        >
          {row.name}
        </TableCell>
        <TableCell>{new Date(row.createdAt).toLocaleDateString()}</TableCell>
        <TableCell align="right">
          <IconButton onClick={handleOpenMenu}>
            <MoreVertIcon />
          </IconButton>
        </TableCell>
      </TableRow>

      <Popover
        open={!!open}
        anchorEl={open}
        onClose={() => setOpen(null)}
        anchorOrigin={{ vertical: 'top', horizontal: 'left' }}
        transformOrigin={{ vertical: 'top', horizontal: 'right' }}
        PaperProps={{ sx: { width: 140 } }}
      >
        <MenuItem onClick={handleEditButton}>
          <EditIcon />
          Edit
        </MenuItem>
        <MenuItem onClick={handleDeleteButton} sx={{ color: 'error.main' }}>
          <DeleteIcon />
          Delete
        </MenuItem>
      </Popover>
    </>
  );
}
