/* eslint-disable */
"use client"
import { Box, Button, Divider, Drawer, IconButton, Stack, TextField, Typography } from "@mui/material";
import { useEffect, useState } from "react";
import CloseIcon from '@mui/icons-material/Close';
import Notification from '@/app/admin/notification';

const UpdateCategoryDrawer = ({ updateCategoryDrawerOpen, getCategories, setUpdateCategoryDrawerOpen, data }: any) => {
  const [name, setName] = useState('');
  const [notificationMessage, setNotificationMessage] = useState('');
  const [isOpenNotification, setIsOpenNotification] = useState(false);

  useEffect(() => {
    if (data) {
      setName(data.name);
    }
  }, [data]);

  const toggleDrawer = (open: boolean) => (event: React.KeyboardEvent | React.MouseEvent) => {
    if (event.type === 'keydown' && ((event as React.KeyboardEvent).key === 'Tab' || (event as React.KeyboardEvent).key === 'Shift')) {
      return;
    }
    setName(data?.name || '');
    setUpdateCategoryDrawerOpen(open);
  };

  const handleUpdateCategory = async (e: any) => {
    e.preventDefault();

    const formData = new FormData();
    formData.append('name', name);
    formData.append('id', data._id);

    // Uncomment and modify when API is ready
    // const response = await updateCategory(formData);
    // if (response.status === 1) {
    //   setNotificationMessage('Category updated successfully!');
    //   setIsOpenNotification(true);
    //   getCategories();
    //   setUpdateCategoryDrawerOpen(false);
    // } else {
    //   setNotificationMessage(response.error);
    //   setIsOpenNotification(true);
    // }
  };

  return (
    <>
      <Drawer
        anchor={'right'}
        open={updateCategoryDrawerOpen}
        onClose={toggleDrawer(false)}
      >
        {/* <Box p={4}>
          <Stack direction={'row'} justifyContent={'space-between'} alignItems={'center'}>
            <Typography variant='h5'>Edit Category</Typography>
            <IconButton onClick={toggleDrawer(false)}>
              <CloseIcon />
            </IconButton>
          </Stack>
        </Box> */}
        <Divider />
        <Box p={4} sx={{ width: { sm: '330px', md: '450px', xl: '450px' } }}>
          <form onSubmit={handleUpdateCategory}>
            <TextField
              name='name'
              value={name}
              onChange={(e) => setName(e.target.value)}
              sx={{ width: '100%' }}
              id="category-name"
              label="Category Name"
              variant="outlined"
            />
            <Box mt={4}>
              <Button variant='contained' type='submit' sx={{ mr: 3 }}>Update</Button>
              <Button variant='outlined' onClick={toggleDrawer(false)} color='error'>Cancel</Button>
            </Box>
          </form>
        </Box>
      </Drawer>
      <Notification
        open={isOpenNotification}
        onClose={() => setIsOpenNotification(false)}
        message={notificationMessage}
      />
    </>
  );
};

export default UpdateCategoryDrawer;
