/* eslint-disable */
'use client';

import { useState } from 'react';
import { Box, Button, Divider, TextField, Typography } from '@mui/material';
import { useRouter } from 'next/navigation';
import Notification from '@/app/admin/notification';

const ContactInformation = () => {
  const [phoneNumber, setPhoneNumber] = useState('');
  const [email, setEmail] = useState('');
  const [address, setAddress] = useState('');
  const [street, setStreet] = useState('');
  const [city, setCity] = useState('');
  const [state, setState] = useState('');
  const [postalCode, setPostalCode] = useState('');
  const [country, setCountry] = useState('');
  const [website, setWebsite] = useState('');
  const [isOpenNotification, setIsOpenNotification] = useState(false);
  const [notificationMessage, setNotificationMessage] = useState('');
  const router = useRouter();

  const handleUpdateContactInformation = async (e: any) => {
    e.preventDefault();

    // Mocking a successful response
    const response = { status: 1, message: "Contact information updated successfully!" };

    if (response.status === 1) {
      setNotificationMessage(response.message);
      setIsOpenNotification(true);
    } else {
      setNotificationMessage(response.message || 'Error updating contact information');
      setIsOpenNotification(true);
    }
  };

  return (
    <Box p={4} sx={{ backgroundColor: 'white', borderRadius: 1 }}>
      <Typography variant="h5">Contact Information Management</Typography>
      <Divider sx={{ my: 3 }} />
      <form onSubmit={handleUpdateContactInformation}>
        <TextField
          required
          name="phoneNumber"
          onChange={(e) => setPhoneNumber(e.target.value)}
          value={phoneNumber}
          sx={{ width: '100%' }}
          label="Phone Number"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="email"
          onChange={(e) => setEmail(e.target.value)}
          value={email}
          sx={{ width: '100%' }}
          label="Email Address"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="address"
          onChange={(e) => setAddress(e.target.value)}
          value={address}
          sx={{ width: '100%' }}
          label="Address (Clinic/Office Address)"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="street"
          onChange={(e) => setStreet(e.target.value)}
          value={street}
          sx={{ width: '100%' }}
          label="Street"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="city"
          onChange={(e) => setCity(e.target.value)}
          value={city}
          sx={{ width: '100%' }}
          label="City"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="state"
          onChange={(e) => setState(e.target.value)}
          value={state}
          sx={{ width: '100%' }}
          label="State"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="postalCode"
          onChange={(e) => setPostalCode(e.target.value)}
          value={postalCode}
          sx={{ width: '100%' }}
          label="Postal Code"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          required
          name="country"
          onChange={(e) => setCountry(e.target.value)}
          value={country}
          sx={{ width: '100%' }}
          label="Country"
          variant="outlined"
          className="mbe-5"
        />
        <TextField
          name="website"
          onChange={(e) => setWebsite(e.target.value)}
          value={website}
          sx={{ width: '100%' }}
          label="Website (Optional)"
          variant="outlined"
          className="mbe-5"
        />

        <Box mt={4} sx={{ display: 'flex', justifyContent: 'center' }}>
          <Button variant="contained" type="submit" sx={{ mr: 3 }}>
            Submit
          </Button>
          <Button variant="outlined" color="error" onClick={() => router.push('/admin')}>
            Cancel
          </Button>
        </Box>
      </form>
      <Notification
        open={isOpenNotification}
        onClose={() => setIsOpenNotification(false)}
        message={notificationMessage}
      />
    </Box>
  );
};

export default ContactInformation;
