/* eslint-disable */
"use client";
// MUI Imports
// import Grid from '@mui/material/Grid'

// Components Imports
import { useRouter } from 'next/navigation'; // Correct import for App Router

// import Table from '@views/dashboard/Table'
import { useEffect, useState } from 'react'
import useAPI from '@/hooks/useAPI'
import Card from '@mui/material/Card';
import CardContent from '@mui/material/CardContent';
import { Grid, Stack, Typography } from '@mui/material'


const DashboardAnalytics = () => {
  const router = useRouter(); // Correct hook for App Router
  const [doctorsrows, setDoctorsRows] = useState<any>([]);
  const [patientsrows, setPatientsRows] = useState<any>([]);
  const [categoriesrows, setCategoriesRows] = useState<any>([]);
  const [subcategoriesrows, setSubCategoriesRows] = useState<any>([]);
  const [counts, setCounts] = useState<any>(null);



  useEffect(() => {
    const load = async () => {
      try {
        const api = await useAPI();
        const res = await api.dashboard.get();
        if (res && res.data && res.data.data) {
          setCounts(res.data.data);
        }
      } catch (err) {
        console.error('Failed to load dashboard counts', err);
      }
    };

    load();
  }, []);

  const handleRedirect = (path: string) => {
    router.push(path); // Navigate to the manage page
  }

  return (
    <Grid container spacing={6}>
      <Grid item xs={12} md={3}>
        <div onClick={() => handleRedirect('/admin/users')} style={{ cursor: 'pointer' }}>
          <Card sx={{ width: '100%' }}>
            <CardContent>
              <Stack direction={'row'} justifyContent={'space-between'}>
                <Typography>Total Users</Typography>
                <i className="ri-group-line text-[26px]"></i>
              </Stack>
              <Typography variant='h4'>{counts ? counts.totalUsers : 0}</Typography>
              <Typography variant='caption'>All Users</Typography>
            </CardContent>
          </Card>
        </div>
      </Grid>

      <Grid item xs={12} md={3}>
        <Card sx={{ width: '100%' }}>
          <CardContent>
            <Stack direction={'row'} justifyContent={'space-between'}>
              <Typography>GUEST</Typography>
              <i className="ri-user-line text-[26px]"></i>
            </Stack>
            <Typography variant='h4'>{counts ? counts.guestCount : 0}</Typography>
            <Typography variant='caption'>Guest Users</Typography>
          </CardContent>
        </Card>
      </Grid>

      <Grid item xs={12} md={3}>
        <Card sx={{ width: '100%' }}>
          <CardContent>
            <Stack direction={'row'} justifyContent={'space-between'}>
              <Typography>PROFESSIONAL</Typography>
              <i className="ri-user-star-line text-[26px]"></i>
            </Stack>
            <Typography variant='h4'>{counts ? counts.professionalCount : 0}</Typography>
            <Typography variant='caption'>Professional Users</Typography>
          </CardContent>
        </Card>
      </Grid>

      <Grid item xs={12} md={3}>
        <Card sx={{ width: '100%' }}>
          <CardContent>
            <Stack direction={'row'} justifyContent={'space-between'}>
              <Typography>COACH</Typography>
              <i className="ri-user-voice-line text-[26px]"></i>
            </Stack>
            <Typography variant='h4'>{counts ? counts.coachCount : 0}</Typography>
            <Typography variant='caption'>Coach Users</Typography>
          </CardContent>
        </Card>
      </Grid>

      <Grid item xs={12} md={3}>
        <Card sx={{ width: '100%' }}>
          <CardContent>
            <Stack direction={'row'} justifyContent={'space-between'}>
              <Typography>FIGHTER</Typography>
              <i className="ri-boxing-line text-[26px]"></i>
            </Stack>
            <Typography variant='h4'>{counts ? counts.fighterCount : 0}</Typography>
            <Typography variant='caption'>Fighter Users</Typography>
          </CardContent>
        </Card>
      </Grid>

      <Grid item xs={12} md={4}>
        <Card sx={{ width: '100%' }}>
          <CardContent>
            <Stack direction={'row'} justifyContent={'space-between'}>
              <Typography>Events</Typography>
              <i className="ri-calendar-event-line text-[26px]"></i>
            </Stack>
            <Typography variant='h4'>{counts ? counts.totalEvents : 0}</Typography>
            <Typography variant='caption'>Total Events</Typography>
          </CardContent>
        </Card>
      </Grid>

      <Grid item xs={12} md={4}>
        <Card sx={{ width: '100%' }}>
          <CardContent>
            <Stack direction={'row'} justifyContent={'space-between'}>
              <Typography>Active Events</Typography>
              <i className="ri-calendar-schedule-line text-[26px]"></i>
            </Stack>
            <Typography variant='h4'>{counts ? counts.activeEventsCount : 0}</Typography>
            <Typography variant='caption'>Currently Active</Typography>
          </CardContent>
        </Card>
      </Grid>

      {/* The rest of your grid items can go here... */}
    </Grid>
  )
}

export default DashboardAnalytics
