/* eslint-disable */
import { Avatar, IconButton, MenuItem, Popover, TableCell, TableRow } from "@mui/material"
import { useState } from "react";
import MoreVertIcon from '@mui/icons-material/MoreVert';
import EditIcon from '@mui/icons-material/Edit';
import DeleteIcon from '@mui/icons-material/Delete';

export default function ProductTableRow({ row, labelId, handleDeleteProductClick, handleEditProductClick }: any) {
  const [open, setOpen] = useState(null);

  const handleOpenMenu = (event: any) => {
    setOpen(event.currentTarget);
  };

  const handleEditButton = () => {
    handleEditProductClick(row)
    setOpen(null);
  };

  const handleDeleteButton = () => {
    handleDeleteProductClick(row.id || row._id)
    setOpen(null);
  };

  return (
    <>
      <TableRow hover>
        <TableCell 
          component="th" 
          id={labelId} 
          scope="row"
        >
          <Avatar 
            src={row.productImage} 
            alt={row.productName}
            sx={{ width: 40, height: 40 }}
          />
        </TableCell>
        <TableCell>{row.productName}</TableCell>
        <TableCell>{row.superMarketName}</TableCell>
        <TableCell>{row.materialName}</TableCell>
        {/* <TableCell>{row.quantity}</TableCell> */}
        <TableCell>{row.category?.name || 'N/A'}</TableCell>
        <TableCell>{new Date(row.createdAt).toLocaleDateString()}</TableCell>
        <TableCell align="right">
          <IconButton onClick={handleOpenMenu}>
            <MoreVertIcon />
          </IconButton>
        </TableCell>
      </TableRow>

      <Popover
        open={!!open}
        anchorEl={open}
        onClose={() => setOpen(null)}
        anchorOrigin={{ vertical: 'top', horizontal: 'left' }}
        transformOrigin={{ vertical: 'top', horizontal: 'right' }}
        PaperProps={{ sx: { width: 140 } }}
      >
        <MenuItem onClick={handleEditButton}>
          <EditIcon />
          Edit
        </MenuItem>
        <MenuItem onClick={handleDeleteButton} sx={{ color: 'error.main' }}>
          <DeleteIcon />
          Delete
        </MenuItem>
      </Popover>
    </>
  );
}
