/* eslint-disable */
'use client'

import { useState } from 'react'
import {
  MenuItem,
  InputLabel,
  Select,
  Box,
  Button,
  CardContent,
  Divider,
  FormControl,
  FormControlLabel,
  Radio,
  RadioGroup,
  Stack,
  TextField,
  Typography,
  InputAdornment,
  IconButton,
  Card
} from '@mui/material'

// import {InputLabel,Select, Box, Button, CardContent, Divider, FormControl, FormControlLabel, Radio, RadioGroup, Stack, TextField, Typography, InputAdornment, IconButton, Card } from '@mui/material';
import { useRouter } from 'next/navigation'
import { useEffect } from 'react'
import Notification from '@/app/admin/notification'
import CloseIcon from '@mui/icons-material/Close'

const InformationPage = () => {
  const [firstName, setFirstName] = useState('')
  const [lastName, setLastName] = useState('')
  const [gender, setGender] = useState('Male')
  const [dob, setDob] = useState('')
  const [profilePicture, setProfilePicture] = useState<File | null>(null)
  const [imgSrc, setImgSrc] = useState('/images/default/images.jpg') // Default image
  const [fileInput, setFileInput] = useState('') // To control the input value
  const [phoneNumber, setPhoneNumber] = useState('')
  const [email, setEmail] = useState('')
  const [address, setAddress] = useState('')
  const [street, setStreet] = useState('')
  const [city, setCity] = useState('')
  const [state, setState] = useState('')
  const [postalCode, setPostalCode] = useState('')
  const [country, setCountry] = useState('')
  const [website, setWebsite] = useState('')

  const [specialization, setSpecialization] = useState('')
  const [subSpecialization, setSubSpecialization] = useState('')
  const [licenseNumber, setLicenseNumber] = useState('')
  const [yearsOfExperience, setYearsOfExperience] = useState('')
  // const [qualifications, setQualifications] = useState('');
  const [qualifications1InstitutionName, setqualifications1InstitutionName] = useState('')
  const [qualifications1YearOfCompletion, setqualifications1YearOfCompletion] = useState('')
  const [qualifications2InstitutionName, setqualifications2InstitutionName] = useState('')
  const [qualifications2YearOfCompletion, setqualifications2YearOfCompletion] = useState('')
  const [qualifications3InstitutionName, setqualifications3InstitutionName] = useState('')
  const [qualifications3YearOfCompletion, setqualifications3YearOfCompletion] = useState('')
  const [qualifications4InstitutionName, setqualifications4InstitutionName] = useState('')
  const [qualifications4YearOfCompletion, setqualifications4YearOfCompletion] = useState('')
  const [affiliations, setAffiliations] = useState('')
  const [languagesSpoken, setLanguagesSpoken] = useState('')

  // New fields
  const [areasOfExpertise, setAreasOfExpertise] = useState('')
  const [awardsRecognitions, setAwardsRecognitions] = useState('')
  const [publicationsResearch, setPublicationsResearch] = useState('')
  const [categories, setCategories] = useState([]) // Stores category data
  const [selectedCategory, setSelectedCategory] = useState('') // Stores the selected category ID
  const [subCategories, setSubCategories] = useState([])
  const [selectedSubCategory, setSelectedSubCategory] = useState('')
  const [socialMediaLinks, setSocialMediaLinks] = useState('')
  const [personalBio, setPersonalBio] = useState('')
  const [password, setPassword] = useState('')
  const [confirmPassword, setConfirmPassword] = useState('')

  const [isOpenNotification, setIsOpenNotification] = useState(false)
  const [notificationMessage, setNotificationMessage] = useState('')

  const router = useRouter()

  const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const reader = new FileReader()
    const { files } = e.target
    if (files && files.length !== 0) {
      setProfilePicture(files[0])
      reader.onload = () => setImgSrc(reader.result as string) // Set image src from file
      reader.readAsDataURL(files[0])
      if (reader.result !== null) {
        setFileInput(reader.result as string)
      }
    }
  }

  const handleFileReset = () => {
    setImgSrc('/images/default/images.jpg') // Reset to default image
    setFileInput('')
  }

  useEffect(() => {
    const fetchSubCategories = async () => {
      if (selectedCategory) {
        // const response = await getSubCategories()
        // if (response.status === 1) {
        //   // Filter subcategories based on selected category
        //   const filteredSubCategories = response.result.filter(subCat => subCat.categoryId === selectedCategory)
        //   setSubCategories(filteredSubCategories)
        // }
      } else {
        setSubCategories([]) // Reset subcategories when no category is selected
      }
    }

    fetchSubCategories()
  }, [selectedCategory])

  useEffect(() => {
    const fetchCategoryList = async () => {
      // const response = await getCategories()
      // if (response.status === 1) {
      //   // Set categories if the response is successful
      //   setCategories(response.result)
      // } else {
      //   console.error('Failed to fetch categories:', response.error)
      // }
    }

    fetchCategoryList()
  }, [])

  // Update the handleUpdateInformation function:
  const handleUpdateInformation = async (e: any) => {
    e.preventDefault()

  

    if (password !== confirmPassword) {
      setNotificationMessage('Passwords do not match!');
      setIsOpenNotification(true);
      return;
  }
    const formData = new FormData()
    formData.append('firstName', firstName)
    formData.append('lastName', lastName)
    formData.append('gender', gender)
    formData.append('dob', dob)
    if (profilePicture) formData.append('profilePicture', profilePicture)
    formData.append('phoneNumber', phoneNumber)
    formData.append('email', email)
    formData.append('address', address)
    formData.append('street', street)
    formData.append('city', city)
    formData.append('state', state)
    formData.append('postalCode', postalCode)
    formData.append('country', country)
     formData.append('password', password)

    // const response = await createInformation(formData)

    // if (response.status === 1) {
    //   setNotificationMessage('Information added successfully!')
    //   setIsOpenNotification(true)
    //   router.push('/admin/doctor') // Redirect after successful submission
    // } else {
    //   setNotificationMessage(response.error || 'Error adding information')
    //   setIsOpenNotification(true)
    // }
  }

  return (
    // <Box p={4} sx={{ backgroundColor: 'white', borderRadius: 1 }}>
    <Box
      p={4}
      sx={{
        backgroundColor: 'var(--mui-palette-background-paper)',
        borderRadius: 1,
        color: 'var(--mui-palette-text-primary)'
      }}
    >
      <Typography variant='h5'>Information</Typography>
      <Divider sx={{ my: 3 }} />
      <form onSubmit={handleUpdateInformation} encType='multipart/form-data'>
        <CardContent className='mbe-5'>
          <div className='flex max-sm:flex-col items-center gap-6'>
            <img height={100} width={100} className='rounded' src={imgSrc} alt='Profile' />
            <div className='flex flex-grow flex-col gap-4'>
              <div className='flex flex-col sm:flex-row gap-4'>
                <Button component='label' size='small' variant='contained' htmlFor='account-settings-upload-image'>
                  Upload New Photo
                  <input
                    hidden
                    type='file'
                    value={fileInput}
                    accept='image/png, image/jpeg'
                    onChange={handleFileChange}
                    name='file'
                    id='account-settings-upload-image'
                  />
                </Button>
                <Button size='small' variant='outlined' color='error' onClick={handleFileReset}>
                  Reset
                </Button>
              </div>
            </div>
          </div>
        </CardContent>
        <TextField
          required
          name='firstName'
          onChange={e => setFirstName(e.target.value)}
          value={firstName}
          sx={{ width: '100%' }}
          label='First Name'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='lastName'
          onChange={e => setLastName(e.target.value)}
          value={lastName}
          sx={{ width: '100%' }}
          label='Last Name'
          variant='outlined'
          className='mbe-5'
        />
        <FormControl fullWidth className='mbe-5'>
          <RadioGroup row value={gender} onChange={e => setGender(e.target.value)}>
            <FormControlLabel value='Male' control={<Radio />} label='Male' />
            <FormControlLabel value='Female' control={<Radio />} label='Female' />
            <FormControlLabel value='Other' control={<Radio />} label='Other' />
          </RadioGroup>
        </FormControl>
        <TextField
          required
          type='date'
          name='dob'
          value={dob}
          onChange={e => setDob(e.target.value)}
          sx={{ width: '100%' }}
          label='Date of Birth'
          variant='outlined'
          InputLabelProps={{ shrink: true }}
          className='mbe-5'
        />


        <Divider sx={{ my: 3 }} />
        <Typography variant='h5'>Contact Information</Typography>
        <TextField
          required
          name='phoneNumber'
          onChange={e => setPhoneNumber(e.target.value)}
          value={phoneNumber}
          sx={{ width: '100%' }}
          label='Phone Number'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='email'
          onChange={e => setEmail(e.target.value)}
          value={email}
          sx={{ width: '100%' }}
          label='Email Address'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          type='password'
          name='password'
          onChange={e => setPassword(e.target.value)}
          value={password}
          sx={{ width: '100%' }}
          label='Password'
          variant='outlined'
          className='mbe-5'
        />

        <TextField
          required
          type='password'
          name='confirmPassword'
          onChange={e => setConfirmPassword(e.target.value)}
          value={confirmPassword}
          sx={{ width: '100%' }}
          label='Confirm Password'
          variant='outlined'
          className='mbe-5'
        />

        <TextField
          required
          name='address'
          onChange={e => setAddress(e.target.value)}
          value={address}
          sx={{ width: '100%' }}
          label='Address (Clinic/Office Address)'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='street'
          onChange={e => setStreet(e.target.value)}
          value={street}
          sx={{ width: '100%' }}
          label='Street'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='city'
          onChange={e => setCity(e.target.value)}
          value={city}
          sx={{ width: '100%' }}
          label='City'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='state'
          onChange={e => setState(e.target.value)}
          value={state}
          sx={{ width: '100%' }}
          label='State'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='postalCode'
          onChange={e => setPostalCode(e.target.value)}
          value={postalCode}
          sx={{ width: '100%' }}
          label='Postal Code'
          variant='outlined'
          className='mbe-5'
        />
        <TextField
          required
          name='country'
          onChange={e => setCountry(e.target.value)}
          value={country}
          sx={{ width: '100%' }}
          label='Country'
          variant='outlined'
          className='mbe-5'
        />

        <Divider sx={{ my: 3 }} />

        <Box mt={4} sx={{ display: 'flex', justifyContent: 'center' }}>
          <Button variant='contained' type='submit' sx={{ mr: 3 }}>
            Submit
          </Button>
          <Button variant='outlined' color='error' onClick={() => router.push('/admin/doctor')}>
            Cancel
          </Button>
        </Box>
      </form>
      {/* <Notification Open={isOpenNotification} setIsOpen={setIsOpenNotification} message={notificationMessage} /> */}
    </Box>
  )
}

export default InformationPage
