// MUI Imports
import { useTheme } from '@mui/material/styles'
import { signOut } from 'next-auth/react'
import { useRouter } from 'next/navigation'

// Third-party Imports
import PerfectScrollbar from 'react-perfect-scrollbar'

// Type Imports
import type { VerticalMenuContextProps } from '@menu/components/vertical-menu/Menu'

// Component Imports
import { Menu, SubMenu, MenuItem } from '@menu/vertical-menu'

// Hook Imports
import useVerticalNav from '@menu/hooks/useVerticalNav'

// Styled Component Imports
import StyledVerticalNavExpandIcon from '@menu/styles/vertical/StyledVerticalNavExpandIcon'

// Style Imports
import menuItemStyles from '@core/styles/vertical/menuItemStyles'
import menuSectionStyles from '@core/styles/vertical/menuSectionStyles'


type RenderExpandIconProps = {
  open?: boolean
  transitionDuration?: VerticalMenuContextProps['transitionDuration']
}

const RenderExpandIcon = ({ open, transitionDuration }: RenderExpandIconProps) => (
  <StyledVerticalNavExpandIcon open={open} transitionDuration={transitionDuration}>
    <i className='ri-arrow-right-s-line' />
  </StyledVerticalNavExpandIcon>
)

const AdminVerticalMenu = ({ scrollMenu }: { scrollMenu: (container: any, isPerfectScrollbar: boolean) => void }) => {
  // Hooks
  const theme = useTheme()
  const { isBreakpointReached, transitionDuration } = useVerticalNav()
  const router = useRouter()

  const ScrollWrapper = isBreakpointReached ? 'div' : PerfectScrollbar

  return (
    // eslint-disable-next-line lines-around-comment
    /* Custom scrollbar instead of browser scroll, remove if you want browser scroll only */
    <ScrollWrapper
      {...(isBreakpointReached
        ? {
            className: 'bs-full overflow-y-auto overflow-x-hidden',
            onScroll: container => scrollMenu(container, false)
          }
        : {
            options: { wheelPropagation: false, suppressScrollX: true },
            onScrollY: container => scrollMenu(container, true)
          })}
    >
      {/* Incase you also want to scroll NavHeader to scroll with Vertical Menu, remove NavHeader from above and paste it below this comment */}
      {/* Vertical Menu */}
      <Menu
        menuItemStyles={menuItemStyles(theme)}
        renderExpandIcon={({ open }) => <RenderExpandIcon open={open} transitionDuration={transitionDuration} />}
        renderExpandedMenuItemIcon={{ icon: <i className='ri-circle-line' /> }}
        menuSectionStyles={menuSectionStyles(theme)}
      >
        <MenuItem href={`/`} icon={<i className='ri-dashboard-line' />}>
          Dashboard
        </MenuItem>
        <SubMenu
          label='User Management'
          icon={<i className='ri-user-line'></i>}
        >
          <MenuItem href='/admin/user'>Manage Users</MenuItem>
        </SubMenu>
        
        <SubMenu
          label='Events Management'
          icon={<i className='ri-calendar-event-line'></i>}
        >
          <MenuItem href='/admin/events'>Manage Events</MenuItem>
          <MenuItem href='/admin/event/add'>Add Event</MenuItem>
        </SubMenu>
        {/* <SubMenu label='Category Management' icon={<i className='ri-nurse-line'></i>}>
        <MenuItem href='/admin/category'>Manage Category</MenuItem>
        </SubMenu>

        <SubMenu label="Product Management" icon={<ShoppingCart />} >
        <MenuItem href='/admin/product'>Manage Product</MenuItem>
        </SubMenu> */}

        <SubMenu label='Pages Management' icon={<i className='ri-pages-line'></i>}>
          <MenuItem href='/admin/pages'>Manage Pages</MenuItem>
        </SubMenu>

        <SubMenu label='Home Page Management' icon={<i className='ri-home-3-line'></i>}>
          <MenuItem href='/admin/home-management'>Manage Home Sections</MenuItem>
        </SubMenu>

        <SubMenu label='Certificate Management' icon={<i className='ri-award-line'></i>}>
          <MenuItem href='/admin/certificates'>Manage Certificates</MenuItem>
        </SubMenu>

        <SubMenu label='Professionals Management' icon={<i className='ri-user-star-line'></i>}>
          <MenuItem href='/admin/professionals'>Manage Professionals</MenuItem>
        </SubMenu>

        <SubMenu label='Boxing Clubs' icon={<i className='ri-boxing-line'></i>}>
          <MenuItem href='/admin/boxing-clubs'>Manage Boxing Clubs</MenuItem>
        </SubMenu>

        <SubMenu label='News Management' icon={<i className='ri-newspaper-line'></i>}>
          <MenuItem href='/admin/news'>Manage News</MenuItem>
        </SubMenu>

        <MenuItem
          onClick={async () => {
            await signOut()
            router.push('/login')
          }}
          icon={<i className='ri-logout-box-r-line' />}
        >
          Logout
        </MenuItem>

        {/* <SubMenu
          label='Page Management'
          icon={<i className='ri-file-text-line' />}  // Changed icon for Event Management
        >
          <MenuItem href='/admin/pages/home'>Manage Home Page</MenuItem>
          <MenuItem href='/admin/pages/about-us'>Manage About Us Page</MenuItem>
          <MenuItem href='/admin/pages/contact-us'>Manage Contact Us Page</MenuItem>
          <MenuItem href='/admin/pages/privacy-policy'>Manage Privacy Policy Page</MenuItem>
          <MenuItem href='/admin/pages/terms-conditions'>Manage Terms And Conditions Page</MenuItem>
        </SubMenu> */}
      </Menu>
    </ScrollWrapper>
  )
}

export default AdminVerticalMenu
