//@ts-nocheck
import axios from 'axios'

import type {
  sendVerifyEmailAPIPayload,
  sendVerifyPhoneAPIPayload,
  verifyAPIPayload
} from '../services/authAPI'
import {
  checkEmailAPI,
  checkPhoneNumberAPI,
  checkUsernameAPI,
  forgotPasswordAPI,
  forgotUsernameAPI,
  resetPasswordAPI,
  sendVerifyEmailAPI,
  sendVerifyPhoneAPI,
  verifyEmailAPI,
  verifyPhoneAPI,
  verifyResetPasswordTokenAPI
} from '../services/authAPI'
import { getUserByIdAPI, getUsersAPI, updateChangePasswordAPI, updateUserProfileAPI } from '../services/userAPI'
import { getDashboardAPI } from '../services/dashboardAPI'
import { getCategoryAPI, createCategoryAPI, getCategoryByIdAPI, updateCategoryAPI, deleteCategoryAPI} from '../services/categoryAPI'
import { getProductAPI, createProductAPI, getProductByIdAPI, updateProductAPI, deleteProductAPI } from '../services/productAPI'
import { getPagesAPI, getPageByIdAPI, upsertPageAPI, deletePageAPI } from '../services/pagesAPI'
import { getAllNewsAPI, getPublishedNewsAPI, getNewsByIdAPI, createNewsAPI, updateNewsAPI, deleteNewsAPI } from '../services/newsAPI'
import { getHomeSectionsAPI, getHomeSectionByIdAPI, createHomeSectionAPI, updateHomeSectionAPI, deleteHomeSectionAPI } from '../services/homeManagementAPI'
import { getCertificatesAPI, getCertificateByIdAPI, createCertificateAPI, updateCertificateAPI, deleteCertificateAPI } from '../services/certificateAPI'
import {
  getProfessionalsAPI,
  getProfessionalByIdAPI,
  createProfessionalAPI,
  updateProfessionalAPI,
  deleteProfessionalAPI,
  getPublicProfessionalsAPI
} from '../services/professionalAPI'
import {
  getBoxingClubsAPI,
  getPublicBoxingClubsAPI,
  createBoxingClubAPI,
  updateBoxingClubAPI,
  deleteBoxingClubAPI
} from '../services/boxingClubAPI'

const API_BASE_URL = process.env.NEXT_PUBLIC_API_URI 

const useAPI = async () => {



  // Read client-side stored auth (sessionStorage or localStorage)
  const getStoredAuth = () => {
    try {
      const stored = sessionStorage.getItem("currentAuth") || localStorage.getItem("currentAuth");
      return stored ? JSON.parse(stored) : undefined;
    } catch (e) {
      return undefined;
    }
  }

  const auth = getStoredAuth();
  
  const api = axios.create({
    baseURL: API_BASE_URL,
    headers: {
      Authorization: `Bearer ${auth?.sessionToken || ''}`,
      'Refresh-Token': auth?.refreshToken || ''
    },
    timeout: 60000,
    withCredentials: false
  })

  api.interceptors.response.use(
    response => {
      return response
    },
    error => {
      if (error.response && error.response.status === 401) {
        if (auth.currentAuth?.remember) {
          auth
            .generateSession()
            .then(res => {
              console.log(res)
            })
            .catch(error => {
              console.log(error)
              auth.logoutUser()

              return Promise.reject(error)
            })
        } else {
          auth.logoutUser()
        }
      }

      return Promise.reject(error)
    }
  )

  return {
    auth: {
      sendVerifyEmailAPI: (data: sendVerifyEmailAPIPayload) => sendVerifyEmailAPI(api, data),
      verifyEmailAPI: (data: verifyAPIPayload) => verifyEmailAPI(api, data),
      sendVerifyPhoneAPI: (data: sendVerifyPhoneAPIPayload) => sendVerifyPhoneAPI(api, data),
      verifyPhoneAPI: (data: verifyAPIPayload) => verifyPhoneAPI(api, data),
      forgotUsername: (data: any) => forgotUsernameAPI(api, data),
      forgotPassword: (data: any) => forgotPasswordAPI(api, data),
      resetPassword: (data: any) => resetPasswordAPI(api, data),
      verifyResetPasswordToken: (data: any) => verifyResetPasswordTokenAPI(api, data),
      checkUsername: (data: any) => checkUsernameAPI(api, data),
      checkEmail: (data: any) => checkEmailAPI(api, data),
      checkPhoneNumber: (data: any) => checkPhoneNumberAPI(api, data)
    },
    dashboard: {
      get: (data?: any) => getDashboardAPI(api, data)
    },
    user: {
      update: (data: any) => updateUserProfileAPI(api, data),
      getUserById: (data: any) => getUserByIdAPI(api, data),
      changePassword: (data: any) => updateChangePasswordAPI(api, data),
      get: (data?: any) => getUsersAPI(api, data)
    },
    category: {
      get: (data?: any) => getCategoryAPI(api, data),
      create: (data: any) => createCategoryAPI(api, data),
      getById: (id: string) => getCategoryByIdAPI(api, id),
      update: (id: string, data: any) => updateCategoryAPI(api, id, data),
      delete: (id: string) => deleteCategoryAPI(api, id)
    },
    product: {
      get: (data?: any) => getProductAPI(api, data),
      create: (data: any) => createProductAPI(api, data),
      getById: (id: string) => getProductByIdAPI(api, id),
      update: (id: string, data: any) => updateProductAPI(api, id, data),
      delete: (id: string) => deleteProductAPI(api, id)
    },
    pages: {
      get: (data?: any) => getPagesAPI(api, data),
      getById: (id: string) => getPageByIdAPI(api, id),
      upsert: (data: any) => upsertPageAPI(api, data),
      delete: (id: string) => deletePageAPI(api, id)
    },
    news: {
      getAll: (data?: any) => getAllNewsAPI(api, data),
      getPublished: (data?: any) => getPublishedNewsAPI(api, data),
      getById: (id: string) => getNewsByIdAPI(api, id),
      create: (data: any) => createNewsAPI(api, data),
      update: (id: string, data: any) => updateNewsAPI(api, id, data),
      delete: (id: string) => deleteNewsAPI(api, id)
    },
    certificate: {
      getAll: (data?: any) => getCertificatesAPI(api, data),
      getById: (id: string) => getCertificateByIdAPI(api, id),
      create: (data: { title: string }) => createCertificateAPI(api, data),
      update: (id: string, data: { title: string }) => updateCertificateAPI(api, id, data),
      delete: (id: string) => deleteCertificateAPI(api, id)
    },
    professional: {
      getAll: (data?: any) => getProfessionalsAPI(api, data),
      getPublic: (data?: any) => getPublicProfessionalsAPI(api, data),
      getById: (id: string) => getProfessionalByIdAPI(api, id),
      create: (data: { title: string }) => createProfessionalAPI(api, data),
      update: (id: string, data: { title: string }) => updateProfessionalAPI(api, id, data),
      delete: (id: string) => deleteProfessionalAPI(api, id)
    },
    boxingClub: {
      getAll: (data?: any) => getBoxingClubsAPI(api, data),
      getPublic: (data?: any) => getPublicBoxingClubsAPI(api, data),
      create: (data: { title: string }) => createBoxingClubAPI(api, data),
      update: (id: string, data: { title: string }) => updateBoxingClubAPI(api, id, data),
      delete: (id: string) => deleteBoxingClubAPI(api, id)
    },
    homeManagement: {
      get: (data?: any) => getHomeSectionsAPI(api, data),
      getById: (id: string) => getHomeSectionByIdAPI(api, id),
      create: (data: FormData) => createHomeSectionAPI(api, data),
      update: (id: string, data: FormData) => updateHomeSectionAPI(api, id, data),
      delete: (id: string) => deleteHomeSectionAPI(api, id)
    }
  }
}

export default useAPI
