import { createContext, useContext } from "react";
import type { ReactNode } from "react";

import { ConfigProvider } from "antd";
import type { ThemeConfig } from "antd/es/config-provider";

import { useAuth } from "./useAuth";
import { antdAdminThemeConfig, antdUserThemeConfig } from "../configs/antdThemeConfig";

const ThemeContext = createContext<ThemeConfig | undefined>(undefined);
interface ThemeProviderProps {
  children: ReactNode;
}
const ThemeProvider: React.FC<ThemeProviderProps>=({children}) => {
  const { currentAuth } = useAuth();
  const themeConfig = currentAuth?.user.role === 'ADMIN' ? antdAdminThemeConfig : antdUserThemeConfig;

  return (
    <>
       <ThemeContext.Provider value={themeConfig}>
        <ConfigProvider theme={themeConfig}>
          {children}
        </ConfigProvider>
        </ThemeContext.Provider>
    </>
  );
}
export const useTheme = (): ThemeConfig | undefined => useContext(ThemeContext);

export default ThemeProvider ;
