import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getBoxingClubsAPI = async (
  api: AxiosInstance,
  params?: Record<string, any>
) => {
  const query = queryString.stringify(params || {}, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/boxing-clubs${query ? `?${query}` : ""}`);
};

export const getPublicBoxingClubsAPI = async (
  api: AxiosInstance,
  params?: Record<string, any>
) => {
  const query = queryString.stringify(params || {}, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/boxing-clubs/public${query ? `?${query}` : ""}`);
};

export const createBoxingClubAPI = async (
  api: AxiosInstance,
  data: { title: string }
) => api.post(`/boxing-clubs`, data);

export const updateBoxingClubAPI = async (
  api: AxiosInstance,
  id: string,
  data: { title: string }
) => api.put(`/boxing-clubs/${id}`, data);

export const deleteBoxingClubAPI = async (api: AxiosInstance, id: string) =>
  api.delete(`/boxing-clubs/${id}`);

