import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getCategoryAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/category/get?${stringified}`);
};

export const createCategoryAPI = async (api: AxiosInstance, data: any) => {
  return api.post('/category/create', data);
};

export const getCategoryByIdAPI = async (api: AxiosInstance, id: string) => {
  return api.get(`/category/${id}`);
};

export const updateCategoryAPI = async (api: AxiosInstance, id: string, data: any) => {
  return api.post(`/category/update/${id}`, data);
};

export const deleteCategoryAPI = async (api: AxiosInstance, id: string) => {
  return api.post(`/category/delete/${id}`);
};
