import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getCertificatesAPI = async (
  api: AxiosInstance,
  params?: Record<string, any>
) => {
  const query = queryString.stringify(params || {}, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/certificates${query ? `?${query}` : ""}`);
};

export const getCertificateByIdAPI = async (api: AxiosInstance, id: string) => {
  return api.get(`/certificates/${id}`);
};

export const createCertificateAPI = async (
  api: AxiosInstance,
  data: { title: string }
) => {
  return api.post(`/certificates`, data);
};

export const updateCertificateAPI = async (
  api: AxiosInstance,
  id: string,
  data: { title: string }
) => {
  return api.put(`/certificates/${id}`, data);
};

export const deleteCertificateAPI = async (
  api: AxiosInstance,
  id: string
) => {
  return api.delete(`/certificates/${id}`);
};

