import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getHomeSectionsAPI = async (api: AxiosInstance, params?: any) => {
  const stringified = queryString.stringify(params, {
    skipNull: true,
    skipEmptyString: true,
  });

  const query = stringified ? `?${stringified}` : "";
  return api.get(`/home-management${query}`);
};

export const getHomeSectionByIdAPI = async (api: AxiosInstance, id: string) => {
  return api.get(`/home-management/${id}`);
};

export const createHomeSectionAPI = async (api: AxiosInstance, data: FormData) => {
  return api.post(`/home-management`, data, {
    headers: { "Content-Type": "multipart/form-data" },
  });
};

export const updateHomeSectionAPI = async (
  api: AxiosInstance,
  id: string,
  data: FormData
) => {
  return api.put(`/home-management/${id}`, data, {
    headers: { "Content-Type": "multipart/form-data" },
  });
};

export const deleteHomeSectionAPI = async (api: AxiosInstance, id: string) => {
  return api.delete(`/home-management/${id}`);
};

