import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getAllNewsAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/news?${stringified}`);
};

export const getPublishedNewsAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/news/published?${stringified}`);
};

export const getNewsByIdAPI = async (api: AxiosInstance, id: string) => {
  return api.get(`/news/${id}`);
};

export const createNewsAPI = async (api: AxiosInstance, data: any) => {
  return api.post(`/news`, data);
};

export const updateNewsAPI = async (api: AxiosInstance, id: string, data: any) => {
  return api.put(`/news/${id}`, data);
};

export const deleteNewsAPI = async (api: AxiosInstance, id: string) => {
  return api.delete(`/news/${id}`);
};

