import type { AxiosInstance } from "axios";
import queryString from "query-string";


export const getUserNotificationConfigAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/notification/config/user?${stringified}`);
};

export const updateUserNotificationConfigAPI = async (api: AxiosInstance, data: any) => {
  return api.put(`/notification/config/user`, data);
};

