import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getPagesAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/pages?${stringified}`);
};

export const getPageByIdAPI = async (api: AxiosInstance, id: string) => {
  return api.get(`/pages/${id}`);
};

export const upsertPageAPI = async (api: AxiosInstance, data: any) => {
  return api.post(`/pages`, data);
};

export const deletePageAPI = async (api: AxiosInstance, id: string) => {
  return api.delete(`/pages/${id}`);
};

