import type { AxiosInstance } from "axios";
import queryString from "query-string";

export const getProfessionalsAPI = async (
  api: AxiosInstance,
  params?: Record<string, any>
) => {
  const query = queryString.stringify(params || {}, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/professionals${query ? `?${query}` : ""}`);
};

export const getPublicProfessionalsAPI = async (
  api: AxiosInstance,
  params?: Record<string, any>
) => {
  const query = queryString.stringify(params || {}, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/professionals/public${query ? `?${query}` : ""}`);
};

export const getProfessionalByIdAPI = async (api: AxiosInstance, id: string) =>
  api.get(`/professionals/${id}`);

export const createProfessionalAPI = async (
  api: AxiosInstance,
  data: { title: string }
) => api.post(`/professionals`, data);

export const updateProfessionalAPI = async (
  api: AxiosInstance,
  id: string,
  data: { title: string }
) => api.put(`/professionals/${id}`, data);

export const deleteProfessionalAPI = async (
  api: AxiosInstance,
  id: string
) => api.delete(`/professionals/${id}`);

