export type BusinessRole = "OWNER";
export type UserRole = "DEFAULT" | "ADMIN";

export interface CurrentUser {
  userId: string;
  _id: string;
  name: string;
  firstName: string;
  middleName: string;
  lastName: string;
  role: UserRole;
  businessRole: BusinessRole;
  email: string;
  phoneNumber?: string;
  dob?: string;
  username: string;
  imageUrl: string;
  gender?: Gender;
  country: Country;
  devices?:Devices[]
  sessionToken?: string;
  refreshToken?: string;
}

export enum Gender {
  MALE = "MALE",
  FEMALE = "FEMALE",
  NOT_SPECIFY = "NOT_SPECIFY",
}

export enum Country {
  USA = "USA",
  IND = "IND",
}

export enum AdvertisementType {
  AdvertisementWithEndDate = "AdvertisementWithEndDate",
  AdvertisementWithTimeControl = "AdvertisementWithTimeControl",
  AdvertisementWithBudgetControl = "AdvertisementWithBudgetControl",
  CustomAdvertisement = "CustomAdvertisement",
}
export interface Devices {
  lastLogin:string;
}

export interface BusinessInfoType {
  id: string;
  name: string;
  typeId: string;
  address?:{
    state: string;
    addressLine01: string;
    addressLine02?: string;
    city: string;
    country: Country;
    zipCode: number;
  }
  email: string;
  logoUrl?: string;
  type?:CompanyType;
  phoneNumber: string;
  website: string;
  isContactPersonSame: string;
  contactPerson: ContactPersonType;
}

export interface ContactPersonType {
  firstName: string;
  middleName: string;
  lastName: string;
  email?: string;
  phoneNumber: BusinessRole;
}

export interface CompanyType {
  id:string;
  type:string;
  logo:string;
  description:string;
  userId:string;
}
  
  