// MUI Imports
import { useTheme } from '@mui/material/styles'

// Third-party Imports
import PerfectScrollbar from 'react-perfect-scrollbar'

// Type Imports
import type { VerticalMenuContextProps } from '@menu/components/vertical-menu/Menu'

// Component Imports
import { Menu, SubMenu, MenuItem } from '@menu/vertical-menu'

// Hook Imports
import useVerticalNav from '@menu/hooks/useVerticalNav'

// Styled Component Imports
import StyledVerticalNavExpandIcon from '@menu/styles/vertical/StyledVerticalNavExpandIcon'

// Style Imports
import menuItemStyles from '@core/styles/vertical/menuItemStyles'
import menuSectionStyles from '@core/styles/vertical/menuSectionStyles'
import { FaProductHunt } from "react-icons/fa";


type RenderExpandIconProps = {
  open?: boolean
  transitionDuration?: VerticalMenuContextProps['transitionDuration']
}

const RenderExpandIcon = ({ open, transitionDuration }: RenderExpandIconProps) => (
  <StyledVerticalNavExpandIcon open={open} transitionDuration={transitionDuration}>
    <i className='ri-arrow-right-s-line' />
  </StyledVerticalNavExpandIcon>
)

const AdminVerticalMenu = ({ scrollMenu }: { scrollMenu: (container: any, isPerfectScrollbar: boolean) => void }) => {
  // Hooks
  const theme = useTheme()
  const { isBreakpointReached, transitionDuration } = useVerticalNav()

  const ScrollWrapper = isBreakpointReached ? 'div' : PerfectScrollbar

  return (
    // eslint-disable-next-line lines-around-comment
    /* Custom scrollbar instead of browser scroll, remove if you want browser scroll only */
    <ScrollWrapper
      {...(isBreakpointReached
        ? {
            className: 'bs-full overflow-y-auto overflow-x-hidden',
            onScroll: container => scrollMenu(container, false)
          }
        : {
            options: { wheelPropagation: false, suppressScrollX: true },
            onScrollY: container => scrollMenu(container, true)
          })}
    >
      {/* Incase you also want to scroll NavHeader to scroll with Vertical Menu, remove NavHeader from above and paste it below this comment */}
      {/* Vertical Menu */}
      <Menu
        menuItemStyles={menuItemStyles(theme)}
        renderExpandIcon={({ open }) => <RenderExpandIcon open={open} transitionDuration={transitionDuration} />}
        renderExpandedMenuItemIcon={{ icon: <i className='ri-circle-line' /> }}
        menuSectionStyles={menuSectionStyles(theme)}
      >
        <MenuItem href={`/`} icon={<i className='ri-dashboard-line' />}>
          Dashboard
        </MenuItem>
        {/* <SubMenu
          label='User Management'
          icon={<i className='ri-nurse-line'></i>} // Changed icon for Slider Management
        >
          <MenuItem href='/admin/user'>Manage User</MenuItem>
        </SubMenu> */}
        <SubMenu label='Category Management' icon={<i className='ri-nurse-line'></i>}>
        <MenuItem href='/admin/category'>Manage Category</MenuItem>
        </SubMenu>

        <SubMenu label="Product Management" icon={<FaProductHunt />} >
        <MenuItem href='/admin/product'>Manage Product</MenuItem>
        </SubMenu>

        {/* <SubMenu
          label='Page Management'
          icon={<i className='ri-file-text-line' />}  // Changed icon for Event Management
        >
          <MenuItem href='/admin/pages/home'>Manage Home Page</MenuItem>
          <MenuItem href='/admin/pages/about-us'>Manage About Us Page</MenuItem>
          <MenuItem href='/admin/pages/contact-us'>Manage Contact Us Page</MenuItem>
          <MenuItem href='/admin/pages/privacy-policy'>Manage Privacy Policy Page</MenuItem>
          <MenuItem href='/admin/pages/terms-conditions'>Manage Terms And Conditions Page</MenuItem>
        </SubMenu> */}
      </Menu>
    </ScrollWrapper>
  )
}

export default AdminVerticalMenu
