//@ts-nocheck
import axios from 'axios'
import { useAuth } from './useAuth'
import {
  checkEmailAPI,
  checkPhoneNumberAPI,
  checkUsernameAPI,
  forgotPasswordAPI,
  forgotUsernameAPI,
  resetPasswordAPI,
  sendVerifyEmailAPI,
  sendVerifyEmailAPIPayload,
  sendVerifyPhoneAPI,
  sendVerifyPhoneAPIPayload,
  verifyAPIPayload,
  verifyEmailAPI,
  verifyPhoneAPI,
  verifyResetPasswordTokenAPI
} from '../services/authAPI'

import { getUserByIdAPI, getUsersAPI, updateChangePasswordAPI, updateUserProfileAPI } from '../services/userAPI'
import { getDashboardAPI } from '../services/dashboardAPI'
import { getSession } from 'next-auth/react'
import { getCategoryAPI, createCategoryAPI, getCategoryByIdAPI, updateCategoryAPI, deleteCategoryAPI} from '../services/categoryAPI'    
import CategoryPage from '@/app/admin/category/page'
import { getProductAPI, createProductAPI, getProductByIdAPI, updateProductAPI, deleteProductAPI } from '../services/productAPI'

const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || 'http://localhost:3004/'

const useAPI = async () => {


  // const auth = useAuth()
  const auth = await getSession()
  
  const api = axios.create({
    baseURL: API_BASE_URL,
    headers: {
      Authorization: `Bearer ${auth?.user.sessionToken || ''}`,
      'Refresh-Token': auth?.user.refreshToken || ''
    },
    timeout: 60000,
    withCredentials: false
  })

  api.interceptors.response.use(
    response => {
      return response
    },
    error => {
      if (error.response && error.response.status === 401) {
        if (auth.currentAuth?.remember) {
          auth
            .generateSession()
            .then(res => {
              console.log(res)
            })
            .catch(error => {
              console.log(error)
              auth.logoutUser()
              return Promise.reject(error)
            })
        } else {
          auth.logoutUser()
        }
      }
      return Promise.reject(error)
    }
  )

  return {
    auth: {
      sendVerifyEmailAPI: (data: sendVerifyEmailAPIPayload) => sendVerifyEmailAPI(api, data),
      verifyEmailAPI: (data: verifyAPIPayload) => verifyEmailAPI(api, data),
      sendVerifyPhoneAPI: (data: sendVerifyPhoneAPIPayload) => sendVerifyPhoneAPI(api, data),
      verifyPhoneAPI: (data: verifyAPIPayload) => verifyPhoneAPI(api, data),
      forgotUsername: (data: any) => forgotUsernameAPI(api, data),
      forgotPassword: (data: any) => forgotPasswordAPI(api, data),
      resetPassword: (data: any) => resetPasswordAPI(api, data),
      verifyResetPasswordToken: (data: any) => verifyResetPasswordTokenAPI(api, data),
      checkUsername: (data: any) => checkUsernameAPI(api, data),
      checkEmail: (data: any) => checkEmailAPI(api, data),
      checkPhoneNumber: (data: any) => checkPhoneNumberAPI(api, data)
    },
    dashboard: {
      get: (data?: any) => getDashboardAPI(api, data)
    },
    user: {
      update: (data: any) => updateUserProfileAPI(api, data),
      getUserById: (data: any) => getUserByIdAPI(api, data),
      changePassword: (data: any) => updateChangePasswordAPI(api, data),
      get: (data?: any) => getUsersAPI(api, data)
    },
    category: {
      get: (data?: any) => getCategoryAPI(api, data),
      create: (data: any) => createCategoryAPI(api, data),
      getById: (id: string) => getCategoryByIdAPI(api, id),
      update: (id: string, data: any) => updateCategoryAPI(api, id, data),
      delete: (id: string) => deleteCategoryAPI(api, id)
    },
    product: {
      get: (data?: any) => getProductAPI(api, data),
      create: (data: any) => createProductAPI(api, data),
      getById: (id: string) => getProductByIdAPI(api, id),
      update: (id: string, data: any) => updateProductAPI(api, id, data),
      delete: (id: string) => deleteProductAPI(api, id)
    }
  }
}

export default useAPI
