import { AxiosInstance } from "axios";
import queryString from "query-string";


export const getAdvertisementUserAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.get(`/advertisement/user?${stringified}`);
};
export const getAdvertisementPageItemsAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.get(`/advertisement/ad-pages?${stringified}`);
};
export const getAdvertisementPriceAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.get(`/advertisement/ad-price?${stringified}`);
};

export const getAdvertisementAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/advertisement?${stringified}`);
};

export const findAdvertisementUser = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });

  return api.get(`/advertisement/user/${data.id}?${stringified}`);
};

export const advertisementCreateAPI = async (
  api: AxiosInstance,
  data: any,
) => {
  return api.post("/advertisement", data);
};

export const advertisementUpdateAPI = async (
  api: AxiosInstance,
  data: any,
) => {
  return api.put("/advertisement", data);
};

export const advertisementStatusUpdateAPI = async (
  api: AxiosInstance,
  data: any,
) => {
  return api.post("/advertisement/status-update", data);
};
export const advertisementDeleteAPI = async (
  api: AxiosInstance,
  data: any,
) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.delete(`/advertisement?${stringified}`);
};

export const fileUpdateAPI = async (
  api: AxiosInstance,
  data: any,
) => {
  const formData = new FormData();
  
  Object.keys(data).forEach(key => {
    formData.append(key, data[key]);
  });
  
  return api.post("/file-upload", formData,{
    headers: {
      'Content-Type': 'multipart/form-data'
    }});
};