import { AxiosInstance } from "axios";
import queryString from "query-string";

export const getProductAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.get(`/product?${stringified}`);
};

export const createProductAPI = async (api: AxiosInstance, data: any) => {
  return api.post('/product/create', data);
};

export const getProductByIdAPI = async (api: AxiosInstance, id: string) => {
  return api.get(`/product/${id}`);
};

export const updateProductAPI = async (api: AxiosInstance, id: string, data: any) => {
  return api.post(`/product/update/${id}`, data);
};

export const deleteProductAPI = async (api: AxiosInstance, id: string) => {
  return api.post(`/product/delete/${id}`);
};
