import { AxiosInstance } from "axios";
import queryString from "query-string";


export const getUsersAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.get(`/user?${stringified}`);
};
export const getUserByIdAPI = async (api: AxiosInstance, data?: any) => {
  const stringified = queryString.stringify(data, {
    skipNull: true,
    skipEmptyString: true,
  });
  return api.get(`/user/${data.id}?${stringified}`);
};

export const updateUserProfileAPI = async (api: AxiosInstance, data: any) => {
  return api.put(`/user`, data);
};
export const updateChangePasswordAPI = async (api: AxiosInstance, data: any) => {
  return api.post(`/user/change-password`, data);
};
