<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Vendor;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Mail;
use Auth;


class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    public function registerProcess(Request $request)
    {

          $request->validate([
            'first_name'  => 'required|string',
            'last_name'  => 'required|string',
            'phone'  => 'required|string',
            'email' => 'required|email|unique:users',
            'password' => [
                'required',
                'string',
            ],
            'confirm_password'=>'required|same:password',

        ]);

            $user = new User();
            $user->first_name = $request->first_name;
            $user->last_name = $request->last_name;
            $user->email = $request->email;
            $user->password = Hash::make($request->password);
            $user->phone = (!empty($request->phone) ? $request->phone : null);
            $user->gender = (!empty($request->gender) ? $request->gender : null);
            //$user->addFlag(User::FLAG_ACTIVE);



            if($request->user_type == 1){
                $user->user_type = "1";



            }else{
                $user->user_type = "2";

            }

            $user->flags = 1;




            if($user->save()){
                if (!is_dir(storage_path("app/public/user/"))) {
                    mkdir(storage_path("app/public/user/"), 0777, true);
                }
                if (!is_dir(storage_path("app/public/user/" .$user->id))) {
                mkdir(storage_path("app/public/user/" .$user->id), 0777, true);
                }
                if(\File::exists($request->image)){
                    $file_name = addFile($request->image, storage_path("app/public/user/" . $user->id));
                    $user->image_url = $file_name;

                    $user->save();
                }




                $artisan_call_to_make_files_public = \Artisan::call("storage:link", []);
                if ($artisan_call_to_make_files_public) {
                    DB::rollBack();
                }





                return redirect()->back()->with('success', 'your message,here');

                // if(Auth::attempt(['email'=>$request->email, 'password'=>$request->password,'flags'=>1]))
                // {

                //     return redirect(route('update_account'));
                // }
            }
            //return back()->with(['message' => "User Register Successfully"]);


    }
}
  /*  $to_name = $request->first_name .' '.$request->last_name ;
        $to_email = $request->email;
        $data = array('name'=>$request->first_name, 'body' => 'A test mail');
        Mail::send('emails.user_register', $data, function($message) use ($to_name, $to_email) {
        $message->to($to_email, $to_name)
        ->subject('Laravel Test Mail');
        $message->from('discovermasroorab@gmail.com','Test Mail');
        }); */
