<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\CartItem;
use Str;
use App\Models\Cart;
use auth;

class CartController extends Controller
{
    //


    public function store(Request $request){

        
        $set_cookies = \Cookie::get('cartitem');
        $user_record_found = CartItem::where('cookies_id', $set_cookies)->where('product_id', $request->product_id)->first();
        try{
            if(!empty($request->product_id) && !empty($request->quantity)){
                $user_id = 0;
                if (auth()->user())
                    $user_id = auth()->user()->id;
    
                $product =   Product::where('id',$request->product_id)->first()->toArray();
                 //cookie check
                $set_cookies = \Cookie::get('cartitem');
                
                if($set_cookies){
                    $user_record_found = CartItem::where('cookies_id', $set_cookies)->where('product_id', $request->product_id)->first();
                   
                    if($user_record_found){
                        $result = \Cart::update($user_record_found->row_id, [
                                    'name' => $product['product_name'],
                                    'qty' => $request->quantity,
                                    'price' => $product['sale_price'],
                                    'options' => [
                                    'image'=>$product['image_url'],
                                    'size'=>$request->size_id,
                                    ]
                                    ]);
                      
                        if($result)
                            echo json_encode(['message'=>"Product Has Been Updated Successfully",'result' => Cart::content()]);
                        else
                             echo json_encode(['error'=>"Something Wrong, Try Again"]);   
                    }else{
                        //new product added in cart
                        if(!empty($request->product_id) && !empty($request->quantity)){
                            $cart  = Cart::add(['id' => $product['id'], 'name' => $product['product_name'], 'qty' => $request->quantity, 'price' => $product['sale_price'], 'options' => ['image' =>  $product['image_url'],'size' =>$request->size_id]]);                    
                            $cart_items =  new CartItem();
                            $cart_items->row_id = $cart->rowId;
                            $cart_items->product_id = $product['id'];
                            $cart_items->cookies_id = $set_cookies;
                            $cart_items->user_id = $user_id;
                            if($cart_items->save()){
                                echo json_encode(['message'=>"Product Has Been Added Successfully",'result' => Cart::content()]);
                            }else{
                                echo json_encode(['error'=>"Something Wrong, Try Again"]);
                            }
                        }
                    }
                        
                        
                }else{
                    if(!empty($request->product_id) && !empty($request->quantity)){
                        //first time added in cart
                        $id = (string) Str::uuid();
                        $cookie_cart_item =   \Cookie::queue('cartitem', $id, 36800);
    
                        $cart  = Cart::add(['id' => $product['id'], 'name' => $product['product_name'], 'qty' => $request->quantity, 'price' => $product['sale_price'], 'options' => ['image' =>  $product['image_url'],'size' =>$request->size_id ]]);                    
                        $cart_items =  new CartItem();
                        $cart_items->row_id = $cart->rowId;
                        $cart_items->product_id = $product['id'];
                        $cart_items->cookies_id = $id;
                        if($cart_items->save()){
                            echo json_encode(['message'=>"Product Has Been Added Successfully",'result' => Cart::content()]);
                        }else{
                            echo json_encode(['error'=>"Something Wrong, Try Again"]);
                        }
                    }
                      
                    }
    
            }else{
                echo json_encode(['error'=>'Product is not in cart']);
            }

        }catch(Exception $e){
            print_r($e);
        }
       
        
        
    }

    public function remove_cart_item(Request $request){
        
        
        if(!empty($request->cart_id)){
            $delete_cart =  Cart::where('id',$request->cart_id)->where('user_id',auth::user()->id)->delete(); 
            return  json_encode(['message' =>'Delete item from cart']);

        }
        else
        {

            return json_encode(['error' =>'Some Error in Delete Record, Please Try Again']);

        }

        // if(!empty($request->product_id) && !empty($request->row_id)){
        //     $user_record_found =  CartItem::where('product_id',$request->product_id)->where('cookies_id',\Cookie::get('cartitem'))->first();
        //     if($user_record_found){
        //        // $user_record_cart = Cart::remove($user_record_found->row_id);
        //         //$delete_cart =  CartItem::where('product_id',$request->product_id)->where('row_id',$user_record_found->row_id)->delete();
        //         $delete_cart =  Cart::where('id',$request->product_id)->where('user_id',$auth::user()->id)->delete();   

        //           if($delete_cart){
        //             return  json_encode(['message' =>'Delete item from cart']);
        //           }else{
        //             return json_encode(['error' =>'Something Error in Delete Record, Please Try Again']);
        //           }  
        //     }else{
        //         return json_encode(['error' =>'Something Error in Cart, Please Try Again']);
        //     }
        // }else{
        //     return json_encode(['error' =>'No Values, Try Again']);
        // }
    }

    public function delete_cart(Request $request)
    {
        $d=$request->id;
        Cart::where("id",$d)->delete();
        return redirect()->back();

    }

}
