<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Brand;
use App\Models\Product;
use App\Models\ShopCategory;
use App\Models\ProductCatShop;
use App\Models\Setting;
use App\Models\User;
use App\Models\RequestVendor;
use App\Models\Wishlist;
use App\Models\News;
use App\Models\VendorProduct;
use App\Models\ProductSize;
use App\Models\CategorySize;
use App\Models\Size;
use App\Models\ProductImage;
use App\Models\ProductFault;
use Illuminate\Support\Str;
use Hash;
use Auth;
use App\Models\Cart;
use App\Models\Traffic;
use App\Models\shop_categories;
use DB;



class FrontController extends Controller
{
    public function index()
    {
        $traffic = new Traffic;
        $traffic->visit = "visit";
        $traffic->save();
        $brands = Setting::where('key', 'home_brands')->first();

        //brand display on home
        if (!empty($brands) && $brands['value'] != 'null') {
            $brands = $brands->toArray();

            $brands = json_decode($brands['value']);
            $data['brands'] = Brand::whereIn('id', $brands)
                //->limit(5)
                ->get();
        }
        //START MAN'S SECTION
        //man's in new display on home
        if (!empty($brands)) {
            $man_products = Product::where('created_at', '>', now()->subDays(30))
                ->whereHas('shop_category', function ($query) {
                    $query->where('shop_cat_name', 'Menswear');
                })->limit(5)->get();
        }

        //man's in sale display on home
        $man_in_sale = Setting::where('key', 'mans_in_sale')->first();
        if (!empty($brands) && $man_in_sale['value']) {
            $man_in_sale = $man_in_sale->toArray();
            $man_in_sale = json_decode($man_in_sale['value']);
            if (gettype($man_in_sale) == "array") {
                $data['man_in_sales'] = Product::whereIn('id', $man_in_sale)->get();
                //  $man_in_sale = Product::where('sale_price', '>', 0)->take(5)->get();
            }
        }


        //man's in POPULAR display on home
        $man_in_popular = Setting::where('key', 'mans_in_popular')->first();
        if (!empty($brands) && $man_in_popular['value']) {
            $man_in_popular = $man_in_popular->toArray();
            $man_in_popular = json_decode($man_in_popular['value']);
            if (gettype($man_in_popular) == "array") {
                $data['man_in_populars'] = Product::whereIn('id', $man_in_popular)->get();
            }
        }
        //END OF MAN'S SECTION
        //START WOMAN'S SECTION

        //WOMAN'S IN NEW display on home
        $woman_products = Setting::where('key', 'woman_in_new')->first();
        if (!empty($brands) && $woman_products['value']) {
            $woman_products = $woman_products->toArray();
            $woman_products = json_decode($woman_products['value']);
            if (gettype($woman_products) == "array") {
                $data['woman_products'] = Product::whereIn('id', $woman_products)->get();
            }
        }

        //WOMAN'S IN SALE display on home
        $woman_in_sale = Setting::where('key', 'woman_in_sale')->first();
        if (!empty($brands) && $woman_in_sale['value']) {
            $woman_in_sale = $woman_in_sale->toArray();
            $woman_in_sale = json_decode($woman_in_sale['value']);
            if (gettype($woman_in_sale) == "array") {
                $data['woman_in_sales'] = Product::whereIn('id', $woman_in_sale)->get();
            }
        }
        //WOMAN'S IN POPULAR display on home
        $woman_in_popular = Setting::where('key', 'woman_in_popular')->first();
        if (!empty($brands) && $woman_in_popular['value']) {
            $woman_in_popular = $woman_in_popular->toArray();
            $woman_in_popular = json_decode($woman_in_popular['value']);
            if (gettype($woman_in_popular) == "array") {
                $data['woman_in_populars'] = Product::whereIn('id', $woman_in_popular)->get();
            }
        }

        //END OF WOMAN'S SECTION
        //START CHILDERN'S SECTION

        //CHILDERN'S IN NEW display on home
        $children_products = Setting::where('key', 'children_in_new')->first();
        if (!empty($brands) && $children_products['value']) {
            $children_products = $children_products->toArray();
            $children_products = json_decode($children_products['value']);
            if (gettype($children_products) == "array") {
                $data['children_products'] = Product::whereIn('id', $children_products)->get();
            }
        }
        //CHILDERN'S IN SALES display on home
        $children_in_sale = Setting::where('key', 'children_in_sale')->first();
        if (!empty($brands) && $children_in_sale['value']) {
            $children_in_sale = $children_in_sale->toArray();
            $children_in_sale = json_decode($children_in_sale['value']);
            if (gettype($children_in_sale) == "array") {
                $data['children_in_sales'] = Product::whereIn('id', $children_in_sale)->get();
            }
        }

        //CHILDERN'S IN POPULAR display on home
        $children_in_popular = Setting::where('key', 'children_in_popular')->first();

        if (!empty($brands) && $children_in_popular['value']) {
            $children_in_popular = $children_in_popular->toArray();

            $children_in_popular = json_decode($children_in_popular['value']);

            if (gettype($children_in_popular) == "array") {
                $data['children_in_populars'] = Product::whereIn('id', $children_in_popular)->get();
            }
        }
        //END OF CHIDLERN'S SECTION

        //top trend
        $top_mans_trend_product = Setting::where('key', 'top_mans_trend_product')->first();

        if (!empty($brands) && $top_mans_trend_product['value']) {
            $top_mans_trend_product = $top_mans_trend_product->toArray();

            $top_mans_trend_product = json_decode($top_mans_trend_product['value']);

            if (gettype($top_mans_trend_product) == "array") {
                $data['top_mans_trend_products'] = Product::whereIn('id', $top_mans_trend_product)->get();
            }
        }

        $top_womans_trend_product = Setting::where('key', 'top_womans_trend_product')->first();

        if (!empty($brands) && $top_womans_trend_product['value']) {
            $top_womans_trend_product = $top_womans_trend_product->toArray();
            $top_womans_trend_product = json_decode($top_womans_trend_product['value']);
            if (gettype($top_womans_trend_product) == "array") {
                $data['top_womans_trend_products'] = Product::whereIn('id', $top_womans_trend_product)->get();
            }
        }

        $top_children_trend_product = Setting::where('key', 'top_children_trend_product')->first();

        if (!empty($brands) && $top_children_trend_product['value']) {
            $top_children_trend_product = $top_children_trend_product->toArray();
            $top_children_trend_product = json_decode($top_children_trend_product['value']);
            if (gettype($top_children_trend_product) == "array") {
                $data['top_children_trend_products'] = Product::whereIn('id', $top_children_trend_product)->get();
            }
        }
        if (empty($data)) {
            $data['message'] = 'No products';
        }

        // return view('frontend.front-index',$data);
        return view('frontend.home.frontend-home', $data);
    }

    public function single_product_variation($id)
    {


        // $data=Product::select("products.id as id","products.product_name","shop_categories.shop_cat_name","sizes.size","product_sizes.sale_price","products.flags","products.product_description","products.condition","products.sku","feature_image")
        // ->join("product_sizes","products.id","=","product_sizes.product_id")
        // ->leftjoin("shop_categories","shop_categories.id","=","products.shop_category_id")
        // ->leftjoin("sizes","sizes.id","=","product_sizes.size_id")
        // ->where('product_sizes.id',$id)
        // ->first();


        $a = ProductSize::where("id", $id)->first();


        //$category = Product::where('id', $a->product_id);


        $data = Product::select("products.*", "product_sizes.sale_price", "sizes.size")
            ->leftjoin("product_sizes", "product_sizes.product_id", "=", "products.id")
            ->leftjoin("sizes", "sizes.id", "=", "product_sizes.size_id")
            ->where('products.id', $a->product_id)
            ->with('product_parent.shop_category', 'product_user')->first();


        $faults = ProductFault::where('product_id', $a->product_id)->get();
        $all_faults = "";
        foreach ($faults as $fault) {

            $all_faults .= $fault->fault . ' , ';
        }

        $all_faults = chop($all_faults, " ,");
        $multiimages = ProductImage::where('product_id', $data->id)->get();
        $related = Product::where('id', '!=', $data->product_id)->where('parent_id', 0)->with('shop_category', 'prod_size.size')->limit(5)->get();

        // select("products.id as product_id","products.product_name","shop_categories.shop_cat_name","sizes.size","product_sizes.sale_price","products.flags","products.products_description")
        return view('frontend.home.variation_page', compact('data', 'id', 'related', 'multiimages', 'all_faults'));
    }

    public function single_page($product_id = 0, $cancel = 0, $variation = 0)
    {

        $data['product'] = Product::where('id', $product_id)->with('shop_category', 'multi_images', 'prod_size', 'prod_size.size', 'getBrand')->first();


        $category_id = $data['product']->shop_category_id;
        $category_sizes = CategorySize::where('category_id', $category_id)->pluck('size_id');


        $data['new_products'] = Size::whereIn('sizes.id', $category_sizes)
            ->with(['product_size' => function ($q) use ($product_id) {
                $q->where('product_id', '!=', $product_id)->where('sale_price', '>', 0)->orderBy('sale_price', 'ASC');
            }, 'product_size.products' => function ($j) use ($product_id) {
                $j->where('product_type', 1)->where('parent_id', $product_id)->whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE]);
            }])->get()->toArray();

        // Removing the bug ex the new_products are also including the value sof old_products so again cross cheacking
        foreach ($data['new_products'] as $i => $p) {

            foreach ($p["product_size"] as $j => $size) {

                // dd($size["products"]["product_type"]);
                if (isset($size["products"]["product_type"]) && $size["products"]["product_type"] == 1) {
                    //echo "Pehli fursat main nikal";


                } else {

                    $data['new_products'][$i]["product_size"];
                    unset($data['new_products'][$i]["product_size"][$j]);
                }
            }
        }

        $data['used_products'] = Size::whereIn('id', $category_sizes)
            ->with(['product_size' => function ($q) use ($product_id) {
                $q->where('product_id', '!=', $product_id)->where('sale_price', '>', 0)->orderBy('sale_price', 'ASC');
            }, 'product_size.products' => function ($j) use ($product_id) {
                $j->where('product_type', 2)->where('parent_id', $product_id)->whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE]);
            }])->get()->toArray();


        $data['related_products'] = Product::where('id', '!=', $product_id)->where('parent_id', 0)->with('shop_category', 'prod_size.size')->limit(5)->get();
        $data['cancel'] = $cancel;
        $data['variation'] = $variation;

        return view('frontend.home.product-single-page', $data);
    }

    public function product_new_used(Request $request)
    {

        $product_id = $request->product_id;
        $size_id = $request->size_id;
        $fault = "";

        if ($request->flags == 1) {

            $data['vendor_products'] = Size::where('id', $size_id)
                ->with(['product_size' => function ($q) use ($product_id) {
                    $q->where('product_id', '!=', $product_id)->where('sale_price', '>', 0)->orderBy('sale_price', 'ASC');
                }, 'product_size.products' => function ($j) use ($product_id) {
                    $j->where('product_type', 1)->where('parent_id', $product_id)->whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE]);
                }])
                ->paginate(10);
        }

        //$this->test(  $data['vendor_products']);
        if ($request->flags == 2) {
            //  $data['vendor_products'] = Product::select(["products.*","product_sizes.*","products.id as id","product_sizes.id as sizes_id_orignal"])
            //  ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
            //  ->join("product_sizes","product_sizes.product_id","=","products.id")
            //  ->join("sizes","sizes.id","=","product_sizes.size_id")
            //  ->where("sizes.id",$size_id)
            //  ->where('product_type',2)
            //  ->where('parent_id',$request->product_id)
            //  ->paginate(10);

            $data['vendor_products'] = Size::where('id', $size_id)
                ->with(['product_size' => function ($q) use ($product_id) {
                    $q->where('product_id', '!=', $product_id)->where('sale_price', '>', 0)->orderBy('sale_price', 'ASC');
                }, 'product_size.products' => function ($j) use ($product_id) {
                    $j->where('product_type', 2)->where('parent_id', $product_id)->whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE]);
                }])
                ->paginate(10);


            foreach ($data['vendor_products'] as $key => $all) {

                foreach ($all->product_size as $i => $pz) {


                    $faults = ProductFault::where('product_id', $data['vendor_products'][$key]->product_size[$i]->product_id)->get();
                    foreach ($faults as $f) {


                        $fault = $fault . $f->fault . ", ";
                    }


                    $fault = chop($fault, " ,");


                    $data['vendor_products'][$key]->product_size[$i]->fault = $fault;
                }
            }
        }
        $data['flags'] = $request->flags;
        //dd($data['vendor_products'][0]->product_size);
        // $this->test($data['vendor_products']);


        return view('frontend.home.vendor-size-product-ajax', $data);
    }

    public function single_page_new($product_id)
    {
        $data['products'] = Product::where('id', $product_id)->with('prod_shop_cat', 'prod_shop_cat.shop_cat', 'prod_shop_cat.shop_cat.cat_parent', 'prod_size', 'prod_size.size')->first();
        $data['related_products'] = Product::where('id', '!=', $product_id)->with('prod_shop_cat', 'prod_shop_cat.shop_cat')->limit(5)->get();
        return view('frontend.home.seller-product-new', $data);
    }

    public function seller_product_ajax(Request $request)
    {

        $data['products'] = Product::where('id', $request->product_id)->with('prod_shop_cat', 'prod_shop_cat.shop_cat', 'prod_shop_cat.shop_cat.cat_parent', 'prod_size', 'prod_size.size')->first();
        $data['flags'] = $request->flags;
        return view('frontend.home.seller-product-ajax', $data);
    }

    public function single_page_used($product_id)
    {
        $data['products'] = Product::where('id', $product_id)->with('prod_shop_cat', 'prod_shop_cat.shop_cat', 'prod_shop_cat.shop_cat.cat_parent', 'prod_size', 'prod_size.size')->first();
        $data['related_products'] = Product::where('id', '!=', $product_id)->with('prod_shop_cat', 'prod_shop_cat.shop_cat')->limit(5)->get();
        return view('frontend.home.seller-product-used', $data);
    }

    //news
    public function news(Request $request)
    {

        if ($request->filter) {

            $data['all_news'] = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->orderBy('id', 'DESC')->where('section', $request->filter)->paginate(10);

            if ($request->filter === 'Most Viewed') {

                $data['all_news'] = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->orderBy('visit', 'DESC')->paginate(10);
            }
        } else {

            $data['all_news'] = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->orderBy('id', 'DESC')->paginate(10);
        }


        $data['slider_news'] = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->orderBy('id', 'DESC')->limit(3)->get();

        $data['brands'] = Brand::whereRaw("flags & ? = ?", [Brand::FLAG_ACTIVE, Brand::FLAG_ACTIVE])
            ->orderBy('brand_name', 'ASC')->get();

        return view('frontend.home.news', $data);
    }

    public function single_news($slug)
    {
        $news = News::where('news_slug', $slug)->whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->first();
        $all_data = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->get();

        $news->visit = $news->visit + 1;
        $news->save();

        $previous = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->where('id', '<', $news->id)->orderBy('id', 'desc')->first();
        $next = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->where('id', '>', $news->id)->orderBy('id')->first();

        if (!isset($next)) {

            $next = $all_data->first();
        }
        if (!isset($previous)) {
            $previous = $all_data->last();
        }

        $related_news = News::whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->get()->random(3);

        return view('frontend.home.single-news', compact('news', 'previous', 'next', 'related_news'));
    }

    public function brand_with_slug($slug)
    {
        $data['brand'] = Brand::where('brand_slug', $slug)->whereRaw("flags & ? = ?", [Brand::FLAG_ACTIVE, Brand::FLAG_ACTIVE])->first();
        $data['all_news'] = News::where('brand_id', $data['brand']->id)->whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->orderBy('id', 'DESC')->paginate(10);


        //  $data['related_news'] = News::whereIn('brand_id',$data['news']->brand->id)->whereRaw("flags & ? = ?", [News::FLAG_ACTIVE, News::FLAG_ACTIVE])->with('brand')->get();
        return view('frontend.home.single-brand-news', $data);
    }


    //end news
    public function product_category(Request $request, $slug)
    {


        $data = $request->all();


        $gender = 0;

        if (isset($data["gender"])) {
            $categories = ShopCategory::where(["shop_cat_slug" => $slug, "parent_id" => $data["gender"]])->first();
            $gender = $data["gender"];

        } else {

            $categories = ShopCategory::where(["shop_cat_slug" => $slug])
                ->Where("parent_id", 1)
                ->first();

        }


        $data['category_name'] = $categories->shop_cat_name;
        $category_id = array($categories->id);


        //$product_shop_cat = $this->get_product_cat_shop($category->id);
        //return $data['products'] = $this->get_products($category->id);

        $data["gender"] = $data["gender"];
        $data["category"] = $categories->id;


        $data['products'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->whereIn('shop_category_id', $category_id)->with('shop_category', 'multi_images', 'prod_size.size')->get();

        $data['parent_categories'] = ShopCategory::whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->where('parent_id', 0)->get();
        //$this->test($products);
        return view('frontend.category.category', $data);
    }


    public function product_category1(Request $request, $slug)
    {


        $data = $request->all();


        //$categories=ShopCategory::where(["shop_cat_slug"=>$slug])->get();

        $data['products'] = Product::whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
            ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
            ->where(['products.parent_id' => 0, 'shop_cat_slug' => $slug])
            ->with('shop_category', 'multi_images', 'prod_size.size')
            ->get();


        $data['parent_categories'] = ShopCategory::whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->where('parent_id', 0)->get();
        //$this->test($products);
        return view('frontend.category.category', $data);
    }


    public function shop_products()
    {


        $data['products'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();


        $data['parent_categories'] = ShopCategory::whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->where('parent_id', 0)->get();
        $data['shop_categories'] = $this->get_shop_categories();
        //$data['vendor_products'] = VendorProduct::whereRaw("flags & ? = ?", [VendorProduct::FLAG_ACTIVE, VendorProduct::FLAG_ACTIVE])->with('product','category', 'brand')->get();

        //$this->test($data['vendor_products']);
        return view('frontend.shop.shop-product', $data);
    }

    public function child_categiries($id)
    {
        $cat = [];
        $categories = shop_categories::where("parent_id", $id)->get();
        foreach ($categories as $key => $c) {
            $cat[$key] = $c->id;
        }

        return $cat;
    }

    public function shop_price(Request $request)
    {
        $data['products'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
            ->where('parent_id', 0)
            ->whereBetween('sale_price', [$request->min, $request->max])
            ->with('shop_category')
            ->get();

        $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
        $data['selected'] = count($data['products']);
        $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
        return $data;

        //return view('frontend.shop.product-filter-ajax', $data);
    }

    public function shop_gender(Request $request)
    {

        $sizes = array();


        if ((int)$request->gender > 0) {

            $cd = $this->child_categiries($request->gender);
            $scat = ShopCategory::where("parent_id", (int)$request->gender)
                ->groupBy("shop_cat_slug")
                ->get();
            $sizes = Size::select(["sizes.*"])
                ->join("category_sizes", "category_sizes.size_id", "=", "sizes.id")
                ->whereIn("category_sizes.category_id", $cd)
                ->groupBy("sizes.id")
                ->get();
        }
        if (strlen($request->categories) > 1) {

            $ar = [];
            $shop_cats = ShopCategory::where("shop_cat_slug", $request->categories)->get();

            foreach ($shop_cats as $i => $sc) {
                $a[$i] = $sc->id;
            }

            $sizes = Size::select(["sizes.*"])
                ->join("category_sizes", "category_sizes.size_id", "=", "sizes.id")
                ->whereIn("category_sizes.category_id", $a)
                ->groupBy("sizes.id", "sizes.size")
                ->get();

            $scat = ShopCategory::where("parent_id", ">", 0)
                ->groupBy("shop_cat_slug")
                ->get();

        } else {

            // $sizes=Size::select(["sizes.*"])->get();
            // $sizes=Size::all();

            $scat = ShopCategory::where("parent_id", ">", 0)
                ->groupBy("shop_cat_slug")
                ->get();
        }
        $data["sizes"] = json_encode($sizes);
        $data["scat"] = json_encode($scat);


        if ((int)$request->gender > 0 && strlen($request->categories) > 1 && (int)$request->brand > 0) {

            $products = $this->child_categiries($request->gender);
            if ($products) {
                $p = Product::select(["products.*", "shop_categories.*", "products.id as id"])
                    ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                    ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
                    ->where("shop_categories.shop_cat_slug", $request->categories)
                    ->where("products.parent_id", 0)
                    ->whereIn("products.shop_category_id", $products)
                    //->where("products.shop_category_id", $request->categories)
                    ->where('products.brand_id', $request->brand);

                if (isset($request->sizes) && (int)$request->sizes > 0) {
                    $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                    $p->where("product_sizes.size_id", (int)$request->sizes);
                }


                $p->groupBy("products.id");
                $p->with('shop_category');


                $data['products'] = $p->get();
                // $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();
                // return view('frontend.shop.product-filter-ajax', $data);
                $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
                $data['selected'] = count($data['products']);
                $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
                return $data;
            }
        }


        if ((int)$request->gender > 0 && strlen($request->categories) > 1) {

            $products = $this->child_categiries($request->gender);

            $p = Product::select(["products.*", "shop_categories.*", "products.id as id"])
                ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
                ->where("shop_categories.shop_cat_slug", $request->categories)
                ->where("products.parent_id", 0)
                ->whereIn("products.shop_category_id", $products);
            if (isset($request->sizes) && (int)$request->sizes > 0) {
                $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                $p->where("product_sizes.size_id", (int)$request->sizes);
            }

            $p->with('shop_category');
            $p->groupBy("products.id");
            $data['products'] = $p->get();
            // $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();
            // return view('frontend.shop.product-filter-ajax', $data);
            $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
            $data['selected'] = count($data['products']);
            $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
            return $data;


        } elseif (strlen($request->categories) > 1 && (int)$request->brand > 0) {


            $p = Product::select(["products.*", "shop_categories.*", "products.id as id"])
                ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
                ->where("shop_categories.shop_cat_slug", $request->categories)
                ->where('products.parent_id', 0)
                // ->where("products.shop_category_id", $request->categories)
                ->where('products.brand_id', $request->brand);

            if (isset($request->sizes) && (int)$request->sizes > 0) {
                $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                $p->where("product_sizes.size_id", (int)$request->sizes);
            }

            $p->with('shop_category');
            $p->groupBy("products.id");
            $data['products'] = $p->get();
            //   $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();
            // return view('frontend.shop.product-filter-ajax', $data);
            $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
            $data['selected'] = count($data['products']);
            $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
            return $data;
        } elseif (strlen($request->categories) > 1) {

            $p = Product::select(["products.*", "shop_categories.*", "products.id as id"])
                ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
                ->where("shop_categories.shop_cat_slug", $request->categories)
                ->where('products.parent_id', 0);
            // ->where("products.shop_category_id", $request->categories)
            if (isset($request->sizes) && (int)$request->sizes > 0) {
                $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                $p->where("product_sizes.size_id", (int)$request->sizes);
            }


            $p->with('shop_category');
            $p->groupBy("products.id");
            $data['products'] = $p->get();
            $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
            $data['selected'] = count($data['products']);
            $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
            return $data;


        } elseif ((int)$request->brand > 0) {
            $p = Product::select(["products.*", "shop_categories.*", "products.id as id"])
                ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
                ->where('products.parent_id', 0)
                ->where('products.brand_id', $request->brand);
            if (isset($request->sizes) && (int)$request->sizes > 0) {
                $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                $p->where("product_sizes.size_id", (int)$request->sizes);
            }

            $p->with('shop_category');
            $p->groupBy("products.id");


            $data['products'] = $p->get();
            //   $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();
            // return view('frontend.shop.product-filter-ajax', $data);
            $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
            $data['selected'] = count($data['products']);
            $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
            return $data;
        } elseif ((int)$request->gender > 0) {


            $products = $this->child_categiries($request->gender);
            if ($products) {
                $p = Product::select(["products.*", "shop_categories.*", "products.id as id"])
                    ->whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                    ->join("shop_categories", "shop_categories.id", "=", "products.shop_category_id")
                    ->where('products.parent_id', 0)
                    ->whereIn("products.shop_category_id", $products);

                if (isset($request->sizes) && (int)$request->sizes > 0) {
                    $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                    $p->where("product_sizes.size_id", (int)$request->sizes);
                }

                $p->with('shop_category');
                $p->groupBy("products.id");
                $data['products'] = $p->get();
                //   $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();
                // return view('frontend.shop.product-filter-ajax', $data);
                $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
                $data['selected'] = count($data['products']);
                $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
                return $data;
            }
        } else {
            $p = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])
                ->where('parent_id', 0)
                ->groupBy("products.id");

            if (isset($request->sizes) && (int)$request->sizes > 0) {
                $p->join("product_sizes", "product_sizes.product_id", "=", "products.id");
                $p->where("product_sizes.size_id", (int)$request->sizes);
            }


            $p->with('shop_category');
            $p->groupBy("products.id");
            $data['products'] = $p->get();
            //   $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->get();
            // return view('frontend.shop.product-filter-ajax', $data);
            $data['count'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->with('shop_category')->count();
            $data['selected'] = count($data['products']);
            $data["html"] = view('frontend.shop.product-filter-ajax', $data)->render();
            return $data;


        }


    }

    //tester alwyas test
    public function test($data)
    {
        echo "<pre>";
        print_r($data);
        die;
    }

    //products-parent id
    public function get_parent_id_for_products($parent_id, $category)
    {
        $product_ids = \DB::table('product_cat_shops')->distinct()->where($category, $parent_id)->pluck('product_id')->toArray();
        //$this->test($parent_id);
        return $product_ids;
    }

    //get all products of thier parents according
    public function get_products($category_id)
    {

        $products = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('parent_id', 0)->whereIn('shop_category_id', $category_id)->with('shop_category', 'multi_images', 'prod_size.size')->get();
        return $products;
    }

    public function start_selling_home()
    {
        return view('frontend.home.start-selling');
    }

    //get all parents
    public function get_parent()
    {
        $parents_data = \DB::table('shop_categories')->whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->where('parent_id', 0)->pluck('id')->toArray();
        return $parents_data;
    }

    // this will provide all shop categories
    public function get_shop_categories()
    {
        // $this->test($parents);
        $shop_categery = \DB::table('shop_categories')->whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->get();
        return $shop_categery;
    }

    //this funtion for shop category id and it will provide all products ids
    public function get_product_cat_shop($id)
    {

        $product_ids = \DB::table('product_cat_shops')->distinct()->where('shop_cat_id', $id)->pluck('product_id')->toArray();
        return $product_ids;
    }

    //you need shop category and this will give full data
    public function get_slug($slug)
    {
        $child_category = \DB::table('shop_categories')->where('shop_cat_slug', $slug)->whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->first();

        return $child_category;
    }

    public function wishlist()
    {
        $data['wishlists'] = array();
        if (auth()->check()) {
            $data['wishlists'] = Wishlist::select(["wishlists.*", "size"])
                ->where('user_id', auth()->user()->id)
                ->join("sizes", "sizes.id", "=", "wishlists.size_id")
                ->with('user', 'product')->get();
        }


        //$this->test($data['wishlists']);
        return view('frontend.wishlist.wishlist', $data);
    }

    public function view_all_brands()
    {
        $data['brands'] = Brand::whereRaw("flags & ? = ?", [Brand::FLAG_ACTIVE, Brand::FLAG_ACTIVE])->orderBy('brand_name')->get();
        return view('frontend.brand.view-all-brands', $data);
    }

    public function register_user(Request $request)
    {

        $request->validate([
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email|unique:users',
            'password' => [
                'required',
                'string',
            ],
            'confirm_password' => 'required|same:password',

        ]);
        $user = new User();
        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->phone = (!empty($request->phone) ? $request->phone : null);
        $user->gender = (!empty($request->gender) ? $request->gender : null);
        $user->addFlag(User::FLAG_ACTIVE);
        $user->user_type = 2;
        $user->save();
        $request_vendor = new RequestVendor();
        $request_vendor->request_become_a_vendor = true;
        $request_vendor->user_id = $user->id;
        $request_vendor->flags = 2;
        if ($request_vendor->save()) {
            if (Auth::attempt(['email' => $request->email, 'password' => $request->password, 'flags' => 1])) {

                return redirect(route('update_account'));
            }

            //return back()->with(['message' => "User Register Successfully And Become A Vendor Request Is Successful"]);
        } else {
            return back()->with(['error' => "User Is not Valid Please Try Again"]);
        }
    }

    public function register_users(Request $request)
    {
        $request->validate([
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email|unique:users',
            'password' => [
                'required',
                'string',
            ],
            'confirm_password' => 'required|same:password',

        ]);
        $user = new User();
        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->phone = (!empty($request->phone) ? $request->phone : null);
        $user->gender = (!empty($request->gender) ? $request->gender : null);
        $user->addFlag(User::FLAG_ACTIVE);
        $user->user_type = 0;
        $user->save();
        $request_vendor = new RequestVendor();
        $request_vendor->request_become_a_vendor = true;
        $request_vendor->user_id = $user->id;
        $request_vendor->flags = 2;
        if ($request_vendor->save()) {
            if (Auth::attempt(['email' => $request->email, 'password' => $request->password, 'flags' => 1])) {

                return redirect(route('update_account'));
            }

            //return back()->with(['message' => "User Register Successfully And Become A Vendor Request Is Successful"]);
        } else {
            return back()->with(['error' => "User Is not Valid Please Try Again"]);
        }
    }

    public function product_brand($id)
    {
        $data["brand_id"] = $id;
        $data['brand'] = Brand::whereRaw("flags & ? = ?", [Brand::FLAG_ACTIVE, Brand::FLAG_ACTIVE])->where('id', $id)->first();
        $data['products'] = Product::whereRaw("flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE])->where('brand_id', $id)->with('brand')->get();
        $data['parent_categories'] = ShopCategory::whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->where('parent_id', 0)->get();

        return view('frontend.brand.brand', $data);
    }

    public function privacy_policy()
    {
        return view('frontend.home.privacy-policy');
    }

    public function buying()
    {
        return view('frontend.home.buying');
    }

    public function add_cart(Request $request)
    {
        $status = "true";

        $product = ProductSize::where("product_sizes.id", $request->product_id)
            ->join("products", "products.id", "=", "product_sizes.product_id")
            ->first();

        if (isset(auth::user()->id)) {


            $cart = Cart::where(["product_id" => $product->product_id, "variation_id" => $request->product_id, "user_id" => auth::user()->id])->get();

            if (count($cart) > 0) {
                Cart::where('id', $cart[0]->id)
                    ->update(['quantity' => \DB::raw('quantity + 1'), "size_id" => $product->size_id]);
            } else {

                $cart = new Cart();
                $cart->product_id = $product->product_id;
                $cart->variation_id = $request->product_id;
                $cart->user_id = auth::user()->id;
                $cart->quantity = 1;
                $cart->size_id = $request->size_id;
                $cart->save();
            }
        } else {

            $status = "false";
        }


        return response()->json([

            "status" => $status


        ]);
    }

    public function admin_cart(Request $request)
    {
        $status = "true";


        if (isset(auth::user()->id)) {


            $cart = Cart::where(["product_id" => $request->product_id, "size_id" => $request->size_id, "user_id" => auth::user()->id])->get();
            if (count($cart) > 0) {


                Cart::where('id', $cart[0]->id)
                    ->update(['quantity' => \DB::raw('quantity + ' . $request->quantity), "size_id" => $request->size_id, "variation_id" => $request->variation]);
            } else {
                $cart = new Cart();
                $cart->product_id = $request->product_id;
                $cart->user_id = auth::user()->id;
                $cart->quantity = $request->quantity;
                $cart->size_id = $request->size_id;
                $cart->variation_id = $request->variation;
                $cart->save();
            }
        } else {


            $status = "false";
        }

        return response()->json([

            "status" => $status


        ]);
    }

    public function back($product_id = 0, $variation_id, $cancel = 1)
    {

        return $this->single_page($product_id, $cancel, $variation_id);
    }

    public function search_title(Request $request)
    {

        $values = $request->all();
        $records = Product::whereRaw("products.flags & ? = ?", [Product::FLAG_ACTIVE, Product::FLAG_ACTIVE]);

        if (strlen($values["search"]) > 0) {
            $records->where('product_name', 'like', '%' . $values["search"] . '%');
        }

        $records->where('parent_id', 0);

        if (strlen($values["sort"]) > 0) {
            if ($values["sort"] == "newness") {
                $records->orderBy('products.id', 'desc');

            } elseif ($values["sort"] == "popularity") {
                $records->leftjoin("order_details", "order_details.product_id", "=", "products.id");
                $records->groupBy("products.id");
                $records->select("products.*", DB::raw('COUNT(order_details.product_id) as count'));
                $records->orderBy(DB::raw('COUNT(order_details.product_id)'), 'asc');
            } elseif ($values["sort"] == "low_to_high") {
                $records->where('products.sale_price', '>', 0);
                $records->orderBy('products.sale_price', 'asc');

            } elseif ($values["sort"] == "high_to_low") {
                $records->orderBy('products.regular_price', 'desc');
                $records->orderBy('products.sale_price', 'desc');
            }
        } else {
            $values["sort"] = "default";
        }

        $records->with('shop_category');
        $data['products'] = $records->get();
        $data['parent_categories'] = ShopCategory::whereRaw("flags & ? = ?", [ShopCategory::FLAG_ACTIVE, ShopCategory::FLAG_ACTIVE])->where('parent_id', 0)->get();
        $data['shop_categories'] = $this->get_shop_categories();
        $data['search'] = $values["search"];

        $data["sort"] = $values["sort"];


        return view('frontend.shop.shop-product', $data);

    }

    public function sizes()
    {

        $sizes = Size::all();

        foreach ($sizes as $size) {
            $s = Size::find($size->id);
            $s->size_id = $size->id;
            $s->save();
        }

        echo "Done";
    }

    public function lost_password()
    {
        return view("lost_password");
    }

    public function lost_email(Request $request)
    {
        $user = User::where("email", $request->email)->get();


        if (count($user) == 0) {


            return redirect()->back()->with('error', 'Email Does not exist');


        }
        $da = rand(100, 100000);


        $details = [

            'title' => 'Mail from Market-place',

            'body' => 'Changing password market-place',
            'da' => $da


        ];


        $user = User::find($user[0]->id);
        //$user->password = Hash::make($request->password);
        $user->otp = $da;
        $user->save();


        //\Mail::to($request->email)->send(new \App\Mail\MyTestMail($details));

        return view('change_password', ["user" => $user]);

        //return redirect()->back()->with('message', 'Password changed successfully');
    }

    public function change_passwords(Request $request)
    {
        $data = $request->all();

        $users = User::where(["id" => $data["id"], "otp" => $data["otp"]])->get();

        if (count($users) > 0) {


            $user = User::find($data["id"]);
            $user->password = Hash::make($data["password"]);
            $user->save();

            return redirect()->route("login.login")->with('message', 'Password changed successfully');
        }

        return redirect()->route("login.login")->with('error', 'OTP does not match');
    }

    public function comingSoonPage()
    {
        return view('frontend.home.coming-soon');
    }

    public function terms_condition()
    {
        return view('frontend.home.terms-condition');
    }

    public function faq()
    {
        return view('frontend.home.faq');
    }

    public function about_us()
    {
        return view('frontend.home.about-us');
    }

    public function contact_us()
    {
        return view('frontend.home.contact-us');
    }

    public function thankyou($id)
    {
        return view('thankyou', ["reference" => $id]);
    }

    public function vendor_agreement_policy()
    {
        return view('frontend.home.vendor-agreement-policy');
    }

    public function copyright_policy()
    {
        return view('frontend.home.copyright-policy');
    }

    public function shipping_policy()
    {
        return view('frontend.home.shipping-policy');
    }

    public function return_refund()
    {
        return view('frontend.home.return-refund');
    }

    public function disclaimer()
    {
        return view('frontend.home.disclaimer');
    }


}
