<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Size;
use App\Models\ShopCategory;
use App\Models\CategorySize;
use App\Models\ProductSize;



class SizeController extends Controller
{

    public function index(){
        // echo 'sdasd';
           $data['data'] = Size::orderBy('size_id','DESC')->get()->toArray();

        
           return view('admin.size.sizeHome',$data);
      }
  
        public function addSize(){

             return view('admin.size.addSize');
        } 
  
         public function sizeProcess(Request $request){
  
         

           
          if($request->id) {
            $size = Size::where('id', $request->id)->get()->first();
            // print_r($checkSize);
            // die;
            $size->size = $request->name;
            $size->size_id=$request->size_id;
            if($size->save()){
                return redirect(route('size-home'))->with(["message" => "Size Update Successfully"]);
            }else{
                return redirect(route('size-home'))->with(["error" => "Something Wrong, Please Try Again"]);
            }

          } else {
            $size = new Size();
            $size->size = $request->name;           
            $size->addFlag(Size::FLAG_ACTIVE);
            if($size->save()){
                
                
                $sc=Size::find($size->id);
                $sc->size_id=$size->id;
                $sc->save();
                return redirect(route('size-home'))->with(["message" => "Size Added Successfully"]);
            }else{
                return redirect(route('size-home'))->with(["error" => "Something Wrong, Please Try Again"]);
            }

          } 
  
        }

        public function category_size(){
            return view('admin.size.view-category-size');
        }

        public function add_category_size(){
            $data['shop_cats'] = ShopCategory::where('parent_id', '<>','0')->get();
            $data['sizes'] = Size::get();
            return view('admin.size.add-category-size',$data);
        }

        public function category_size_process(Request $request){
           
            foreach($request->sizes as $size){
                $category_size = new CategorySize();
                $category_size->category_id = $request->category;
                $category_size->size_id = $size;
                $category_size->save();
            }
            
        }


        public function editSize($id) {



            $data['size'] = Size::where('id', $id)->get()->first()->toArray();
            // print_r($data['size']);
            // die;
            return view('admin.size.edit', $data);
        }

        public function deleteSize($id) {
            $size = ProductSize::where('size_id', $id)->delete();
            $size = Size::where('id', $id)->delete();
            if($size){
                return redirect(route('size-home'))->with(["message" => "Size Deleted Successfully"]);
            }else{
                return redirect(route('size-home'))->with(["error" => "Something Wrong, Please Try Again"]);
            }
        }
        
  
}
