<?php

namespace App\Imports;

use App\Models\Brand;
use App\Models\CategorySize;
use App\Models\Product;
use App\Models\ProductSize;
use App\Models\ShopCategory;
use App\Models\ProductColor;
use App\Models\ProductImage;
use App\Models\Size;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use DB;

class ImpProducts implements ToModel, WithChunkReading, WithHeadingRow, WithValidation
{
    use Importable;

    /**
     * @param array $row
     * @return \Illuminate\Database\Eloquent\Model|null
     */

    public function model(array $row)
    {
        try {

            $is_deleted = strtolower($row['is_deleted'] ?? '');
            $gender = ['Mens' => 'Menswear', 'Menswear' => 'Menswear', 'Womens' => 'Womenswear', 'Womenswear' => 'Womenswear', 'Children' => 'Children', 'Nightwear' => 'Nightwear'];
            $product = Product::where('sku', $row['skuproduct'])->first() ?: new Product();
            $is_feature_image = true;

            //start delete products if flag is delete
            if ($is_deleted === 'deleted' || $is_deleted === 'delete') {
                if ($id = $product->id ?? '') {

                    //remove files
                    @unlink(storage_path("app/public/product/" . $id . '/' . $product->feature_image));

                    //remove relations and product
                    ProductSize::where('product_id', $id)->delete();
                    ProductColor::where('product_id', $id)->delete();
                    ProductImage::where('product_id', $id)->delete();
                    Product::where('parent_id', $id)->delete();
                    Product::where('id', $id)->delete();
                }

                return null;
            }
            //end delete products if flag is delete

            $brand_id = Brand::where('brand_name', trim($row['brand']))->first()->id ?? 0;
            $gender_id = ShopCategory::where("parent_id", 0)->where('shop_cat_name', $gender[$row['gender']] ?? '')->first()->id ?? 0;
            $shop_category_id = ShopCategory::where("parent_id", $gender_id)->where('shop_cat_name', trim($row['category']))->first()->id ?? 0;
            $categorysize = CategorySize::where('category_id', $shop_category_id)->with('size')->get()->pluck('size.id', 'size.size')->toArray();
            $size_and_qty = $this->addSizeQty($row, $categorysize, $shop_category_id);

            //if brand category and gender not found product will not be created
            if($brand_id == 0 || $shop_category_id == 0 || $gender_id == 0){
                return null;
            }

            $product->product_name = $row['product_name'];
            $product->product_description = preg_replace('/_x([0-9a-fA-F]{4})_/', '<br/>', $row['product_description']);;
            $product->regular_price = $row['price'];
            $product->sale_price = $row['salesprice'];
            $product->brand_id = $brand_id;
            $product->shop_category_id = $shop_category_id;
            $product->addFlag(Product::FLAG_ACTIVE);

            if ($product->save()) {

                $product->sku = $row['skuproduct'];

                if (count($size_and_qty) > 0) {

                    //delete old size and qty
                    //ProductSize::where('product_id', $product->id)->delete();
                    DB::table('product_sizes')->where('product_id', $product->id)->delete();

                    foreach ($size_and_qty as $name => $size_qty) {

                        $product_size = new ProductSize();
                        $product_size->size_id = $size_qty['size_id'];
                        $product_size->quantity = $size_qty['quantity'];
                        $product_size->product_id = $product->id;
                        $product_size->addFlag(ProductSize::FLAG_ACTIVE);
                        $product_size->save();
                    }
                }

                if (empty($product->feature_image)) {

                    if (!file_exists(storage_path("app/public/product/" . $product->id))) {

                        mkdir(storage_path("app/public/product/" . $product->id), 0777, true);
                    }


                    $images_url = preg_split('/\r\n|\r|\n/', $row['images']);

                    foreach ($images_url as $image_url) {

                        if (!empty($image_url)) {

                            if ($is_feature_image) {

                                $product->feature_image = $this->addFile($image_url, storage_path("app/public/product/" . $product->id));
                                $product->save();
                                $is_feature_image = false;

                            } else {

                                $product_image = new ProductImage();
                                $product_image->image = $this->addFile($image_url, storage_path("app/public/product/" . $product->id));
                                $product_image->product_id = $product->id;
                                $product_image->addFlag(ProductColor::FLAG_ACTIVE);
                                $product_image->save();
                            }
                        }
                    }
                }

                if (!$is_feature_image) {

                    $product->save();
                }

            } else {

                //dd($product->errors()->toArray());
            }

            return $product;

        } catch (\Exception $ex) {

            //dd($ex->getMessage());
        }
    }

    public function rules(): array
    {
        return [
            '*.skuproduct' => 'required',
            '*.product_name' => 'required',
            '*.price' => 'required',
        ];
    }

    private function addFile($url, $dest): string
    {
        if ($url) {

            $feature_image = file_get_contents($url);
            $extension = pathinfo($url, PATHINFO_EXTENSION);
            $extension = str_replace(strstr($extension, "?"), '', $extension);
            $name = rand(9999, 99999) . '.' . $extension;

            file_put_contents($dest . '/' . $name, $feature_image);

            return $name;
        }

        return '';
    }

    public function chunkSize(): int
    {
        return 500;
    }

    public function addSizeQty($row, $categorysize, $shop_category_id): array
    {
        //make qty by size and by product
        $size_and_qty = [];

        //add a new size
        for ($i = 1; $i <= 19; $i++) {
            if (!empty($row["size_$i"]) && !(isset($categorysize[$row["size_$i"]]))) {

                //create a new size which is not in DB
                $size = Size::where('size', $row["size_$i"])->first() ?: new Size();
                $size->size_id = $size->size = $row["size_$i"];
                $size->flags = Size::FLAG_ACTIVE;

                if ($size->save()) {

                    $category_size = CategorySize::where('category_id', $shop_category_id)->where('size_id', $size->id)->first() ?: new CategorySize();
                    $category_size->category_id = $shop_category_id;
                    $category_size->size_id = $size->id;
                    $category_size->flags = ShopCategory::FLAG_ACTIVE;
                    $category_size->save();
                }
            }
        }

        $categorysize = CategorySize::where('category_id', $shop_category_id)->with('size')->get()->pluck('size.id', 'size.size')->toArray();

        foreach ($categorysize as $name => $size_id) {

            for ($i = 1; $i <= 19; $i++) {

                //if size defined in the sheet add qty 100 else 0
                if (trim($name) == trim($row["size_$i"])) {

                    $size_and_qty[$name] = ['size_id' => $size_id, 'quantity' => 100];
                    break;

                } else {

                    $size_and_qty[$name] = ['size_id' => $size_id, 'quantity' => 0];
                }
            }
        }

        return $size_and_qty;
    }
}
