<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Concerns\Flagable;
class Brand extends Model
{
    use  HasFactory,Flagable;

    protected $appends = [
      'active','image_url'
    ];

    public const STATUS_ACTIVE = 'active';
    public const STATUS_NOT_ACTIVE = 'not-active';
    public const FLAG_ACTIVE = 1;

    public function getActiveAttribute() {
        return ($this->flags & self::FLAG_ACTIVE) == self::FLAG_ACTIVE;

    }
    public function getImageUrlAttribute()
    {
        return url('/').'/storage/brands/'.$this->id.'/'.$this->image;
    }
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
