@extends('frontend.shop.product-master')
@php  $brandssa  = $brand->brand_name; @endphp
@section('title')
{{$brand->brand_name}} - The Marketplace
@endsection
@section('banner')

<div class="inner-banner">
    <h1 class="dark-heading">The Marketplace</h1>
    <h1 class="page-title">{{$brand->brand_name}}</h1>
</div>


<div class="modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" id="search-popup">
    <div class="modal-dialog  modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <div class="search-wrapper">
                    <div class="form-group m-0">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search.." aria-label="Username"
                                aria-describedby="basic-addon1">
                            <div class="input-group-append">
                                <span class="input-group-text">
                                    <div class="typing-indicator">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </span>
                                <span class="input-group-text" id="basic-addon1"><i class="uil uil-search"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="show_all_results">
                        <div class="emptyresult">Nothing Found For : </div>
                        <a href="#" class="productsearchlink"> dsf</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('products-content')        
        @if(!$products->isEmpty())       
            <section>
      
            <div class="products-wrapper">
                @foreach($products as $product)
                    <div class="card product-card">

                        <div class="card-header">

                            <a href="{{ route('single-product', ['id' => $product->id]) }}"
                                class="d-block">
                                <div class="img-box">
                                    <img data-src="{{ $product->image_url }}" class="img-fluid lazy ">
                                </div>
                                <div class="tags">
                                    <span class="discount-tag">-{{ $product->discount }}%</span>
                                    <span class="new-tag">New</span>
                                </div>
                                {{-- <span class="out-of-stock">Out of Stock</span> --}}
                            </a>
                        </div>
                        <div class="card-body">
                            <div class="product-category">
                             {{--   @forelse($product->prod_shop_cat as $cat)
                                    <a href="{{ $cat->shop_cat->shop_cat_slug }}">
                                        {{ $cat->shop_cat->shop_cat_name }}</a>
                                @empty
                                    <a href="">No Categories</a>
                                @endforelse --}}
                            </div>
                            <a href="{{ route('single-product', ['id' => $product->id]) }}"
                                class="product-title">{{ $product->product_name }}</a>
                            <span class="discounted-price">£{{ $product->sale_price }}</span>
                            <span class="real-price">£{{ $product->regular_price }}</span>
                        </div>
                    </div>
                @endforeach
            </div>
        </section>
        @else
        <section>
            <div class = "row">
                <div class="col-md-10 text-center" style = "margin-top:15%">
                <p>No products were found matching your selection.</p>
                
                <a href="{{route('shop_products')}}" class="back-to-shop no_djax btn btn-primary">Back to shop</a>
                </div>
                
                
               
            </div>
        </section>
        @endif
</main>
@endsection

