@extends('layouts.frontend.master')
@section('title', 'News - The Marketplace')
@section('banner')
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css"
          rel="stylesheet"
          integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC"
          crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css">

    <div class="inner-banner shop2">
        <h1 class="page-title"  style="color: #ffff;">News</h1>
    </div>

@endsection
@section('content')

    <main class="news-page">

        <div class="container">
          

            <div class="post-filter-menu">
                <label for="news_filter"  class="control-label">Filter:</lable>
                
                    <select name="news_filter" id="news_filter" class="form-control" onchange="newsFilter(this.value)" placeholder="filter">
                            <option selected value="Most Viewed">Most Viewed</option>
                            <option value="Most Recent">Most Recent</option>
                            <option value="Featured">Featured</option>
                            <option value="Top Trending">Top Trending</option>
                    </select>
            </div>
            
            <div class="cat-heading">
                <h2>Most Viewed</h2>
            </div>
    
            
            <div class="carousel slide" id="carousel-news-slider">

                <div class="carousel-inner">

                     @foreach($slider_news as $i => $s_news)

                         <div class="item {{$i == 0 ? ' active ' : ''}}">

                            <div class="col-md-12">
                                <div class="main_slider_image">
                                     <img src="{{get_image($s_news->news_image_url, 'default-news.jpeg')}}" class="img-fluid" alt="">
                                </div>
                             </div>
                         </div>
                     @endforeach

                    </div>

                  <a class="left carousel-control" href="#carousel-news-slider" data-slide="prev"><i class="glyphicon glyphicon-chevron-left"></i></a>
                  <a class="right carousel-control" href="#carousel-news-slider" data-slide="next"><i class="glyphicon glyphicon-chevron-right"></i></a>
            </div>
            
            
   
                        

            @foreach($all_news as $news)

                <div class="post-item">
                    <div class="post-img">
                        <a href="{{route('single.news',[$news->news_slug])}}">
                            <img src="{{get_image($news->news_image_url, 'default-news.jpeg')}}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="post-details">

                        <div class="post-brand"><a href="#">{{$news->brand->brand_name}}</a></div>
    
                        <div class="post-author">
                            <cite title="Source Title" class="pr-5">{{date("F d,Y", strtotime($news->created_at))}}</cite>
                        </div>
                        
                        <h2>{{$news->title}}</h2>
    
                        <div class="post-description">
                        {{substr(strip_tags($news->description), 0, 90)}}...
                        </div>
                        
                        <a class="readmore-btn" href="{{route('single.news',[$news->news_slug])}}">Read More</a>
    
                    </div>
                </div>
            @endforeach
            


            @if($all_news->count() < 1)
                <div class="pagination justify-content-center">{{ __('No record found.') }}</div>
            @endif

        </div>
        
         <div class="container">
            <div class="row">
                <div class="pagination mt-3">{{$all_news->links('pagination::bootstrap-4')}}</div>
            </div>
        </div>
        

        {{--Slider--}}
        <h1 class="RN">Brands</h1>

        <div class="container">
            @if(isset($brands))
                <div class="row">
                    <div class="col-md-12">
                        <div class="carousel carousel-showmanymoveone slide" id="carousel-news-brands">

                            <div class="carousel-inner">

                                @foreach($brands as $i => $brand)

                                    <div class="item {{$i == 0 ? ' active ' : ''}}">

                                        <div class="col-xs-12 col-sm-6 col-md-3">
                                            <div class="card">
                                                <img class="card-img-top img-fluid img-responsive" src="<?php echo (!empty($brand->image) ? $brand->image_url : 'assets/images/product-placeholder.png'); ?>" alt="Card image cap">
                                                <div class="card-body">
                                                    <a href="{{route('product.brand',[ $brand->id ] )}}" class="content">
                                                        {{--                                                    <a href="{{route('brands-news',[ $brand->brand_slug ] )}}" class="content">--}}
                                                        <h4 class="card-title">{{$brand->brand_name}}</h4>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>

                            <a class="left carousel-control" href="#carousel-news-brands" data-slide="prev"><i class="glyphicon glyphicon-chevron-left"></i></a>
                            <a class="right carousel-control" href="#carousel-news-brands" data-slide="next"><i class="glyphicon glyphicon-chevron-right"></i></a>
                        </div>
                    </div>
                </div>

            @else

                <div class="item">
                    <div class="card">
                        <h5 class="brand-title">No brands</h5>
                    </div>
                </div>

            @endif
        </div>

    </main>

    <script>

        function isImage(url) {
            return /\.(jpg|jpeg|png|webp|avif|gif|svg)$/.test(url);
        }

        function redi(name) {
            window.location = location.pathname + "/brand/" + name;
        }
        
        function newsFilter(name){
            
            localStorage.setItem("filter", name);
            window.location = '{{route('news')}}' + '?filter=' + name;
        }
        
    </script>

    <script>

        $(document).ready(function() {
            
            //re-select dd value
            $('#news_filter').val(localStorage.getItem('filter'));
            $('.cat-heading').html('<h2>' + localStorage.getItem('filter') + '</h2>');
            
            /* setup your carousels as you normally would using JS
            or via data attributes according to the documentation
            https://getbootstrap.com/javascript/#carousel */
            $('#carousel-news-brands').carousel({interval: 3600});
            
            $('#carousel-news-slider').carousel({interval: 3600});
            

            $('.carousel-showmanymoveone .item').each(function() {
                let itemToClone = $(this);

                for (let i = 1; i < 4; i++) {
                    itemToClone = itemToClone.next(); 

                    // wrap around if at end of item collection
                    if (!itemToClone.length) {
                        itemToClone = $(this).siblings(':first');
                    }

                    // grab item, clone, add marker class, add to collection
                    itemToClone.children(':first-child').clone().addClass("cloneditem-" + (i)).appendTo($(this));
                }
            });

        });

    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/js/bootstrap.min.js"></script>

@endsection
