<?php

use Illuminate\Support\Carbon;

?>

@extends('layouts.frontend.master')
@section('title')
The Marketplace
@endsection
@section('banner')
@endsection
@section('content')


<?php


$recent_products = Cookie::get('recentViews');
$user_id = 0;
if ($recent_products) {
  $recent_products .= ',' . $data->product_id;
  Cookie::queue('recentViews', $recent_products, 86400);
} else {
  Cookie::queue('recentViews', $product->id, 86400);
  $recent_products = $product->id;
}
$recent_prod_array = array_unique(explode(",", $recent_products));
$recent_view_products = \App\Models\Product::whereIn('id', $recent_prod_array)->get();
$current_url = URL::current();
$reviews = 0;

if (auth()->user()) {
  $user_id = auth()->user()->id;
}
?>




<main class="product-page pb-0">
  <div class="container pt-5">

    <div class="product-layout used-product-layout">
      <div class="column images-column">
        <div class="inner-wrapper">
          <div class="img-box">
            <img src="{{url('/').'/storage/seller-product/'.$data->id.'/'.$data->feature_image}}" class="-img-fluid">
          </div>
          @foreach($multiimages as $mi)
          <div class="img-box">
            <img src="{{url('/').'/storage/seller-product/'.$mi->product_id.'/'.$mi->image}}" class="-img-fluid">
          </div>
          @endforeach

        </div>
        {{-- <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="#">Brand</a></li>
              <li class="breadcrumb-item"><a href="#">Sub Brand</a></li>
              <li class="breadcrumb-item active" aria-current="page">Wmns Air Jordan 4 Retro 'Shimmer'</li>
            </ol>
          </nav> --}}
      </div>
      <div class="column product-details-column">
        <div class="heading-area">
          {{-- <h4 class="text-dark mb-0">{{$data->product_name}}</h4> --}}
          <h4 class="text-dark mb-0">{{$data->product_parent->product_name}}</h4>
          {{-- <a href="#">{{$data->product_parent->shop_category->shop_cat_name}}</a> --}}
        </div>
        {{-- <hr class="underline"> --}}
        <div class="used-product-details pt-0">
          <div class="table-box">
            <div class="table-responsive">
              <table class="table">
                {{-- <tr>
                      <td>Product Name</td>
                      <td>{{$data->product_name}}</td>
                </tr> --}}
                <tr>
                  <td>Price</td>
                  <td>£{{number_format($data->sale_price, 2) ?? 0}}</td>
                </tr>
                <tr>
                  <td>Size</td>
                  <td>{{$data->size}}</td>
                </tr>
                <tr>
                  <td>Condition</td>
                  <td>{{$data->condition}}</td>
                </tr>
                <tr>
                  <td>Faults</td>
                  <td>{{rtrim($all_faults)}}</td>
                </tr>


                {{-- <tr>
                      <td>Color</td>
                      <td>Tan</td>
                    </tr> --}}

                {{-- <tr>
                      <td>Product Type</td>  
                      <td>@if($data->flage==1) New @else Used @endif</td>
                    </tr> --}}
              </table>
            </div>
          </div>

          <div class="buttons-wrapper">
            <a href="{{route('back',[$data->product_parent->id, $id])}}" class="btn cancel">Cancel</a>
            {{-- <a href="#" class="btn" onclick="previous();">Cancel</a> --}}
            {{-- <button class="btn" onclick="previous();">Cancel</button> --}}
            <a href="#" class="btn cart-btn" onclick="cart({{$id}});">Add To Cart</a>
          </div>
        </div>


      </div>
    </div>


    <div class="social">
      <p class="mr-3">Share</p>
      <p>
        <a href="#"><i class="fab fa-facebook-f"></i></a>
        <a href="#"><i class="fas fa-envelope"></i></a>
        <a href="#"><i class="fab fa-twitter"></i></a>
        <a href="#"><i class="fab fa-pinterest"></i></a>
      </p>
    </div>

    <div class="product-info">
      <div class="">
        <p><span>Category:</span> <a href="#">{{$data->product_parent->shop_category->shop_cat_name}}</a></p>
      </div>
      <div class="">
        {{-- <p><span>Sold By: </span><a href="#">{{$data->product_user->first_name}} {{$data->product_user->last_name}}</a></p> --}}
      </div>
      <div class="">
        <p><span>SKU: </span> {{$data->product_parent->sku}}</p>
      </div>
    </div>

    <div class="product-description">
      <h6>Product Description</h6>
      {!!$data->product_parent->product_description!!}
    </div>
    {{--
      <div class="related-products">
        <h5 class="heading-5">Related Products</h5>

        <div class="products-wrapper">

        @forelse($related as $related_products)
          <div class="card product-card">
            <div class="card-header">
              <a href="#" class="d-block">
                <div class="img-box">
                  <img src="assets/images/childern-product-1.jpg" class="img-fluid">
                </div>
                <div class="tags">
                  <span class="discount-tag">{{ $related_products->discount }}%</span>
    <span class="new-tag">New</span>
  </div>

  </a>
  </div>
  <div class="card-body">
    <div class="product-category">
      <a href="{{route('product.category',['slug'=>$related_products->shop_category->shop_cat_slug])}}">
        {{ $related_products->shop_category->shop_cat_name }}</a>
    </div>
    <a href="#" class="product-title">{{$related_products->product_name}}</a>
    <span class="discounted-price">£{{ $related_products->sale_price }}</span>
    <span class="real-price">£{{$related_products->regular_price}}</span>
  </div>
  </div>
  @empty
  <div class="item">
    <div class="card product-card">
      <div class="card-header">
        <p>No Man's Product</p>
      </div>
    </div>
  </div>

  @endforelse




  </div>
  </div>

  --}}

  <div class="related-products">
    <h5 class="heading-5">Related Products</h5>

    <div class="owl-carousel owl-theme product-slider" id="slider-men-new">
      @foreach($related as $product)

      <?php


						// Creates DateTime objects
						$datetime1 = date_create($product->created_at);
						$datetime2 = date_create(Carbon::now());

						// Calculates the difference between DateTime objects
						$interval = date_diff($datetime1, $datetime2);

						// Printing result in years & months format
						$diff = (int)$interval->format('%a');


						// dd($product->created_at);

						?>

						<div class="card product-card">
							<div class="card-header">
								<a href="{{ route('single-product', ['id' => $product->id]) }}" class="d-block">
									<div class="img-box">
										<img data-src="{{ $product->image_url }}" class="img-fluid lazy ">
									</div>
									<div class="tags">
										@if((int)$product->discount>0)
										<span class="discount-tag"> -{{ $product->discount }}% </span>
										@endif
										@if($diff<=14) <span class="new-tag">New</span>
											@endif
									</div>

								</a>
							</div>
							<div class="card-body" style="text-align:center;">
								<div class="product-category">

									{{-- <a href="{{route('product.category',['slug'=>$product->shop_category->shop_cat_slug])}}">
									{{ $product->shop_category->shop_cat_name }}</a> --}}
									<a href="">
									</a>
								</div>
								<a href="{{ route('single-product', ['id' => $product->id]) }}" class="product-title">{{ $product->product_name }}</a>
								@if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price)
								<span class="discounted-price">£{{number_format($product->sale_price,2) }}</span>
								<span class="real-price">£{{number_format($product->regular_price,2) }}</span>
								@else

								<span class="discounted-price">£{{number_format($product->regular_price,2) }}</span>

								@endif


							</div>
						</div>
      
      @endforeach

    </div>




  </div>







</main>


<div class="alert alert-dismissible fade " role="alert">
  <button id="error_model" type="button" class="close buttonAlert" data-dismiss="alert" aria-label="Close" onclick="closeup()">
    <i class="uil uil-multiply"></i>
  </button>
  <p style="text-align:center;" class="displayContent"></p>

</div>



{{--
  <div class="fixed-buttons">
    <a href="#header" class="btn white-btn go-top"><i class="fas fa-caret-up"></i></a>
    
    
    <a href="#" class="btn blue-btn" style="border-left: 1px solid #25252d;">buy used</a>
    <a href="#" class="btn blue-btn">buy new</a>
  </div> --}}


@endsection



<script>
  function previous() {


    //window.history.back()
    window.history.back();
    //alert("Anas");



  }


  function cart(id) {

    $.ajax({
      url: "{{ route('add_cart') }}",
      method: 'post',
      data: {
        "_token": "{{ csrf_token() }}",
        product_id: id,

      },
      success: function(result) {

        if (result.status == "true") {
          $('.alert-dismissible').addClass('success-alert');
          $('.alert-dismissible').addClass('show').find('p').html("Product added to the cart");
          parent.location.reload();
        } else {
          // swal({
          // title: "Please login first",
          // type: "error",
          // confirmButtonClass: "btn-success",
          // confirmButtonText: "OK",

          // },
          // function() {

          // });
          var lo = "<?php echo route('login.login'); ?>";
          $('.alert-dismissible').addClass('success-alert');
          $('.alert-dismissible').addClass('show').find('p').html('User must be logged in. Click <a style="color:#00A9EC !important;" href="' + lo + '">here </a> to sign in');

        }




      }
    });

  }

  function closeup() {
    var login = '<?php echo route("login.login");  ?>';
    window.location.href = login;
  }
</script>