

<?php
use Illuminate\Support\Carbon;

?>
@extends('frontend.shop.product-master')
@section('products-content')
@if(!$products->isEmpty())
<section>
    <div class="products-wrapper">

        @foreach($products as $key=>$product)

        <?php 


    // Creates DateTime objects
  $datetime1 = date_create($product->created_at);
  $datetime2 = date_create(Carbon::now());
 
  // Calculates the difference between DateTime objects
  $interval = date_diff($datetime1, $datetime2);
 
  // Printing result in years & months format
  $diff=(int)$interval->format('%a');
   

       // dd($product->created_at);

        ?>
        <div class="card product-card">
            <div class="card-header">
                <a href="{{ route('single-product', ['id' => $product->id]) }}" class="d-block">
                    <div class="img-box">
                        <img data-src="{{ $product->image_url }}" class="img-fluid lazy ">
                    </div>
                    <div class="tags">
                        @if((int)$product->discount>0)
                        <span class="discount-tag"> -{{ $product->discount }}% </span>
                        @endif
                        @if($diff<=14)
                        <span class="new-tag">New</span>
                        @endif
                    </div>

                </a>
            </div>
            <div class="card-body">
                <div class="product-category">

                    {{-- <a href="{{route('product.category',['slug'=>$product->shop_category->shop_cat_slug])}}">
                    {{ $product->shop_category->shop_cat_name }}</a> --}}
                    <a href="">
                    </a>
                </div>
                <div class="brand-name">{{ $product->brand->brand_name }}</div>
                <a href="{{ route('single-product', ['id' => $product->id]) }}" class="product-title">{{ $product->product_name }}</a>
                @if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price)
                <span class="discounted-price">£{{number_format($product->sale_price,2) }}</span>
                <span class="real-price">£{{number_format($product->regular_price,2) }}</span>
                @else

                <span class="discounted-price">£{{number_format($product->regular_price,2) }}</span>

                @endif


            </div>
        </div>

        @endforeach

        @else
        <section>
            <div class="row">
                <div class="col-md-10 text-center" style="margin-top:15%">
                    <p>No products were found matching your selection.</p>
                    <a href="{{route('shop_products')}}" class="back-to-shop no_djax btn btn-primary">Back to shop</a>
                </div>
            </div>
        </section>
        @endif
    </div>
    @endsection

    @section('scripts')
    <script>
        $(document).ready(function() {

            $("#fil").click(function() {

                var slider1 = document.getElementById('slider-1');
                var slider2 = document.getElementById('slider-2');

                $.ajax({
                    url: "{{ route('shop.price') }}",
                    method: 'post',
                    data: {
                        _token: "{{ csrf_token() }}",
                        min: slider1.value,
                        max: slider2.value
                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);
                        //console.log(result);
                        //$('.products-wrapper').html(result);
                        //result = JSON.parse(result)
                    }
                });
            });


            $("#brand").change(function() {
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "{{ route('shop.gender') }}",
                    method: 'post',
                    data: {
                        _token: "{{ csrf_token() }}",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id

                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);
                        //console.log(result);
                        //$('.products-wrapper').html(result);
                        //result = JSON.parse(result)
                    }
                });
            });

            $("#categories").change(function() {
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "{{ route('shop.gender') }}",
                    method: 'post',
                    data: {
                        _token: "{{ csrf_token() }}",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id,
                    },
                    success: function(result) {

                        var sz=JSON.parse(result.sizes);

                        $("#size").empty();
                        $("#size").append('<option value="0" selected="">Please Select Size</option>');

                       for(j=0; j<sz.length; j++){
                        $("#size").append('<option  value="'+sz[j].id+'">'+sz[j].size+'</option>');
                       }

                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);


                    }
                });
            });

            //product-filters
            $("#gender").change(function() {   
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "{{ route('shop.gender') }}",
                    method: 'post',
                    data: {
                        _token: "{{ csrf_token() }}",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id
                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);

                        $("#categories").empty();
                        $("#categories").append('<option value="0" selected="">Select a category</option>');
                        var ca=JSON.parse(result.scat);

                        var sz=JSON.parse(result.sizes);

                        $("#size").empty();
                        $("#size").append('<option value="0" selected="">Please Select Size</option>');

                        for(j=0; j<sz.length; j++){
                            $("#size").append('<option  value="'+sz[j].id+'">'+sz[j].size+'</option>');
                        }

                        for(i=0; i<ca.length; i++)
                        {
                            if(ca[i].shop_cat_slug==categories){
                                $("#categories").append('<option selected value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }else{
                                $("#categories").append('<option  value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }     
                        }
                    }
                });
            });


            $("#size").change(function() {   
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "{{ route('shop.gender') }}",
                    method: 'post',
                    data: {
                        _token: "{{ csrf_token() }}",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id
                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);

                        $("#categories").empty();
                        $("#categories").append('<option value="0" selected="">Select a category</option>');
                        var ca=JSON.parse(result.scat);

                        var sz=JSON.parse(result.sizes);

                        $("#size").empty();
                        $("#size").append('<option value="0" selected="">Please Select Size</option>');

                        for(j=0; j<sz.length; j++){
                            $("#size").append('<option  value="'+sz[j].id+'">'+sz[j].size+'</option>');
                        }

                        for(i=0; i<ca.length; i++){

                            if(ca[i].shop_cat_slug==categories){
                                $("#categories").append('<option selected value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }else{
                                $("#categories").append('<option value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }     
                        }
                    }
                });
            });

        });
    </script>
    @endsection