@extends('frontend.user.user-masters')
@section('user-content')
<div class="column content ajax_response">
    <form class="common-form">
        @if(isset($request_become_vendor))
        <p class="message_become_a_vendor">Your account has not yet been approved to become a seller. When it
            is, you will receive an email telling you that your
            account is approved!</p>
        @else

        <div class="form-row">
            <div class="form-group col-md-4">
                <input type="checkbox" value="become-a-vendor" name="become_a_vendor" id="become_a_vendor">
                <label for="firstName">Become A Vendor <span>*</span></label>
            </div>
        </div>
        <div class="form-group col-md-4">
            <a href="javascript:void(0)" class="btn blue-button" id="save-changes">Become A Vendor</a>
        </div>
    </form>
    @endif


</div>

@endsection
@section('scripts')
<script>
$(document).ready(function() {
    $('#save-changes').on('click', function() {
        if ($('#become_a_vendor').prop('checked')) {
            $.ajax({
                url: "{{ route('request_become_a_vendor_process') }}",
                method: 'post',
                data: {
                    "_token": "{{ csrf_token() }}",
                    user_id: '{{auth()->user()->id}}',
                },
                success: function(result) {
                    var obj = jQuery.parseJSON(result);
                    if (obj.message) {
                        $('.ajax_response').html(obj.message);
                    }

                }
            });
        }

    });

});
</script>

@endsection