@extends('frontend.user.user-masters')
@section('user-content')
    <div class="column content px-2">
        <div class="d-flex flex-column justify-content-center align-items-center" id="order-heading">
            <div class="text-uppercase">
                <p>Order detail</p>
            </div>

            <div class="h4">Order Date Time: {{ date_format($data->created_at,'Y-M-d H:i') }}</div>
            <div class="pt-1">
                <p>Order Reference: <b class="text-dark"> {{$data->reference}}</b></p>
            </div>
            <div class="pt-1">
                <p>Order #{{ $data->id }} is currently<b class="text-dark"> {{ucwords($data->status)}}</b></p>
            </div>

            @if($data->tracking_number ?? '')
                <div class="pt-1">
                    <p>Order Tracking #<b class="text-dark"> {{$data->tracking_number}}</b></p>
                </div>
            @endif

            <div class="btn close text-white"> &times; </div>
        </div>

        <style>
            .table th, .table td{
                vertical-align: middle !important;
            }
        </style>

        <?php $sub_total = 0; ?>

        <div class="wrapper bg-white">

            <div class="table-responsive">
                <table class="table table-borderless">
                    <thead>
                    <tr class="text-uppercase text-muted">
                        <th scope="col">product</th>
                        <th scope="col">name</th>
                        <th scope="col">sku</th>
                        <th scope="col">size</th>
                        <th scope="col">brand</th>
                        <th scope="col">quantity</th>
                        <th scope="col" class="text-right">price</th>
                    </tr>
                    </thead>
                    <tbody>

                    @forelse($data->order_detail as $order_detail)
                        <tr>
                            @forelse($order_detail->product as $product)

                                {{--start - calculate the subtotal which is used in the below code--}}
                                @if((float)$product->sale_price > 0)
                                    <?php $sub_total = $sub_total + $product->sale_price * (float)$order_detail->quantity; ?>
                                @elseif((float)$product->sale_price_sizes > 0)
                                    <?php $sub_total = $sub_total + $product->sale_price_sizes * (float)$order_detail->quantity; ?>
                                @else
                                    <?php $sub_total = $sub_total + $product->regular_price * (float)$order_detail->quantity; ?>
                                @endif
                                {{--end - calculate the subtotal which is used in the below code--}}

                                <td><img src="{{@getimagesize($product->image_url ?? '') ? ($product->image_url ?? '') : ($product->image_url_vendor ?? '') }}" alt="apple" class="rounded-circle" width="60" height="60"></td>
                                <td>{{ ($product->product_name ?? '') ?: ($product->product_parent->product_name ?? '') }}</td>
                                <td>{{($product->product_name ?? '') ? ($product->sku ?? '') : ($product->product_parent->sku ?? '')}}</td>
                                <td>{{$order_detail->size_detail->size ?? ''}}</td>
                                <td>{{($product->brand->brand_name ?? '') ?: \App\Models\Brand::find($product->product_parent->brand_id ?? 0)->brand_name ?? ''}}</td>
                                <td>{{$order_detail->quantity ?? '' }}</td>
                                <td class="text-right">{{number_format((float)($order_detail->price ?? 0), 2, '.', '')}}</td>

                            @empty
                            @endforelse
                        </tr>
                    @empty
                    @endforelse
                    </tbody>
                </table>

            </div>

            <div class="pt-2 border-bottom mb-3"></div>

            <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                <div class="text-muted">Payment Type</div>
                <div class="ml-auto">
                    <label>{{\App\Models\Order::PAYMENT_TYPES[$data->payment_type ?? 0] ?? ''}}</label>
                </div>
            </div>

            <div class="d-flex justify-content-start align-items-center pl-3">
                <div class="text-muted">Payment Method</div>
                @if($data->payment_type == 1)
                    <div class="ml-auto"> <img src="{{asset('admin/uploads/cash_on_d.jpg')}}" alt="" width="30" height="30">
                        <label> Cash On Delivery </label>
                    </div>
                @elseif($data->payment_type == 2)
                    <div class="ml-auto"> <img src="{{asset('admin/uploads/cash_on_d.jpg')}}" alt="" width="30" height="30">
                        <label> PayPal Card Payment </label>
                    </div>
                @else
                    <div class="ml-auto">

                        <img src="{{asset('admin/uploads/card_on_d.jpg')}}" alt="" width="30" height="30">
                        <?php
                        if($payment_response = json_decode($data->stripe_response ?? '[]', true)['charge.succeeded'] ?? false){
                            $payment_response = $payment_response['source']['brand'] . ' ******' . $payment_response['source']['last4'];
                        } else {
                            $payment_response = "XXXX ******XXXX";
                        }
                        ?>
                        <label>{{$payment_response}}</label>
                    </div>
                @endif

            </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Subtotal</div>
            <div class="ml-auto"> <label>{{number_format((float)$sub_total, 2, '.', '') }}</label> </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted"> Shipping </div>
            <div class="ml-auto">{{ number_format((float)$data->shipping, 2, '.', '') }}  </div>
        </div>
        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted"> Processing </div>
            <div class="ml-auto">{{ number_format((float)$data->processing, 2, '.', '') }}  </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Discount</div>
            <div class="ml-auto"> <label>{{number_format((float)(($sub_total + $data->shipping + $data->processing) - $data->total_price), 2, '.', '')}}</label> </div>
        </div>

        <div class="d-flex justify-content-start align-items-center pl-3 py-3 mb-4 border-bottom">
            <div class="text-muted"> Total </div>
            <div class="ml-auto h5">{{ number_format((float)$data->total_price, 2, '.', '') }}  </div>
        </div>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Related Subsriptions</div>

        <div class="d-sm-flex justify-content-between rounded my-3 subscriptions">
            <div> <b>Order #{{$data->id}}</b> </div>
            <div>Order Date: {{date_format($data->created_at,'Y-M-d')}}</div>
            <div>Status: {{ucwords($data->status)}}</div>
            <div> Total: <b>{{ number_format((float)$data->total_price, 2, '.', '') }}   </b> </div>
        </div>

        <br>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Buyers Info</div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Name</div>
            <div class="ml-auto"> {{$data->user->first_name ?? ""}} {{$data->user->last_name ?? ""}} </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Email</div>
            <div class="ml-auto">  {{$data->user->email ?? ""}} </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Contact Number</div>
            <div class="ml-auto">   {{$data->user->phone ?? ""}} </div>
        </div>

        @if(isset($data->order_detail))

            @forelse($data->order_detail as $order_detail)
                @forelse($order_detail->product as $product)

                    @if($product->product_user ?? '')
                        <br>

                        <div class="pl-3 font-weight-bold" style="text-align: center;">Seller Info</div>


                        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                            <div class="text-muted">Name</div>
                            <div class="ml-auto">{{$product->product_user->first_name ?? '' . " " . $product->product_user->last_name ?? ''}}</div>
                        </div>

                        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                            <div class="text-muted">Email</div>
                            <div class="ml-auto">{{$product->product_user->email ?? ''}}</div>
                        </div>

                        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                            <div class="text-muted">Contact Number</div>
                            <div class="ml-auto">{{$product->product_user->phone ?? ''}}</div>
                        </div>
                    @endif

                @empty
                @endforelse
            @empty
            @endforelse
        @endif

        <br>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Billing / Shipping Info</div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3" style="background: #F5F5F5; border: 1px solid #dee2e6;">
            <div>
                <ul class="listStyleNone">
                    <li>Country: {{$billing->country ?? ""}} </li>
                    <li>Address Line 1 : {{$billing->street_address ?? ""}} </li>
                    <li>Address Line 2 : {{$billing->appartment_address ?? ""}} </li>
                    <li>City/Town: {{$billing->city ?? ""}} </li>
                    <li>County : {{$billing->state ?? " "}} </li>
                    <li>Post Code: {{$billing->post_code ?? ""}} </li>
                    <li>Contact Number : {{$billing->phone ?? ""}}</li>
                </ul>
            </div>
            <div class="ml-auto">
                <ul class="listStyleNone">
                    <li>Country: {{$shipping->country ?? ""}} </li>
                    <li>Address Line 1 : {{$shipping->street_address ?? ""}} </li>
                    <li>Address Line 2 : {{$shipping->appartment_address ?? ""}} </li>
                    <li>City/Town: {{$shipping->city ?? " "}} </li>
                    <li>County : {{$shipping->state ?? ""}} </li>
                    <li>Post Code: {{$shipping->post_code ?? ""}} </li>
                    <li>Contact Number : {{$shipping->phone ?? ""}} </li>
                </ul>
            </div>
        </div>

        <br>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Shipping Documents</div>

        <table class="table table-striped" cellspacing="0" width="100%">
            {{--<table class="table table-head-bg table-head-primary table-striped table-bordered " cellspacing="0" width="100%">--}}
            <thead>
            <tr style="background: lightgray;">
                <th>Name</th>
                <th>Type</th>
                <th>Uploaded At</th>
                <th>Action</th>
            </tr>
            </thead>
            <tbody>

            @if(count($documents) > 0)
                @foreach($documents as $document)
                    <tr>
                        <td>{{$document->name}}</td>
                        <td>{{strtoupper($document->extension)}}</td>
                        <td>{{date_format($document->created_at,'d-m-Y')}}</td>
                        <td><a href="{{ route('down.document', ['id' => encrypt($document->id)]) }}" class="btn btn-info btn-sm">Download</a></td>
                    </tr>
                @endforeach
            @else
                <td colspan="4" class="text-center">There is no documents</td>
            @endif
            </tbody>
        </table>

    </div>
@endsection
