<?php
use App\Models\Product;
use App\Models\Size;
?>

@extends('frontend.user.new-masters')
@section('user-content')
    <div class="column content px-2">

        <div class="tabs-wrapper orders-tabs">
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="tab-1" data-toggle="tab" href="#tab-one">Orders Placed</a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="tab-one">

                    @if(!$orders->isEmpty())

                        <div class="table-responsive">
                            <table class="table orders-table" id="user_orders_dt">
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>DATE</th>
                                    <th>REFERENCE</th>
                                    <th>PRODUCT</th>
                                    <th>SIZE</th>
                                    <th>PRICE</th>
                                    <th>STATUS</th>
                                    <th>ACTION</th>
                                </tr>
                                </thead>

                                <tbody>

                                @foreach($orders as $order)

                                    <tr>
                                        <td>{{$order->id}}</td>
                                        <td>{{date('d/m/Y', strtotime($order->created_at))   ?? ""}}</td>
                                        <td>{{$order->reference}}</td>
                                        <td>
                                            @if(count($order->details)>1)
                                                Multiple
                                            @elseif(isset($order->details[0]->id) && $order->details[0]->parent_id==0 )
                                                {{$order->details[0]->product_name ?? ""}}
                                            @else
                                                {{Product::where("id",$order->details[0]->parent_id)->first()->product_name ?? ''}}
                                            @endif
                                        </td>
                                        <td>
                                            @if(count($order->details) > 1)
                                                Multiple
                                            @else
                                                {{Size::where("id",$order->details[0]->size_id)->first()->size ?? ""}}
                                            @endif
                                        </td>

                                        <td>{{  number_format($order->total_price, 2)   }} </td>

                                        @if($order->status == 'processing')
                                            <td><span class="badge badge-danger ">{{$order->status}}</span></td>
                                        @elseif($order->status == 'completed')
                                            <td><span class="badge badge-success ">{{$order->status}}</span></td>
                                        @elseif($order->status == 'refunded')
                                            <td><span class="badge badge-warning ">{{$order->status}}</span></td>
                                        @elseif($order->status == 'cancelled')
                                            <td><span class="badge badge-info ">{{$order->status}}</span></td>
                                        @elseif($order->status == 'onhold')
                                            <td><span class="badge badge-primary ">{{$order->status}}</span></td>
                                        @endif

                                        <td style="text-align:left;">
                                            <a href="{{ route('user_order_detail', ['id' => $order->id]) }}" class="btn blue-button-outline">details</a>

                                            @if($order->paid == 0)
                                                <a href="{{ route('user_payment', ['id' => $order->id]) }}" class="btn blue-button-outline">
                                                    Payment</a>
                                            @endif
                                        </td>
                                    </tr>

                                @endforeach

                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="8">
                                        @if($orders->count() < 1)
                                            <div class="pagination justify-content-center">
                                                {{ __('No record found.') }}
                                             </div>
                                        @endif
                                        <div class="pagination mt-3">
                                            {!! $orders->links("pagination::bootstrap-4") !!}
                                        </div>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        <div class="no-order">
                            <p>
                                <i class="uil uil-exclamation-triangle"></i>
                                No order has been made yet.
                            </p>
                            <a href="#" class="btn blue-button-outline">Browse products</a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript" src="{{asset('admin/assets/plugin/datatable/datatables.min.js')}}"></script>

    <script>

        $(document).ready(function () {
            $('#user_orders_dt').DataTable({
                searching: false,
                paging: false,
                info: false,
                aaSorting: [[1, "asc"]]
            });
        });
    </script>


@endsection
