@extends('frontend.user.user-masters')
@section('user-content')
<div class="column content ajax_response">

    <div class="my-listings-page table-responsive">



        @if($count>0 && count($vendor_products)>0)




        <table class="table table-borderless">
            <thead>
                <tr>
                    <th>
                        <p>Product ID</p>
                    </th>
                    <th>
                        <p>Product Name</p>
                    </th>
                    <th>
                        <p>Size</p>
                    </th>
                    <th>
                        <p>Date</p>
                    </th>
                    <th>
                        <p>Selling Price</p>
                    </th>
                    <th>
                        <p>Payout Amount</p>
                    </th>
                    <th>
                        <p>Status</p>
                    </th>
                    {{-- <th>
                                    <p>Total Quantity</p>
                                </th>
                                <th>
                                    <p>Sold Quantity</p>
                                </th>
                                <th>
                                    <p>Remaining Quantity</p>
                                </th>
                                <th>
                                    <p>Total Payout</p>
                                </th>

                                --}}
                </tr>
            </thead>
            <tbody>
                @foreach($vendor_products as $vendor_product)
                <tr>
                    <td>
                        <p>{{$vendor_product->id ?? ""}}</p>
                    </td>
                    <td>
                        <p>{{$vendor_product->product_name ?? ""}}</p>
                    </td>
                    <td>
                        <p>{{$vendor_product->size ?? ""}}</p>
                    </td>
                    <td>
                        <p>{{ $vendor_product->order_date ?? ""}}</p>

                    </td>
                    <td>
                        <p>{{number_format($vendor_product->selling_price,2)}}</p>

                    </td>
                    <td>
                        <p>{{number_format($vendor_product->selling_price - $vendor_product->selling_price* 7.5/100,2)}}</p>

                    </td>
                    <td>
                        <select disabled size="1" class="form-control m-0 selectOrder">
                            <option value="processing" {{ ($vendor_product->status == 'processing' ? 'selected' : '')}}>
                                Processing
                            </option>
                            <option value="completed" {{ ($vendor_product->status == 'completed' ? 'selected ' : '')}}>
                                Completed
                            </option>
                            <option value="refunded" {{ ($vendor_product->status == 'refunded' ? 'selected ' : '')}}>
                                Refunded
                            </option>
                            <option value="cancelled" {{ ($vendor_product->status == 'cancelled' ? 'selected ' : '')}}>
                                Cancelled
                            </option>
                            <option value="onhold" {{ ($vendor_product->status == 'onhold' ? 'selected' : '')}}>
                                On-hold
                            </option>
                        </select>

                    </td>
                    {{--
                                </td>
                                <td>
                                    <p>{{$vendor_product->vendor_quantity ?? ""}}</p>
                    </td>
                    <td>
                        <p><?php
                            if ($vendor_product->vendor_quantity > 0) {
                                $vendor_stock =  $vendor_product->vendor_stock->quantity;
                                echo ($vendor_product->vendor_quantity - $vendor_stock);
                            }
                            ?></p>
                    </td>
                    <td>
                        <p><?php
                            if ($vendor_product->vendor_quantity > 0) {
                                $vendor_stock =  $vendor_product->vendor_stock->quantity;
                                echo $vendor_stock;
                            }
                            ?></p>
                    </td>
                    <td>
                        <p>{{$vendor_product->price}}</p>
                    </td> --}}
                    {{-- <td>
                                    <a href="{{route('details_vendor_product',['id' => $vendor_product->id])}}" class="blue-button">Details</a>
                    </td> --}}
                </tr>
                @endforeach
            </tbody>
        </table>

        @else
        <p class="message_become_a_vendor">No sales have been made yet</p>
        <a href="{{route("sale_your_product")}}" class="btn blue-button" id="save-changes">Start Selling</a>
        @endif

    </div>

    @endsection