

<?php
use Illuminate\Support\Carbon;

?>

<?php $__env->startSection('products-content'); ?>
<?php if(!$products->isEmpty()): ?>
<section>
    <div class="products-wrapper">

        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <?php 


    // Creates DateTime objects
  $datetime1 = date_create($product->created_at);
  $datetime2 = date_create(Carbon::now());
 
  // Calculates the difference between DateTime objects
  $interval = date_diff($datetime1, $datetime2);
 
  // Printing result in years & months format
  $diff=(int)$interval->format('%a');
   

       // dd($product->created_at);

        ?>
        <div class="card product-card">
            <div class="card-header">
                <a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
                    <div class="img-box">
                        <img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
                    </div>
                    <div class="tags">
                        <?php if((int)$product->discount>0): ?>
                        <span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
                        <?php endif; ?>
                        <?php if($diff<=14): ?>
                        <span class="new-tag">New</span>
                        <?php endif; ?>
                    </div>

                </a>
            </div>
            <div class="card-body">
                <div class="product-category">

                    
                    <a href="">
                    </a>
                </div>
                <div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
                <a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
                <?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
                <span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
                <span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
                <?php else: ?>

                <span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

                <?php endif; ?>


            </div>
        </div>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php else: ?>
        <section>
            <div class="row">
                <div class="col-md-10 text-center" style="margin-top:15%">
                    <p>No products were found matching your selection.</p>
                    <a href="<?php echo e(route('shop_products')); ?>" class="back-to-shop no_djax btn btn-primary">Back to shop</a>
                </div>
            </div>
        </section>
        <?php endif; ?>
    </div>
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {

            $("#fil").click(function() {

                var slider1 = document.getElementById('slider-1');
                var slider2 = document.getElementById('slider-2');

                $.ajax({
                    url: "<?php echo e(route('shop.price')); ?>",
                    method: 'post',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        min: slider1.value,
                        max: slider2.value
                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);
                        //console.log(result);
                        //$('.products-wrapper').html(result);
                        //result = JSON.parse(result)
                    }
                });
            });


            $("#brand").change(function() {
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "<?php echo e(route('shop.gender')); ?>",
                    method: 'post',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id

                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);
                        //console.log(result);
                        //$('.products-wrapper').html(result);
                        //result = JSON.parse(result)
                    }
                });
            });

            $("#categories").change(function() {
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "<?php echo e(route('shop.gender')); ?>",
                    method: 'post',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id,
                    },
                    success: function(result) {

                        var sz=JSON.parse(result.sizes);

                        $("#size").empty();
                        $("#size").append('<option value="0" selected="">Please Select Size</option>');

                       for(j=0; j<sz.length; j++){
                        $("#size").append('<option  value="'+sz[j].id+'">'+sz[j].size+'</option>');
                       }

                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);


                    }
                });
            });

            //product-filters
            $("#gender").change(function() {   
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "<?php echo e(route('shop.gender')); ?>",
                    method: 'post',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id
                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);

                        $("#categories").empty();
                        $("#categories").append('<option value="0" selected="">Select a category</option>');
                        var ca=JSON.parse(result.scat);

                        var sz=JSON.parse(result.sizes);

                        $("#size").empty();
                        $("#size").append('<option value="0" selected="">Please Select Size</option>');

                        for(j=0; j<sz.length; j++){
                            $("#size").append('<option  value="'+sz[j].id+'">'+sz[j].size+'</option>');
                        }

                        for(i=0; i<ca.length; i++)
                        {
                            if(ca[i].shop_cat_slug==categories){
                                $("#categories").append('<option selected value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }else{
                                $("#categories").append('<option  value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }     
                        }
                    }
                });
            });


            $("#size").change(function() {   
                brand = $('#brand').val();
                categories = $('#categories').val();
                gender = $('#gender').val();
                size_id=$('#size').val();
                $.ajax({
                    url: "<?php echo e(route('shop.gender')); ?>",
                    method: 'post',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        brand: brand,
                        categories: categories,
                        gender: gender,
                        sizes : size_id
                    },
                    success: function(result) {
                        $(".result-count").html("Showing 1–" + result.selected + " of " + result.count + " results");
                        $('.products-wrapper').html(result.html);

                        $("#categories").empty();
                        $("#categories").append('<option value="0" selected="">Select a category</option>');
                        var ca=JSON.parse(result.scat);

                        var sz=JSON.parse(result.sizes);

                        $("#size").empty();
                        $("#size").append('<option value="0" selected="">Please Select Size</option>');

                        for(j=0; j<sz.length; j++){
                            $("#size").append('<option  value="'+sz[j].id+'">'+sz[j].size+'</option>');
                        }

                        for(i=0; i<ca.length; i++){

                            if(ca[i].shop_cat_slug==categories){
                                $("#categories").append('<option selected value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }else{
                                $("#categories").append('<option value="'+ca[i].shop_cat_slug+'">'+ca[i].shop_cat_name+'</option>');
                            }     
                        }
                    }
                });
            });

        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.shop.product-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/resources/views/frontend/shop/shop-product.blade.php ENDPATH**/ ?>