<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-content'); ?>
<div class="page-wrapper">
    <!-- Page Title -->
    <div class="page-title">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <h2 class="page-title-text"></h2>
            </div>
            <div class="col-sm-6 text-right">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li>Dashboard</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Button Code Starts Here -->

  

    <!-- Action Button Code Ends Here -->


    <!-- Page Body -->
    <div class="page-body">
        <div class="row">

            <div class="col-12">
                <div class="panel panel-default">

                    <div class="panel-body">
                        <?php if( session()->has('message') ): ?>
                        <div class="alert alert-icon alert-success alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Well done!</strong> <?php echo e(session('message')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php elseif(session()->has('error')): ?>
                        <div class="alert alert-icon alert-danger alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-thermometer"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Oh snap!</strong> <?php echo e(session('error')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>
                        <div class="table-responsive">
                            <table
                                class="table table-head-bg table-head-primary table table-striped table-bordered basic-datatable"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Gender</th>
                                        <th>Status</th>

                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php if(isset($shop_categories)): ?>
                                    <?php $__currentLoopData = $shop_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td><?php echo e($shop_category['id']); ?></td>
                                        <td><?php echo e($shop_category['shop_cat_name']); ?></td>
                                        <td><?php echo e($shop_category['gender']); ?></td>
                                        <?php if($shop_category['active'] == 1): ?>
                                        <td><span
                                                class="badge badge-success badge-sm badge-pill"><?php echo e(App\Models\ShopCategory::STATUS_ACTIVE); ?></span>
                                        </td>
                                        <?php else: ?>
                                        <td><span
                                                class="badge badge-danger badge-sm badge-pill"><?php echo e(App\Models\ShopCategory::STATUS_NOT_ACTIVE); ?></span>
                                        </td>
                                        <?php endif; ?>
                                        <td><a href="<?php echo e(route('product-catgory', ['slug' => $shop_category['id'], 'brand_slug' => $brand_slug])); ?>"
                                                class="btn btn-primary btn-sm m-1">View</a></td>

                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Slug</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('admin/dist/js/demo/datatable.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/resources/views/admin/category/catBrand.blade.php ENDPATH**/ ?>