<?php


use Illuminate\Support\Carbon;

?>
 <?php $__env->startSection('title', 'The Marketplace'); ?> <?php $__env->startSection('content'); ?>
<div class="lazy" data-loader="asyncLoader"></div>
<main class="home-main">
	<div class="container">
		<?php if( session()->has('message') ): ?>
		<div class="alert alert-icon alert-success alert-dismissible fade show">
			<div class="alert--icon"> <i class="fa fa-check"></i> </div>
			<div class="alert-text"> <strong>Well done!</strong> <?php echo e(session('message')); ?> </div>
			<button type="button" class="close" data-dismiss="alert"> <span aria-hidden="true">&times;</span> </button>
		</div>
		<?php elseif(session()->has('error')): ?>
		<div class="alert alert-icon alert-danger alert-dismissible fade show">
			<div class="alert--icon"> <i class="fa fa-thermometer"></i> </div>
			<div class="alert-text"> <strong>Oh snap!</strong> <?php echo e(session('error')); ?> </div>
			<button type="button" class="close" data-dismiss="alert"> <span aria-hidden="true">&times;</span> </button>
		</div>
		<?php endif; ?>
		

	<?php if(isset($brands)): ?>
	<a href="#" class="sub-heading">Popular Brands</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-men-new">
		<?php $__empty_1 = true; $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
		<div class="item">
			<div class="card">
				<a href="<?php echo e(route('product.brand',[$brand['id']])); ?>" class="content">
					<div class="img-box"> <img data-src="<?php echo (!empty($brand->image) ? $brand->image_url : 'assets/images/product-placeholder.png'); ?> " class="img-fluid lazy "> </div>
					<h5 class="brand-title" style="text-align:center;color:#3a3a3a;"><?php echo e($brand->brand_name); ?></h5>
				</a>
			</div>
		</div>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
		<div class="item">
			<div class="card">
				<h5 class="brand-title">No brands</h5>
			</div>
		</div>
		<?php endif; ?>
	</div>
	<?php endif; ?>





	<!-- Brands Slider End -->
	<!-- Product Category Start -->
	<!-- Men's Category -->
	<!-- Men's New -->
	<?php if(isset($man_products)): ?>
	<a href="#" class="sub-heading">Men's new in</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-men-new">
		<?php $__currentLoopData = $man_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>

		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>

						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>


					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
			<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price ,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Men's New End-->
	<!-- Men's Sales -->
	<?php if(isset($man_in_sales)): ?>
	<a href="#" class="sub-heading">Men's Sale</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-men-sales">
		<?php $__currentLoopData = $man_in_sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>


		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>

						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>




					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
				<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price ,2)); ?> </span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Men's Sales End-->
	<!-- Men's Most Popular -->
	<?php if(isset($man_in_populars)): ?>
	<a href="#" class="sub-heading">Men's Most Popular</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-men-popular">
		<?php $__currentLoopData = $man_in_populars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>

		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
			    <div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price ,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Men's Most Popular End -->
	<!-- Men's Category End -->
	<!-- Women's Category -->
	<!-- Women's New -->
	<?php if(isset($woman_products)): ?>
	<a href="#" class="sub-heading">Women's new in</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-women-new">
		<?php $__currentLoopData = $woman_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>


		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
				<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price ,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Women's New End-->
	<!-- Women's Sales -->
	<?php if(isset($woman_in_sales)): ?>
	<a href="#" class="sub-heading">Women's Sales</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-women-sales">
		<?php $__currentLoopData = $woman_in_sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>
		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
				<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Women's Sales End-->
	<!-- Women's Most Popular -->
	<?php if(isset($woman_in_populars)): ?> <a href="#" class="sub-heading">Women's Most Popular</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-women-popular">
        <?php $__currentLoopData = $woman_in_populars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        	<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>

		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
				<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price ,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price ,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>

		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Women's Most Popular End -->
	<!-- Women's Category End -->
	<!-- childern's Category -->
	<?php if(isset($children_products)): ?>
	<!-- childern's New -->
	<a href="#" class="sub-heading">childern's new in</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-childern-new">
		<?php $__currentLoopData = $children_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>

		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
			    <div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- childern's New End-->
	<!-- childern's Sales -->
	<?php if(isset($children_in_sales)): ?> <a href="#" class="sub-heading">childern's Sales</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-childern-sales">
		<?php $__currentLoopData = $children_in_sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>

		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
			    <div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- childern's Sales End-->
	<!-- childern's Most Popular -->
	<?php if(isset($children_in_populars)): ?> <a href="#" class="sub-heading">childern's Most Popular</a>
	<div class="owl-carousel owl-theme product-slider" id="slider-childern-popular">
		<?php $__currentLoopData = $children_in_populars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

		<?php


		// Creates DateTime objects
		$datetime1 = date_create($product->created_at);
		$datetime2 = date_create(Carbon::now());

		// Calculates the difference between DateTime objects
		$interval = date_diff($datetime1, $datetime2);

		// Printing result in years & months format
		$diff = (int)$interval->format('%a');


		// dd($product->created_at);

		?>

		<div class="card product-card">
			<div class="card-header">
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
					<div class="img-box">
						<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
					</div>
					<div class="tags">
						<?php if((int)$product->discount>0): ?>
						<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
						<?php endif; ?>
						<?php if($diff<=14): ?> <span class="new-tag">New</span>
							<?php endif; ?>
					</div>

				</a>
			</div>
			<div class="card-body" style="text-align:center;">
				<div class="product-category">

					
					<a href="">
					</a>
				</div>
				<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
				<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
				<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
				<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
				<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
				<?php else: ?>

				<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

				<?php endif; ?>


			</div>
		</div>


		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
	<?php endif; ?>
	<!-- Women's Most Popular End -->
	<!-- Women's Category End -->
	<!-- Product Category Ends --><a href="<?php echo e(route('shop_products')); ?>" class="btn browse-products">Browse Thousands of Products on our
		Marketplace</a>
	<div class="top-trending">
		<h1>Top Trending Of <?php echo date('F'); ?></h1>
		<div class="trending-tabs">
			<nav>
				<div class="nav nav-tabs" id="nav-tab" role="tablist"> <a class="nav-item nav-link active" id="nav-men-tab" data-toggle="tab" href="#nav-men" role="tab" aria-controls="nav-men" aria-selected="true">Menswear</a> <a class="nav-item nav-link" id="nav-women-tab" data-toggle="tab" href="#nav-women" role="tab" aria-controls="nav-women" aria-selected="false">Womenswear </a> <a class="nav-item nav-link" id="nav-childern-tab" data-toggle="tab" href="#nav-childern" role="tab" aria-controls="nav-childern" aria-selected="false">Children</a> </div>
			</nav>
			<div class="tab-content mt-5" id="nav-tabContent">
				<div class="tab-pane fade show active" id="nav-men" role="tabpanel" aria-labelledby="nav-men-tab">
					<div class="products-wrapper"> <?php if(isset($top_mans_trend_products)): ?>
						<?php $__currentLoopData = $top_mans_trend_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

						<?php


						// Creates DateTime objects
						$datetime1 = date_create($product->created_at);
						$datetime2 = date_create(Carbon::now());

						// Calculates the difference between DateTime objects
						$interval = date_diff($datetime1, $datetime2);

						// Printing result in years & months format
						$diff = (int)$interval->format('%a');


						// dd($product->created_at);

						?>

						<div class="card product-card">
							<div class="card-header">
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
									<div class="img-box">
										<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
									</div>
									<div class="tags">
										<?php if((int)$product->discount>0): ?>
										<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
										<?php endif; ?>
										<?php if($diff<=14): ?> <span class="new-tag">New</span>
											<?php endif; ?>
									</div>

								</a>
							</div>
							<div class="card-body" style="text-align:center;">
								<div class="product-category">

									
									<a href="">
									</a>
								</div>
								<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
								<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
								<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
								<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
								<?php else: ?>

								<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

								<?php endif; ?>


							</div>
						</div>


						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



						<?php endif; ?>
					</div>
				</div>
				<div class="tab-pane fade" id="nav-women" role="tabpanel" aria-labelledby="nav-women-tab">
					<div class="products-wrapper"> <?php if(isset($top_womans_trend_products)): ?>
						<?php $__currentLoopData = $top_womans_trend_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


						<?php


						// Creates DateTime objects
						$datetime1 = date_create($product->created_at);
						$datetime2 = date_create(Carbon::now());

						// Calculates the difference between DateTime objects
						$interval = date_diff($datetime1, $datetime2);

						// Printing result in years & months format
						$diff = (int)$interval->format('%a');


						// dd($product->created_at);

						?>

						<div class="card product-card">
							<div class="card-header">
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
									<div class="img-box">
										<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
									</div>
									<div class="tags">
										<?php if((int)$product->discount>0): ?>
										<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
										<?php endif; ?>
										<?php if($diff<=14): ?> <span class="new-tag">New</span>
											<?php endif; ?>
									</div>

								</a>
							</div>
							<div class="card-body" style="text-align:center;">
								<div class="product-category">

									
									<a href="">
									</a>
								</div>
								<div class="brand-name"><?php echo e($product->brand->brand_name); ?></div>
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
								<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
								<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
								<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
								<?php else: ?>

								<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?><?php echo e($product->regular_price); ?></span>

								<?php endif; ?>


							</div>
						</div>


						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						<?php endif; ?>
					</div>
				</div>
				<div class="tab-pane fade" id="nav-childern" role="tabpanel" aria-labelledby="nav-childern-tab">
					<div class="products-wrapper"> <?php if(isset($top_children_trend_products)): ?>
						<?php $__currentLoopData = $top_children_trend_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

						<div class="card product-card">
							<div class="card-header">
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
									<div class="img-box">
										<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
									</div>
									<div class="tags">
										<?php if((int)$product->discount>0): ?>
										<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
										<?php endif; ?>
										<span class="new-tag">New</span>
									</div>

								</a>
							</div>
							<div class="card-body" style="text-align:center;">
								<div class="product-category">

									
									<a href="">
									</a>
								</div>
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->brand->brand_name); ?></a>
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
								<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
								<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
								<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
								<?php else: ?>

								<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

								<?php endif; ?>


							</div>
						</div>


						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	</div>
</main> <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/frontend/home/frontend-home.blade.php ENDPATH**/ ?>