
<?php $__env->startSection('user-content'); ?>
    <div class="column content px-2">
        <div class="d-flex flex-column justify-content-center align-items-center" id="order-heading">
            <div class="text-uppercase">
                <p>Order detail</p>
            </div>

            <div class="h4">Order Date Time: <?php echo e(date_format($data->created_at,'Y-M-d H:i')); ?></div>
            <div class="pt-1">
                <p>Order Reference: <b class="text-dark"> <?php echo e($data->reference); ?></b></p>
            </div>
            <div class="pt-1">
                <p>Order #<?php echo e($data->id); ?> is currently<b class="text-dark"> <?php echo e(ucwords($data->status)); ?></b></p>
            </div>

            <?php if($data->tracking_number ?? ''): ?>
                <div class="pt-1">
                    <p>Order Tracking #<b class="text-dark"> <?php echo e($data->tracking_number); ?></b></p>
                </div>
            <?php endif; ?>

            <div class="btn close text-white"> &times; </div>
        </div>

        <style>
            .table th, .table td{
                vertical-align: middle !important;
            }
        </style>

        <?php $sub_total = 0; ?>

        <div class="wrapper bg-white">

            <div class="table-responsive">
                <table class="table table-borderless">
                    <thead>
                    <tr class="text-uppercase text-muted">
                        <th scope="col">product</th>
                        <th scope="col">name</th>
                        <th scope="col">sku</th>
                        <th scope="col">size</th>
                        <th scope="col">brand</th>
                        <th scope="col">quantity</th>
                        <th scope="col" class="text-right">price</th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php $__empty_1 = true; $__currentLoopData = $data->order_detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <?php $__empty_2 = true; $__currentLoopData = $order_detail->product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>

                                
                                <?php if((float)$product->sale_price > 0): ?>
                                    <?php $sub_total = $sub_total + $product->sale_price * (float)$order_detail->quantity; ?>
                                <?php elseif((float)$product->sale_price_sizes > 0): ?>
                                    <?php $sub_total = $sub_total + $product->sale_price_sizes * (float)$order_detail->quantity; ?>
                                <?php else: ?>
                                    <?php $sub_total = $sub_total + $product->regular_price * (float)$order_detail->quantity; ?>
                                <?php endif; ?>
                                

                                <td><img src="<?php echo e(@getimagesize($product->image_url ?? '') ? ($product->image_url ?? '') : ($product->image_url_vendor ?? '')); ?>" alt="apple" class="rounded-circle" width="60" height="60"></td>
                                <td><?php echo e(($product->product_name ?? '') ?: ($product->product_parent->product_name ?? '')); ?></td>
                                <td><?php echo e(($product->product_name ?? '') ? ($product->sku ?? '') : ($product->product_parent->sku ?? '')); ?></td>
                                <td><?php echo e($order_detail->size_detail->size ?? ''); ?></td>
                                <td><?php echo e(($product->brand->brand_name ?? '') ?: \App\Models\Brand::find($product->product_parent->brand_id ?? 0)->brand_name ?? ''); ?></td>
                                <td><?php echo e($order_detail->quantity ?? ''); ?></td>
                                <td class="text-right"><?php echo e(number_format((float)($order_detail->price ?? 0), 2, '.', '')); ?></td>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php endif; ?>
                    </tbody>
                </table>

            </div>

            <div class="pt-2 border-bottom mb-3"></div>

            <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                <div class="text-muted">Payment Type</div>
                <div class="ml-auto">
                    <label><?php echo e(\App\Models\Order::PAYMENT_TYPES[$data->payment_type ?? 0] ?? ''); ?></label>
                </div>
            </div>

            <div class="d-flex justify-content-start align-items-center pl-3">
                <div class="text-muted">Payment Method</div>
                <?php if($data->payment_type == 1): ?>
                    <div class="ml-auto"> <img src="<?php echo e(asset('admin/uploads/cash_on_d.jpg')); ?>" alt="" width="30" height="30">
                        <label> Cash On Delivery </label>
                    </div>
                <?php elseif($data->payment_type == 2): ?>
                    <div class="ml-auto"> <img src="<?php echo e(asset('admin/uploads/cash_on_d.jpg')); ?>" alt="" width="30" height="30">
                        <label> PayPal Card Payment </label>
                    </div>
                <?php else: ?>
                    <div class="ml-auto">

                        <img src="<?php echo e(asset('admin/uploads/card_on_d.jpg')); ?>" alt="" width="30" height="30">
                        <?php
                        if($payment_response = json_decode($data->stripe_response ?? '[]', true)['charge.succeeded'] ?? false){
                            $payment_response = $payment_response['source']['brand'] . ' ******' . $payment_response['source']['last4'];
                        } else {
                            $payment_response = "XXXX ******XXXX";
                        }
                        ?>
                        <label><?php echo e($payment_response); ?></label>
                    </div>
                <?php endif; ?>

            </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Subtotal</div>
            <div class="ml-auto"> <label><?php echo e(number_format((float)$sub_total, 2, '.', '')); ?></label> </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted"> Shipping </div>
            <div class="ml-auto"><?php echo e(number_format((float)$data->shipping, 2, '.', '')); ?>  </div>
        </div>
        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted"> Processing </div>
            <div class="ml-auto"><?php echo e(number_format((float)$data->processing, 2, '.', '')); ?>  </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Discount</div>
            <div class="ml-auto"> <label><?php echo e(number_format((float)(($sub_total + $data->shipping + $data->processing) - $data->total_price), 2, '.', '')); ?></label> </div>
        </div>

        <div class="d-flex justify-content-start align-items-center pl-3 py-3 mb-4 border-bottom">
            <div class="text-muted"> Total </div>
            <div class="ml-auto h5"><?php echo e(number_format((float)$data->total_price, 2, '.', '')); ?>  </div>
        </div>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Related Subsriptions</div>

        <div class="d-sm-flex justify-content-between rounded my-3 subscriptions">
            <div> <b>Order #<?php echo e($data->id); ?></b> </div>
            <div>Order Date: <?php echo e(date_format($data->created_at,'Y-M-d')); ?></div>
            <div>Status: <?php echo e(ucwords($data->status)); ?></div>
            <div> Total: <b><?php echo e(number_format((float)$data->total_price, 2, '.', '')); ?>   </b> </div>
        </div>

        <br>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Buyers Info</div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Name</div>
            <div class="ml-auto"> <?php echo e($data->user->first_name ?? ""); ?> <?php echo e($data->user->last_name ?? ""); ?> </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Email</div>
            <div class="ml-auto">  <?php echo e($data->user->email ?? ""); ?> </div>
        </div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
            <div class="text-muted">Contact Number</div>
            <div class="ml-auto">   <?php echo e($data->user->phone ?? ""); ?> </div>
        </div>

        <?php if(isset($data->order_detail)): ?>

            <?php $__empty_1 = true; $__currentLoopData = $data->order_detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php $__empty_2 = true; $__currentLoopData = $order_detail->product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>

                    <?php if($product->product_user ?? ''): ?>
                        <br>

                        <div class="pl-3 font-weight-bold" style="text-align: center;">Seller Info</div>


                        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                            <div class="text-muted">Name</div>
                            <div class="ml-auto"><?php echo e($product->product_user->first_name ?? '' . " " . $product->product_user->last_name ?? ''); ?></div>
                        </div>

                        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                            <div class="text-muted">Email</div>
                            <div class="ml-auto"><?php echo e($product->product_user->email ?? ''); ?></div>
                        </div>

                        <div class="d-flex justify-content-start align-items-center py-1 pl-3">
                            <div class="text-muted">Contact Number</div>
                            <div class="ml-auto"><?php echo e($product->product_user->phone ?? ''); ?></div>
                        </div>
                    <?php endif; ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>
        <?php endif; ?>

        <br>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Billing / Shipping Info</div>

        <div class="d-flex justify-content-start align-items-center py-1 pl-3" style="background: #F5F5F5; border: 1px solid #dee2e6;">
            <div>
                <ul class="listStyleNone">
                    <li>Country: <?php echo e($billing->country ?? ""); ?> </li>
                    <li>Address Line 1 : <?php echo e($billing->street_address ?? ""); ?> </li>
                    <li>Address Line 2 : <?php echo e($billing->appartment_address ?? ""); ?> </li>
                    <li>City/Town: <?php echo e($billing->city ?? ""); ?> </li>
                    <li>County : <?php echo e($billing->state ?? " "); ?> </li>
                    <li>Post Code: <?php echo e($billing->post_code ?? ""); ?> </li>
                    <li>Contact Number : <?php echo e($billing->phone ?? ""); ?></li>
                </ul>
            </div>
            <div class="ml-auto">
                <ul class="listStyleNone">
                    <li>Country: <?php echo e($shipping->country ?? ""); ?> </li>
                    <li>Address Line 1 : <?php echo e($shipping->street_address ?? ""); ?> </li>
                    <li>Address Line 2 : <?php echo e($shipping->appartment_address ?? ""); ?> </li>
                    <li>City/Town: <?php echo e($shipping->city ?? " "); ?> </li>
                    <li>County : <?php echo e($shipping->state ?? ""); ?> </li>
                    <li>Post Code: <?php echo e($shipping->post_code ?? ""); ?> </li>
                    <li>Contact Number : <?php echo e($shipping->phone ?? ""); ?> </li>
                </ul>
            </div>
        </div>

        <br>

        <div class="pl-3 font-weight-bold" style="text-align: center;">Shipping Documents</div>

        <table class="table table-striped" cellspacing="0" width="100%">
            
            <thead>
            <tr style="background: lightgray;">
                <th>Name</th>
                <th>Type</th>
                <th>Uploaded At</th>
                <th>Action</th>
            </tr>
            </thead>
            <tbody>

            <?php if(count($documents) > 0): ?>
                <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($document->name); ?></td>
                        <td><?php echo e(strtoupper($document->extension)); ?></td>
                        <td><?php echo e(date_format($document->created_at,'d-m-Y')); ?></td>
                        <td><a href="<?php echo e(route('down.document', ['id' => encrypt($document->id)])); ?>" class="btn btn-info btn-sm">Download</a></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <td colspan="4" class="text-center">There is no documents</td>
            <?php endif; ?>
            </tbody>
        </table>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.user.user-masters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/resources/views/frontend/user/order-detail.blade.php ENDPATH**/ ?>