<?php $__env->startSection('styles'); ?>
<link rel="stylesheet"
    href="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-content'); ?>
<div class="page-wrapper">
    <!-- Page Title -->
    <div class="page-title">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <h2 class="page-title-text"></h2>
            </div>
            <div class="col-sm-6 text-right">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li>Dashboard</li>
                        <li>News</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Button Code Starts Here -->


    <!-- Action Button Code Ends Here -->

    <!-- Page Body -->
    <div class="page-body">
        <div class="row">


            <div class="col-12">
                <div class="panel panel-default">

                    
                    <div class="panel-head">
                      
                    </div>

                    <div class="panel-body">
                        <?php if( session()->has('message') ): ?>
                            <div class="alert alert-icon alert-success alert-dismissible fade show">
                                <div class="alert--icon">
                                    <i class="fa fa-check"></i>
                                </div>
                                <div class="alert-text">
                                    <strong>Well done!</strong> <?php echo e(session('message')); ?>

                                </div>
                                <button type="button" class="close" data-dismiss="alert">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        <div class="table-responsive">
                        <table id="myTable"
                            class="table table-head-bg table-head-primary table table-striped table-bordered basic-datatable"
                            cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Section</th>
                                    <th>Article Title</th>
                                    <th>Brand</th>
                                    <th>Date Published</th>
                                    <th>Views</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php if(isset($data)): ?>
                                <?php $counter = 0;?>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                        <tr>
                                            <td><?php echo ++$counter; ?></td>
                                            <td><?php echo $news->section; ?></td>
                                            <td><?php echo $news->title;?></td>
                                            <td><?php if(isset($news->brand->brand_name)){ echo $news->brand->brand_name; }?></td>
                                          
                                          <td><?php echo \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $news->created_at)
                                    ->format('d/m/Y - H:i'); ?></td>

                                          <td><?php echo $news->visit; ?></td>
                                          

                                                <td> 
                                                    <span class="badge <?php echo ($news->active == 1) ? 'badge-success' : 'badge-danger'; ?> badge-sm badge-pill"><?php echo ($news->active == 1) ? 'Active' : 'Not Active'; ?></span>
                                                </td>
                                                
                                          


                                             <td><a href="<?php echo e(route('news-edit',[$news->id])); ?>" class="btn btn-primary btn-sm m-1">Edit</a>
                                              <a onclick="return myFunction();" href="<?php echo e(route('news-delete',[$news->id])); ?>" class="btn btn-danger btn-sm m-1">Delete</a></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                            </tbody>
                            <tfoot>
                                <tr>
                                <th>ID</th>
                                    <th>Title</th>
                                    <th>Brand Name</th>
                                    <th>image</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript"
    src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>
<!-- <script type="text/javascript" src="<?php echo e(asset('admin/dist/js/demo/datatable.js')); ?>"></script> -->
<script>
 function myFunction() {
      if(!confirm("Are you sure to delete this"))
      event.preventDefault();
  }

    function get_dist(val, i) {
        orderStatus = $(val).val();
        orderId = i;

        $.ajax({
            url: "<?php echo e(route('order.status')); ?>",
            method: 'post',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                orderStatus: orderStatus,
                orderId: orderId,

            },
            success: function (result) {
                if (result.response.message) {
                    console.log(result.response.message);
                    location.reload();
                }
                //result = JSON.parse(result)

            }
        });

    }

</script>

<script>
    var exampleTable = $('#myTable').DataTable({
        aLengthMenu: [
            [25, 50, 100, 200],
            [25, 50, 100, 200]
        ],
        iDisplayLength: 25,
    });

    $(document).ready(function() {

        let url = "<?php echo e(route('add.news')); ?>";
        $('<div class="pull-right">' + '' +
            '</div>').appendTo("#myTable_wrapper .dataTables_filter");
        $("#myTable_length").append('<a href="'+url+'" class="btn btn-primary btn-shadow" >Add News</a>');
    

    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/admin/news/view-all-news.blade.php ENDPATH**/ ?>