



<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-content'); ?>
<div class="page-wrapper">
    <!-- Page Title -->
    <div class="page-title">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <h2 class="page-title-text"></h2>
            </div>
            <div class="col-sm-6 text-right">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li>Dashboard</li>
                        <li>Product</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Button Code Starts Here -->

    <div class="action-button-box">
        <?php if(Auth::guard('admin')->check()): ?>
       
        <?php endif; ?>
    </div>

    <!-- Action Button Code Ends Here -->

    <!-- Page Body -->
    <div class="page-body">
        <div class="row">

            <div class="col-12">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <?php if( session()->has('message') ): ?>
                        <div class="alert alert-icon alert-success alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Well done!</strong> <?php echo e(session('message')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <?php elseif(session()->has('error')): ?>
                        <div class="alert alert-icon alert-danger alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-thermometer"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Oh snap!</strong> <?php echo e(session('error')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>
                        <div class="table-responsive">
                            <table class="table table-head-bg table-head-primary table table-striped table-bordered basic-datatable" cellspacing="0" width="100%" id="myTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Product Name</th>
                                        <th>Price</th>
                                        <th>Stock Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php if(isset($products)): ?>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td><?php echo e($product['id']); ?></td>
                                        <td><?php echo e($product['product_name']); ?></td>
                                        <td> £<?php if((float)$product['sale_price']>0): ?><?php echo e(number_format((float)$product['sale_price'], 2, '.', '')); ?> <?php else: ?> <?php echo e(number_format((float)$product['regular_price'], 2, '.', '')); ?> <?php endif; ?> </td>
                                        <td> <?php if((int)$product['quantity']>=0): ?> <?php echo e((int)$product['quantity']); ?> <?php else: ?>   0 <?php endif; ?></td>
                                        <?php if($product['active'] == 1): ?>
                                        <td><span class="badge badge-success badge-sm badge-pill">Active</span></td>
                                        <?php else: ?>
                                        <td><span class="badge badge-danger badge-sm badge-pill">Not Active</span></td>
                                        <?php endif; ?>
                                        <td>
                                            <a href='<?php echo e(url("dashboard/product/$product[id]")); ?>?brand_id=<?php echo e($brand_id ?? ""); ?>&&cat_id=<?php echo e($category_id ?? ""); ?>' class="btn btn-primary btn-sm m-1">Edit</a>
                                            <a id="delete" href="<?php echo e(route('product.delete', ['id' => $product['id']])); ?>" class="btn btn-danger btn-sm m-1">Delete </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>ID</th>
                                        <th>Product Name</th>
                                        <th>Price</th>
                                        <th>Stock Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>



<script>
    var exampleTable = $('#myTable').DataTable({
        aLengthMenu: [
            [25, 50, 100, 200],
            [25, 50, 100, 200]
        ],
        iDisplayLength: 25,
    });

    $(document).ready(function() {

        let url = "<?php echo e(route('add.product', ['brand_id' => $brand_id, 'category_id' => $category_id])); ?>";
        $('<div class="pull-right">' + '' +
            '</div>').appendTo("#myTable_wrapper .dataTables_filter");
        $("#myTable_length").append('<a href="'+url+'" class="btn btn-primary btn-shadow" >Add Product</a>');
    

    });
</script>

<script>
    $(document).on("click", "#delete", function(e) {
        if (confirm('Are you sure to remove this record ?')) {} else {
            e.preventDefault();
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/admin/product/product-with-categories.blade.php ENDPATH**/ ?>