<?php
use App\Models\Product;
use App\Models\Size;
?>


<?php $__env->startSection('user-content'); ?>
    <div class="column content px-2">

        <div class="tabs-wrapper orders-tabs">
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="tab-1" data-toggle="tab" href="#tab-one">Orders Placed</a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="tab-one">

                    <?php if(!$orders->isEmpty()): ?>

                        <div class="table-responsive">
                            <table class="table orders-table" id="user_orders_dt">
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>DATE</th>
                                    <th>REFERENCE</th>
                                    <th>PRODUCT</th>
                                    <th>SIZE</th>
                                    <th>PRICE</th>
                                    <th>STATUS</th>
                                    <th>ACTION</th>
                                </tr>
                                </thead>

                                <tbody>

                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td><?php echo e($order->id); ?></td>
                                        <td><?php echo e(date('d/m/Y', strtotime($order->created_at))   ?? ""); ?></td>
                                        <td><?php echo e($order->reference); ?></td>
                                        <td>
                                            <?php if(count($order->details)>1): ?>
                                                Multiple
                                            <?php elseif(isset($order->details[0]->id) && $order->details[0]->parent_id==0 ): ?>
                                                <?php echo e($order->details[0]->product_name ?? ""); ?>

                                            <?php else: ?>
                                                <?php echo e(Product::where("id",$order->details[0]->parent_id)->first()->product_name ?? ''); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(count($order->details) > 1): ?>
                                                Multiple
                                            <?php else: ?>
                                                <?php echo e(Size::where("id",$order->details[0]->size_id)->first()->size ?? ""); ?>

                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e(number_format($order->total_price, 2)); ?> </td>

                                        <?php if($order->status == 'processing'): ?>
                                            <td><span class="badge badge-danger "><?php echo e($order->status); ?></span></td>
                                        <?php elseif($order->status == 'completed'): ?>
                                            <td><span class="badge badge-success "><?php echo e($order->status); ?></span></td>
                                        <?php elseif($order->status == 'refunded'): ?>
                                            <td><span class="badge badge-warning "><?php echo e($order->status); ?></span></td>
                                        <?php elseif($order->status == 'cancelled'): ?>
                                            <td><span class="badge badge-info "><?php echo e($order->status); ?></span></td>
                                        <?php elseif($order->status == 'onhold'): ?>
                                            <td><span class="badge badge-primary "><?php echo e($order->status); ?></span></td>
                                        <?php endif; ?>

                                        <td style="text-align:left;">
                                            <a href="<?php echo e(route('user_order_detail', ['id' => $order->id])); ?>" class="btn blue-button-outline">details</a>

                                            <?php if($order->paid == 0): ?>
                                                <a href="<?php echo e(route('user_payment', ['id' => $order->id])); ?>" class="btn blue-button-outline">
                                                    Payment</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="8">
                                        <?php if($orders->count() < 1): ?>
                                            <div class="pagination justify-content-center">
                                                <?php echo e(__('No record found.')); ?>

                                             </div>
                                        <?php endif; ?>
                                        <div class="pagination mt-3">
                                            <?php echo $orders->links("pagination::bootstrap-4"); ?>

                                        </div>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="no-order">
                            <p>
                                <i class="uil uil-exclamation-triangle"></i>
                                No order has been made yet.
                            </p>
                            <a href="#" class="btn blue-button-outline">Browse products</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript" src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>

    <script>

        $(document).ready(function () {
            $('#user_orders_dt').DataTable({
                searching: false,
                paging: false,
                info: false,
                aaSorting: [[1, "asc"]]
            });
        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.user.new-masters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/resources/views/frontend/user/orders.blade.php ENDPATH**/ ?>