<?php

use Illuminate\Support\Carbon;

?>


<?php $__env->startSection('title'); ?>
The Marketplace
<?php $__env->stopSection(); ?>
<?php $__env->startSection('banner'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<?php


$recent_products = Cookie::get('recentViews');
$user_id = 0;
if ($recent_products) {
  $recent_products .= ',' . $data->product_id;
  Cookie::queue('recentViews', $recent_products, 86400);
} else {
  Cookie::queue('recentViews', $product->id, 86400);
  $recent_products = $product->id;
}
$recent_prod_array = array_unique(explode(",", $recent_products));
$recent_view_products = \App\Models\Product::whereIn('id', $recent_prod_array)->get();
$current_url = URL::current();
$reviews = 0;

if (auth()->user()) {
  $user_id = auth()->user()->id;
}
?>




<main class="product-page pb-0">
  <div class="container pt-5">

    <div class="product-layout used-product-layout">
      <div class="column images-column">
        <div class="inner-wrapper">
          <div class="img-box">
            <img src="<?php echo e(url('/').'/storage/seller-product/'.$data->id.'/'.$data->feature_image); ?>" class="-img-fluid">
          </div>
          <?php $__currentLoopData = $multiimages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="img-box">
            <img src="<?php echo e(url('/').'/storage/seller-product/'.$mi->product_id.'/'.$mi->image); ?>" class="-img-fluid">
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        
      </div>
      <div class="column product-details-column">
        <div class="heading-area">
          
          <h4 class="text-dark mb-0"><?php echo e($data->product_parent->product_name); ?></h4>
          
        </div>
        
        <div class="used-product-details pt-0">
          <div class="table-box">
            <div class="table-responsive">
              <table class="table">
                
                <tr>
                  <td>Price</td>
                  <td>£<?php echo e(number_format($data->sale_price, 2) ?? 0); ?></td>
                </tr>
                <tr>
                  <td>Size</td>
                  <td><?php echo e($data->size); ?></td>
                </tr>
                <tr>
                  <td>Condition</td>
                  <td><?php echo e($data->condition); ?></td>
                </tr>
                <tr>
                  <td>Faults</td>
                  <td><?php echo e(rtrim($all_faults)); ?></td>
                </tr>


                

                
              </table>
            </div>
          </div>

          <div class="buttons-wrapper">
            <a href="<?php echo e(route('back',[$data->product_parent->id, $id])); ?>" class="btn cancel">Cancel</a>
            
            
            <a href="#" class="btn cart-btn" onclick="cart(<?php echo e($id); ?>);">Add To Cart</a>
          </div>
        </div>


      </div>
    </div>


    <div class="social">
      <p class="mr-3">Share</p>
      <p>
        <a href="#"><i class="fab fa-facebook-f"></i></a>
        <a href="#"><i class="fas fa-envelope"></i></a>
        <a href="#"><i class="fab fa-twitter"></i></a>
        <a href="#"><i class="fab fa-pinterest"></i></a>
      </p>
    </div>

    <div class="product-info">
      <div class="">
        <p><span>Category:</span> <a href="#"><?php echo e($data->product_parent->shop_category->shop_cat_name); ?></a></p>
      </div>
      <div class="">
        
      </div>
      <div class="">
        <p><span>SKU: </span> <?php echo e($data->product_parent->sku); ?></p>
      </div>
    </div>

    <div class="product-description">
      <h6>Product Description</h6>
      <?php echo $data->product_parent->product_description; ?>

    </div>
    

  <div class="related-products">
    <h5 class="heading-5">Related Products</h5>

    <div class="owl-carousel owl-theme product-slider" id="slider-men-new">
      <?php $__currentLoopData = $related; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

      <?php


						// Creates DateTime objects
						$datetime1 = date_create($product->created_at);
						$datetime2 = date_create(Carbon::now());

						// Calculates the difference between DateTime objects
						$interval = date_diff($datetime1, $datetime2);

						// Printing result in years & months format
						$diff = (int)$interval->format('%a');


						// dd($product->created_at);

						?>

						<div class="card product-card">
							<div class="card-header">
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
									<div class="img-box">
										<img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
									</div>
									<div class="tags">
										<?php if((int)$product->discount>0): ?>
										<span class="discount-tag"> -<?php echo e($product->discount); ?>% </span>
										<?php endif; ?>
										<?php if($diff<=14): ?> <span class="new-tag">New</span>
											<?php endif; ?>
									</div>

								</a>
							</div>
							<div class="card-body" style="text-align:center;">
								<div class="product-category">

									
									<a href="">
									</a>
								</div>
								<a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="product-title"><?php echo e($product->product_name); ?></a>
								<?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
								<span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
								<span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
								<?php else: ?>

								<span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

								<?php endif; ?>


							</div>
						</div>
      
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>




  </div>







</main>


<div class="alert alert-dismissible fade " role="alert">
  <button id="error_model" type="button" class="close buttonAlert" data-dismiss="alert" aria-label="Close" onclick="closeup()">
    <i class="uil uil-multiply"></i>
  </button>
  <p style="text-align:center;" class="displayContent"></p>

</div>






<?php $__env->stopSection(); ?>



<script>
  function previous() {


    //window.history.back()
    window.history.back();
    //alert("Anas");



  }


  function cart(id) {

    $.ajax({
      url: "<?php echo e(route('add_cart')); ?>",
      method: 'post',
      data: {
        "_token": "<?php echo e(csrf_token()); ?>",
        product_id: id,

      },
      success: function(result) {

        if (result.status == "true") {
          $('.alert-dismissible').addClass('success-alert');
          $('.alert-dismissible').addClass('show').find('p').html("Product added to the cart");
          parent.location.reload();
        } else {
          // swal({
          // title: "Please login first",
          // type: "error",
          // confirmButtonClass: "btn-success",
          // confirmButtonText: "OK",

          // },
          // function() {

          // });
          var lo = "<?php echo route('login.login'); ?>";
          $('.alert-dismissible').addClass('success-alert');
          $('.alert-dismissible').addClass('show').find('p').html('User must be logged in. Click <a style="color:#00A9EC !important;" href="' + lo + '">here </a> to sign in');

        }




      }
    });

  }

  function closeup() {
    var login = '<?php echo route("login.login");  ?>';
    window.location.href = login;
  }
</script>
<?php echo $__env->make('layouts.frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/frontend/home/variation_page.blade.php ENDPATH**/ ?>