<?php $__env->startSection('body-content'); ?>




<section>


    <!-- ---------------------------------------------------- -->
    <!-- ---------------------------------------------------- -->
    <!-- -------------------- Admin's View ------------------ -->
    <!-- ---------------------------------------------------- -->
    <!-- ---------------------------------------------------- -->

    <div class="white-box-div order-view">
        <div class="panel panel-default">
            <div class="panel-head">
                <h5 class="panel-title">Buyers Info</h5>
            </div>
            <div class="panel-body">
                <form action="">
                    <div class="row">
                        <div class="col-lg-3 col-sm-3">
                            <div class="detail-box">
                                <label for="">Name</label>
                                <div class="value-box">
                                    <?php echo e($data->user->first_name ?? ""); ?> <?php echo e($data->user->last_name ?? ""); ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-3">
                            <div class="detail-box">
                                <label for="">Email</label>
                                <div class="value-box">
                                <?php echo e($data->user->email ?? ""); ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-3">
                            <div class="detail-box">
                                <label for="">Contact Number</label>
                                <div class="value-box">
                                    <?php echo e($data->user->phone ?? ""); ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-sm-3 payment-type">
                            <div class="detail-box">
                                <label for="">Payment Type</label>
                                <div class="value-box">
                                    <?php echo e(\App\Models\Order::PAYMENT_TYPES[$data->payment_type ?? 0] ?? ""); ?>

                                </div>
                            </div>
                            
                    </div>

            </div>
            <div class="row" style="width:100%">
                <div class="col-lg-4 col-md-4 col-sm-12">
                    <div class="detail-box">
                        <label for="">Billing Address</label>
                        <div class="value-box big">
                            <span>
                                <ul class="listStyleNone">
                                    <li>Country: <?php echo e($billing->country ?? ""); ?></li>
                                    <li>Address Line 1 : <?php echo e($billing->street_address ?? ""); ?> </li>
                                    <li>Address Line 2 : <?php echo e($billing->appartment_address ?? ""); ?> </li>
                                    <li>City/Town: <?php echo e($billing->city ?? ""); ?></li>
                                    <li> County : <?php echo e($billing->state ?? " "); ?> </li>
                                    <li>Post Code: <?php echo e($billing->post_code ?? ""); ?> </li>
                                    <li>Contact Number : <?php echo e($billing->phone ?? ""); ?> </li>
                                </ul>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-sm-12">
                    <div class="detail-box">
                        <label for="">Shipping Address</label>
                        <div class="value-box big">
                        <span>
                            <ul class="listStyleNone">
                                <li>Country: <?php echo e($shipping->country ?? ""); ?></li>
                                <li>Address Line 1 : <?php echo e($shipping->street_address ?? ""); ?> </li>
                                <li>Address Line 2 : <?php echo e($shipping->appartment_address ?? ""); ?> </li>
                                <li>City/Town: <?php echo e($shipping->city ?? " "); ?></li>
                                <li>County : <?php echo e($shipping->state ?? ""); ?></li>
                                <li>Post Code: <?php echo e($shipping->post_code ?? ""); ?></li>
                                <li>Contact Number : <?php echo e($shipping->phone ?? ""); ?></li>
                            </ul>
                        </span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2  col-sm-12 text-center track-order">
                    <div class="detail-box">
                        <label for="">Tracking</label>
                        <input type="text" id="tracking" value="<?php echo e($data->tracking_number); ?>">
                        <button class="btn btn-primary">Track</button>
                        <button type="button" class="btn btn-primary" onclick="get_submit(<?php echo $data->id; ?>)">Submit</button>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-12">
                    <div class="detail-box">
                            <label for="">Order Date</label>
                            <div class="value-box">
                             <?php if(isset($data->created_at)): ?> <?php echo e(date_format($data->created_at,'d-m-Y')); ?> <?php endif; ?>
                            </div>
                        </div>
                        <div class="detail-box">
                            <label for="">Order Time</label>
                            <div class="value-box">
                                <?php if(isset($data->created_at)): ?>
                                <?php echo e(date_format($data->created_at,'H:i')); ?>


                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="detail-box">
                            <label for="">Reference</label>
                            <div class="value-box">
                                <?php echo e(strtoupper($data->reference) ?? ""); ?>

                            </div>
                        </div>

            </div>
            </div>













            <br>


            <h5 class="panel-title">Product Info</h5>





            <?php if(isset($data->allorder_details)): ?>

            <!-- Product Details Row Start -->
            <?php $__empty_1 = true; $__currentLoopData = $data->allorder_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

            <?php $__empty_2 = true; $__currentLoopData = $order_detail->product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
            <div class="row product-row">
                <div class="col-lg-2 col-md-2 col-sm-12">
                    <div class="detail-box">
                        <label for="">Product Name</label>
                        <div class="value-box">
                        <?php echo $product->product_name; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-12">
                    <div class="detail-box">
                        <label for="">Size</label>
                        <div class="value-box">
                            <?php echo e($order_detail->size_detail->size ?? ""); ?>

                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-12">
                    <div class="detail-box">
                        <label for="">Price</label>
                        <div class="value-box">
                        £<?php if ($order_detail->price != NULL) echo  number_format((float)$order_detail->price, 2, '.', '');
                                    else echo number_format((float)$order_detail->price, 2, '.', '');  ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-1 col-md-1 col-sm-12">
                    <div class="detail-box">
                        <label for="">Discount</label>
                        <div class="value-box">
                        £<?php echo number_format((float)$product->discount, 2, '.', ''); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-1 col-md-1 col-sm-12">
                    <div class="detail-box">
                        <label for="">Quantity</label>
                        <div class="value-box">
                            <?php echo abs($order_detail->quantity); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-1 col-md-1 col-sm-12">
                    <div class="detail-box">
                        <label for="">SKU</label>
                        <div class="value-box">
                            <?php echo $product->sku; ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 col-md-2 col-sm-12">
                    <div class="detail-box">
                        <label for="">Action</label>
                        <div class="">
                            <button class="btn btn-primary" onclick = "get_dist(<?php echo $data->id; ?>,<?php echo $order_detail->odd ?>, <?php  echo $order_detail->refund;   ?>)"><?php if($order_detail->refund==0): ?> Refund  <?php else: ?> Refunded <?php endif; ?> </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>
            <!-- Product Details Row End -->
            <?php endif; ?>

            </form>
        </div>
    </div>
    </div>

    <!-- ---------------------------------------------------- -->
    <!-- ---------------------------------------------------- -->
    <!-- ------------------- Seller's View ------------------ -->
    <!-- ---------------------------------------------------- -->
    <!-- ---------------------------------------------------- -->



</section>
</div>
</div>
<?php $__env->stopSection(); ?>

<script>
    function get_dist(order_id, detail_id, status) {

        event.preventDefault();




        $.ajax({
            url: "<?php echo e(route('order.status')); ?>",
            method: 'post',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                orderStatus: status,
                orderId: detail_id,
            },
            success: function(result) {
                if (result.response.message) {


                    console.log(result.response.message);
                    location.reload();
                }


            }
        });

    }

    function get_submit(id) {

        var tracking=$("#tracking").val();



        $.ajax({
            url: "<?php echo e(route('order.tracking')); ?>",
            method: 'post',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                tracking: tracking,
                orderId: id,
            },
            success: function(result) {
                if (result.response.message) {


                    console.log(result.response.message);
                    location.reload();
                }


            }
        });





    }
</script>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/admin/order/allorder-detail-buyer.blade.php ENDPATH**/ ?>