

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.css')); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-content'); ?>
<div class="page-wrapper">
    <!-- Page Title -->
    <div class="page-title">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <h2 class="page-title-text"></h2>
            </div>
            <div class="col-sm-6 text-right">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li>Dashboard</li>
                        <li>My Products</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-12">
                <div class="panel panel-default">
                    <div class="panel-head">
                      
                    </div>
                    <div class="panel-body">
                        <?php if( session()->has('message') ): ?>
                        <div class="alert alert-icon alert-success alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Well done!</strong> <?php echo e(session('message')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php elseif( session()->has('error') ): ?>
                        <div class="alert alert-icon alert-danger alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Ohh Snap!</strong> <?php echo e(session('error')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <div class="table-responsive">
                        <table
                            class="table table-head-bg table-head-primary table table-striped table-bordered basic-datatable"
                            cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Seller’s Name</th>
                                    <th>Product Name</th>
                                    <th>Price</th>
                                    <th>Fault Status</th>
                                    <th>Status</th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($data)): ?>
                                <?php $counter = 0;?>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo ++$counter;?></td>
                                    <td><?php echo e($product->user->first_name); ?> <?php echo e($product->user->last_name); ?></td>
                                    
                                    <td>
                                        <?php echo e($product->product_parent->product_name); ?>

                                    </td>
                                    <td>
                                        <?php $__currentLoopData = $product->prod_size; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_sizes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             £<?php echo e(number_format((float)$product_sizes->sale_price, 2, '.', '')); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        
                                    </td>
                                    <?php if($product->fault == 1): ?>
                                    <td><span class="badge badge-warning badge-md badge-pill">Fault</span></td>
                                    <?php else: ?>
                                    <td><span class="badge badge badge-success badge-sm badge-pill">No Fault</span></td>
                                    <?php endif; ?>
                                   <?php if($product->active == 1): ?>
                                        <td><span class="badge badge-success badge-sm badge-pill">Live</span></td>
                                   
                                   <?php else: ?>
                                    <td><span class="badge badge-danger badge-sm badge-pill">Non-Active</span></td>
                                    <?php endif; ?> 

                                
                               

                                    <?php $__currentLoopData = $product->prod_size; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_sizes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             
                                       

                                   
                                    <td><a href="<?php echo e(route('vendor_product_detail',[$product_sizes->id])); ?>" class="btn btn-primary btn-sm m-1">Details</a>
                                       
                                         <a id="delete" href="<?php echo e(route('product.delete',[$product_sizes->id])); ?>" class="btn btn-danger btn-sm m-1">Delete</a>
                                    </td>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                <th>ID</th>
                                    <th>Seller’s Name</th>
                                    <th>Product Name</th>
                                    <th>Price</th>
                                    <th>Fault Status</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('admin/dist/js/demo/datatable.js')); ?>"></script>
<script>

    function chgStatus(id,status)
    {
        
       
    

        var val=$("#change").find(":selected").val();
        $.ajax({
            url: "<?php echo e(route('product.chgStatus')); ?>",
            method: 'post',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                id : id,
                status: status
                
            },
            success: function(result) {
                if (result.response.message) {


                   
                }


            }
        });



    }


    $(document).on("click", "#delete", function(e) {
        if (confirm('Are you sure to remove this record ?')) {
        } else {
            e.preventDefault();
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/admin/vendor/vendors-product.blade.php ENDPATH**/ ?>