<?php
$my_id=0;

if(isset(auth::user()->id))
{
    $my_id=auth::user()->id;
    $p = \App\Models\Cart::select(["products.*","carts.*","product_sizes.sale_price as sale_price_sizes","products.delivery_charges as delivery_charges","sizes.size","shop_categories.shipping as ship"])
        ->leftjoin("products","products.id","=","carts.product_id")
        ->leftjoin("product_sizes","product_sizes.product_id","=","products.id");
    $p->leftjoin("sizes","sizes.id","=","product_sizes.size_id");
    $p->leftjoin("shop_categories","shop_categories.id","=","products.shop_category_id");
    $p->where("user_id",$my_id)->groupBy("carts.id");

    $cart_data=$p->get();

    $ship=\App\Models\Setting::where("key","fixed_shipping")->first();

    if(isset($ship->value))
    {
        $val=$ship->value;
        preg_match('!\d+!', $ship->value, $matches);
        $shipping=(int) $matches[0];
    } else {

        $shipping= 15;
    }
}
?>

<header id="header">

    <?php $__env->startSection('banner'); ?>

        <div class="video-container">
            <video autoplay muted loop id="myVideo">
                <source src="https://www.t-mp.co.uk/tmp-homepage2.mp4" type="video/mp4">
            </video>

            <div id="banner-slider" class="carousel slide carousel-fade" data-ride="carousel">
                <div class="carousel-inner" style="display: none;">
                    <div class="carousel-item active">
                        
                    </div>
                    <div class="carousel-item">
                        
                    </div>
                    <div class="carousel-item">
                        
                    </div>
                </div>
                <div style="  position: absolute; top: 24%; width: 100%;">
                    <h1 style="font-size:clamp(2rem, 4vw, 5.5rem); text-transform: uppercase; color: #000; font-weight: 700; font-family: roboto; margin: 70px auto 40px; text-align:center; letter-spacing: 1px;">The Market place</h1>
                    <div class="form-group " style="margin:auto 5%;">
                        <div class="input-group">

                            <input type="text" autofocus onkeypress="handleKeyPress(event)" class="form-control search_result_all1" placeholder="Search.." aria-label="Username"
                                   aria-describedby="basic-addon1" id="search" >
                            <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1"><i class="uil uil-search home-first"></i></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"
                 id="search-popup">
                <div class="modal-dialog  modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <div class="search-wrapper">
                                <div class="form-group m-0">
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Search.." aria-label="Username"
                                               aria-describedby="basic-addon1">
                                        <div class="input-group-append">
                                    <span class="input-group-text">
                                        <div class="typing-indicator">
                                            <span></span>
                                            <span></span>
                                            <span></span>
                                        </div>
                                    </span>
                                            <span class="input-group-text" id="basic-addon1"><i
                                                    class="uil uil-search"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="show_all_results">
                                    <div class="emptyresult">Nothing Found For : </div>
                                    <a href="#" class="productsearchlink"> dsf</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->yieldSection(); ?>
        </div>

        <nav class="navbar navbar-expand-xl">

            <a class="navbar-brand" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('assets/images/logo-black.png')); ?>" class="img-fluid"></a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <i class="uil uil-bars"></i>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <?php if(Route::currentRouteName()=="news"): ?>
                    <div class="navbar-page-title-dropdown">
                        News
                    </div>

                <?php elseif(Route::currentRouteName()=="start_selling_home"): ?>
                    <div class="navbar-page-title-dropdown">
                        Start Selling
                    </div>
                <?php elseif(Route::currentRouteName()=="shop_products"): ?>
                    <div class="navbar-page-title-dropdown">
                        Shops
                    </div>
                <?php elseif(Route::currentRouteName()=="login.login"): ?>
                    <div class="navbar-page-title-dropdown">
                        Sign In
                    </div>

                <?php endif; ?>

                <ul class="navbar-nav ml-auto">

                    <li class="nav-item <?php echo request()->route()->getName() == 'home' ? 'active': ''; ?>">
                    <!-- <a class="nav-link"   <?php if(Route::currentRouteName()=="news"): ?>  style="color:#fff;"  <?php endif; ?>  href="<?php echo e(route('home')); ?>">Home <span class="sr-only">(current)</span></a> -->
                        <a class="nav-link" href="<?php echo e(route('home')); ?>">Home <span class="sr-only">(current)</span></a>
                    </li>

                    <li class="nav-item <?php echo request()->route()->getName() == 'shop_products' ? 'active': ''; ?> dropdown">
                        <a class="nav-link"  href="<?php echo e(route('shop_products')); ?>" id="navbarDropdown">
                            Shop
                        </a>
                        <div class="dropdown-menu  shop-dropdown-menu <?php if(Auth::check()) echo 'account';?>" aria-labelledby="navbarDropdown">
                            <div class="wrapper">
                                <?php $shop_cats = App\Models\ShopCategory::whereRaw("flags & ? = ?", [App\Models\ShopCategory::FLAG_ACTIVE, App\Models\ShopCategory::FLAG_ACTIVE])->where('parent_id',0)->get()->toArray();
                                foreach ($shop_cats as $key => $shop_cat) {

                                    $child_cats = App\Models\ShopCategory::whereRaw("flags & ? = ?", [App\Models\ShopCategory::FLAG_ACTIVE, App\Models\ShopCategory::FLAG_ACTIVE])->where('parent_id',$shop_cat['id'])->orderBy('shop_cat_name', 'ASC')->get()->toArray()
                                ?>

                                <?php if(!empty($child_cats)) { ?>
                                    <div class="category">
                                        <h6 class="sub-heading">
                                            <a href="<?php echo e(route('product.category',[$shop_cat['shop_cat_slug']])); ?>"><?php echo $shop_cat['shop_cat_name'];?></a>
                                        </h6>
                                        <?php foreach ($child_cats as $key => $child_cat) { ?>
                                            <a href="<?php echo e(route('product.category',[$child_cat['shop_cat_slug']])); ?>?gender=<?php echo e($child_cat['parent_id']); ?>" class="dropdown-item"><?php if($child_cat['shop_cat_name']=="Trouser"){ echo $child_cat['shop_cat_name']."s"; }else{  echo $child_cat['shop_cat_name']; } ?></a>
                                        <?php } ?>
                                    </div>
                                    <?php } ?>
                                <?php } ?>

                                <div class="category">
                                    <h6 class="sub-heading"><a href="<?php echo e(route('view-all-brands')); ?>">BRANDS</a></h6>
                                    <?php $brands = App\Models\Brand::whereRaw("flags & ? = ?", [App\Models\Brand::FLAG_ACTIVE, App\Models\Brand::FLAG_ACTIVE])->orderBy('brand_name','asc')->take(18)->get()->toArray();
                                    foreach ($brands as $key => $brand) {
                                    ?>
                                    <a href="<?php echo e(route('product.brand',[$brand['id']])); ?>" class="dropdown-item"><?php echo $brand['brand_name']; ?></a>
                                    <?php }?>
                                    <a href="<?php echo e(route('view-all-brands')); ?>" class="dropdown-item">View All Brands</a>
                                </div>
                            </div>
                        </div>
                    </li>

                    <li class="nav-item  <?php echo request()->route()->getName() == 'news' ? 'active': ''; ?>">
                        <a class="nav-link"  href="<?php echo e(route('coming_soon')); ?>">News</a>
                    </li>

                    <?php if(Auth::check()): ?>
                        <li
                            class="nav-item  dropdown  <?php echo request()->route()->getName() == 'update_account' ? 'active': ''; ?> ">
                            <a class="nav-link" href="<?php echo e(route('update_account')); ?>" id="navbarDropdown">
                                Dashboard
                            </a>
                            <div class="dropdown-menu" aria-labelledby="navbarDropdown">

                                <?php if(auth()->user()->user_type == 1): ?>
                                    <a class="dropdown-item  " href="<?php echo e(route('update_account')); ?>">Account Details</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('edit_address')); ?>">Addresses</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('bank_detail')); ?>">Bank Information</a>
                                    <a class="dropdown-item" href="<?php echo e(route('my_list')); ?>"> My Listings</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('user_subscribe')); ?>">My Subscriptions</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('user_orders')); ?>">Orders</a>

                                <?php else: ?>
                                    <a class="dropdown-item  " href="<?php echo e(route('update_account')); ?>">Account details</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('edit_address')); ?>">Addresses</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('bank_detail')); ?>">Bank Information</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('user_subscribe')); ?>">My Subscriptions</a>
                                    <a class="dropdown-item  " href="<?php echo e(route('user_orders')); ?>">Orders</a>
                                    <?php if(auth()->user()->user_type != 1): ?>
                                        <a class="dropdown-item  " href="<?php echo e(route('become.vendor')); ?>">Start Selling</a>
                                    <?php endif; ?>

                                <?php endif; ?>
                                <a class="dropdown-item " href="<?php echo e(route('logout')); ?>">Logout</a>
                            </div>
                        </li>

                        <?php if(auth()->user()->user_type==1): ?>
                            <li class="nav-item <?php echo request()->route()->getName() == 'start_selling_home' ? 'active': ''; ?>">
                                <a class="nav-link" href="<?php echo e(route('sale_your_product')); ?>">Sell</a>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <li class="nav-item <?php echo request()->route()->getName() == 'start_selling_home' ? 'active': ''; ?>">
                            <a class="nav-link" href="<?php echo e(route('start_selling_home')); ?>">Start Selling</a>
                        </li>

                        <?php if(isset(auth::user()->id)): ?>


                            <li class="nav-item ">
                                <a class="nav-link"  href="<?php echo e(route('login.login')); ?>">Dashboard</a>
                            </li>

                        <?php endif; ?>
                        <li class="nav-item <?php echo request()->route()->getName() == 'login.login' ? 'active': ''; ?>">
                            <a class="nav-link" href="<?php echo e(route('login.login')); ?>">Sign In</a>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>
            <ul class="navbar-nav action-list">
                <li class="nav-item nav-search">
                    <a class="nav-link"    href="#" data-toggle="modal" data-target="#search-popup1"><i
                            class="uil uil-search" ></i></a>
                </li>
                <li class="nav-item nav-button wishlist-btn">
                    <a class="nav-link"  href="<?php echo e(route('wishlist')); ?>"><i class="uil uil-heart"></i>
                        <?php
                        if(auth()->check()){
                        $wishlist = App\Models\Wishlist::where('user_id',auth()->user()->id)->get();
                        ?>
                        <span class="badge wish"><?php echo count($wishlist);?></span>
                        <?php
                        }
                        ?>


                    </a>

                </li>
                <li class="nav-item nav-button cart-btn">
                    <a class="nav-link" href="#"><i class="uil uil-shopping-cart-alt"></i><span
                            class="badge"><?php if(isset($cart_data[0])): ?> <?php echo e(count($cart_data ?? 0)); ?> <?php else: ?> 0 <?php endif; ?></span></a>
                </li>
            </ul>
            <a href="#" class="btn mob-sidebar-trigger"><i class="fas fa-ellipsis-v"></i></a>
        </nav>


        <div class="modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"
             id="search-popup1">
            <div class="modal-dialog  modal-dialog-centered" role="document">
                <div class="modal-content" >
                    <div class="modal-body">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <div class="search-wrapper">
                            <div class="form-group m-0">
                                <div class="input-group">
                                    <input type="text" class="form-control sea" onkeypress="handleKeyPress1(event)" placeholder="Search.." >
                                    <div class="input-group-append">

                                        <span class="input-group-text ut-a" ><i
                                                class="uil uil-search"></i></span>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Banner code was here-->

</header>

<?php $news_ticker = App\Models\NewsTicker::where('flags', 1)->first(); ?>
<?php if(Route::currentRouteName() == "home" && $news_ticker): ?>
    <div class="message-bar" style="background: <?php echo e($news_ticker->bg_color); ?>; color: <?php echo e($news_ticker->text_color); ?>">
        <marquee onmouseover="this.stop();" onmouseout="this.start();">
            <strong><?php echo e($news_ticker->title); ?></strong>&nbsp;<?php echo e(trim($news_ticker->content)); ?>

        </marquee>
    </div>
<?php endif; ?>

<aside class="mobile-nav">
    <div class="heading">
        <h5>Navigations</h5>
        <a href="javascript:void(0)" class="btn close-mobile-nav"><i class="uil uil-times"></i></a>
    </div>
    <div class="nav-list">
        <ul class="main-list">
            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>

            <li>
                <a data-toggle="collapse" href="#shopMainCollapse" class="icon-wrapper"><i class="fas fa-chevron-down"></i> Shop </a>

                <div class="collapse" id="shopMainCollapse">
                    <ul class="inner-list">
                        <li>
                            <?php $parent_categories = App\Models\ShopCategory::whereRaw("flags & ? = ?", [App\Models\ShopCategory::FLAG_ACTIVE, App\Models\ShopCategory::FLAG_ACTIVE])->where('parent_id',0)->get()->toArray();
                            foreach ($parent_categories as $key => $parent_category) { ?>

                            <?php $child_cats = App\Models\ShopCategory::whereRaw("flags & ? = ?", [App\Models\ShopCategory::FLAG_ACTIVE, App\Models\ShopCategory::FLAG_ACTIVE])->where('parent_id',$parent_category['id'])->get()->toArray(); ?>
                            <?php if(count($child_cats)>0){ ?>
                            <a data-toggle="collapse" href="#<?php echo $parent_category['shop_cat_name'];?>"
                               class="icon-wrapper"><i class="fas fa-chevron-down"></i>
                                <?php echo $parent_category['shop_cat_name'];?></a>
                                <div class="collapse" id="<?php echo $parent_category['shop_cat_name'];?>">
                                    <ul class="inner-list">
                                        <?php foreach ($child_cats as $key => $child_cat) { ?>
                                        <li><a href="<?php echo e(route('product.category',['slug'=>$child_cat['shop_cat_slug']])); ?>"><?php echo $child_cat['shop_cat_name'];?></a></li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php } ?>
                            <?php } ?>
                        </li>
                        <li>
                            <a data-toggle="collapse" href="#brands" class="icon-wrapper"><i
                                    class="fas fa-chevron-down"></i> Brands</a>
                            <div class="collapse" id="brands">
                                <ul class="inner-list">
                                    <?php $brands = App\Models\Brand::whereRaw("flags & ? = ?", [App\Models\Brand::FLAG_ACTIVE, App\Models\Brand::FLAG_ACTIVE])->get()->toArray();
                                    foreach ($brands as $key => $brand) {
                                    ?>
                                    <li> <a href="#" class="dropdown-item"><?php echo $brand['brand_name']; ?></a></li>
                                    <?php }?>
                                </ul>
                            </div>
                        </li>

                    </ul>
                </div>
            </li>
            <li><a href="<?php echo e(route('coming_soon')); ?>">News</a></li>

            <li>
                <a data-toggle="collapse" href="#dashboardCollapse" class="icon-wrapper"><i
                        class="fas fa-chevron-down"></i> Dashboard </a>
                <div class="collapse" id="dashboardCollapse">
                    <ul class="inner-list">
                        <li> <a class="  <?php echo request()->route()->getName() == 'update_account' ? 'active': ''; ?>"
                                href="<?php echo e(route('update_account')); ?>">Account details</a></li>
                        <li><a class="  <?php echo request()->route()->getName() == 'edit_address' ? 'active': ''; ?>"
                               href="<?php echo e(route('edit_address')); ?>">Addresses</a></li>
                        <li><a class="  <?php echo request()->route()->getName() == 'shop_products' ? 'active': ''; ?>"
                               href="bank-information.html">Bank Information</a></li>
                        <li><a class="  <?php echo request()->route()->getName() == 'shop_products' ? 'active': ''; ?>"
                               href="subscriptions.html">My Subscriptions</a></li>
                        <li><a class="  <?php echo request()->route()->getName() == 'user_orders' ? 'active': ''; ?>"
                               href="<?php echo e(route('user_orders')); ?>">Orders</a></li>
                        <li><a class="  <?php echo request()->route()->getName() == 'become.vendor' ? 'active': ''; ?>"
                               href="<?php echo e(route('become.vendor')); ?>">Start Selling</a></li>
                        <li class="nav-item <?php echo request()->route()->getName() == 'login.login' ? 'active': ''; ?>">
                            <a class="nav-link" href="<?php echo e(route('login.login')); ?>">Sign In</a>
                        </li>
                        <li><a class="" href="<?php echo e(route('logout')); ?>">Logout</a></li>

                    </ul>
                </div>
            </li>
        </ul>
    </div>
</aside>

<aside class="sidebar-cart">
    <div class="heading">
        <h5>Shopping Bag <span class="badge"><?php if(isset($cart_data[0])): ?> <?php echo e(count($cart_data ?? 0)); ?> <?php else: ?> 0 <?php endif; ?></span></h5>
        <a href="javascript:void(0)" class="btn close-sidebar-cart"><i class="uil uil-times"></i></a>
    </div>


    
    <div class="empty-cart">
        <?php if(isset($cart_data) && count($cart_data)==0){?>
        <img src="<?php echo e(asset('assets/images/empty-cart.png')); ?>" class="img-fluid">
        <h6>no products in the cart</h6>
        <?php }?>
    </div>

    <?php $sub_total = 0; $delivery_charges = 0; $ship = 0; ?>

    <div class="cart-items-wrapper">
        <?php if(isset($cart_data[0])): ?>
            <?php $__currentLoopData = $cart_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if((float)$carts->sale_price > 0): ?>
                    <?php $sub_total = $sub_total + $carts->sale_price * (int)$carts->quantity ;
                    $ship = $ship + $carts->ship; ?>
                <?php elseif((float)$carts->sale_price_sizes > 0): ?>
                    <?php $sub_total= $sub_total + $carts->sale_price_sizes * (int)$carts->quantity; ?>
                <?php else: ?>
                    <?php $sub_total= $sub_total + $carts->regular_price * (int)$carts->quantity; ?>
                <?php endif; ?>

                <?php  $delivery_charges = $delivery_charges + (int)$carts->delivery_charges;  ?>

                <div class="cart-item">
                    <div class="img-box">

                        <?php  $p = ""; ?>
                        <?php if($carts->parent_id>0): ?>
                            <a href="#"><img src="<?php echo e(url('/').'/storage/seller-product/'.$carts->product_id.'/'.$carts->feature_image); ?>" height="10px" width="90px" class="img-fluid"></a>
                            <?php $p=\App\Models\Product::where("id",$carts->parent_id)->first(); ?>
                        <?php else: ?>
                            <a href="#"><img src="<?php echo e(url('/').'/storage/product/'.$carts->product_id.'/'.$carts->feature_image); ?>" height="10px" width="90px" class="img-fluid"></a>
                        <?php endif; ?>
                    </div>

                    <div class="details">
                        <h6 class="product-title"><?php echo e($carts->product_name ?? $p->product_name); ?></h6>

                        <span class="price-heading">
                               <b>
                                   <span class="quantity"><?php echo e($carts->quantity); ?></span> x
                                   <span class="price">
                                       <?php if((float)$carts->sale_price > 0): ?>
                                           £<?php echo e(number_format($carts->sale_price, 2) ?? ""); ?>

                                       <?php elseif((float)$carts->sale_price_sizes > 0): ?>
                                           £<?php echo e(number_format($carts->sale_price_sizes, 2) ?? ""); ?>

                                       <?php else: ?>
                                           £<?php echo e(number_format($carts->regular_price, 2) ?? ""); ?>

                                       <?php endif; ?>
                                   </span>
                               </b>
                           </span>

                        <br>

                        <span class="price-heading">
                            <b><span class="quantity">Size :</span> </b>

                            <?php if($carts->parent_id > 0): ?>
                                <span class="price-heading">
                                        <span class="quantity"><?php echo e($carts->size ?? ""); ?></span>
                                </span>
                            <?php else: ?>
                                <?php $p = \App\Models\Size::where("id", $carts->size_id)->first(); ?>

                                <span class="price-heading">
                                        <b><span class="quantity"><?php echo e($p->size ?? ""); ?></span> </b>
                                </span>
                            <?php endif; ?>
                         </span>
                    </div>

                    <a href="javascript:void(0)" data-cart_id="<?php echo e($carts->id); ?>" class="btn cancel-btn remove_cart_item"><i class="uil uil-times"></i></a>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>
    </div>

    <?php if(isset($cart_data[0])): ?>
        <div class="cart-footer">
            <div class="price">
                <h5>Delivery Charges :</h5>
                <h5 class="total-price">£<?php echo e($ship ??""); ?></h5>
            </div>

            <div class="price">
                <h5>subtotal :</h5>
                <h5 class="total-price">£<?php echo e(number_format($sub_total,2) ?? ""); ?></h5>
            </div>

            <div class="price">
                <h5>Total :</h5>
                <h5 class="total-price">£<?php echo e(number_format($sub_total+ $ship,2) ?? ""); ?></h5>
            </div>

            <a href="<?php echo e(route('checkout')); ?>" class="btn checkout-btn">checkout</a>

        </div>
    <?php endif; ?>
</aside>


<script>

    function handleKeyPress(e)
    {
        var key=e.keyCode || e.which;
        if (key==13)
        {
            var search = $("#search").val();
            var url='<?php echo e(route("search_title")); ?>'+'?sort=default&&search='+search;
            window.location=url;
        }
    }

    function handleKeyPress1(e)
    {
        var key=e.keyCode || e.which;
        if (key==13)
        {
            const sea=$(".sea").val();
            var url='<?php echo e(route("search_title")); ?>'+'?sort=default&&search='+sea;
            window.location=url;
        }
    }

    $(document).ready(function(){

        $('.home-first').click(function(){

            var search = $("#search").val();
            var url='<?php echo e(route("search_title")); ?>'+'?sort=default&&search='+search;
            window.location=url;

        });

        $(".ut-a").click(function(){

            const sea=$(".sea").val();
            var url='<?php echo e(route("search_title")); ?>'+'?sort=default&&search='+sea;
            window.location=url;

        });
    });






    // var input = document.getElementById("search");

    // // Execute a function when the user presses a key on the keyboard
    // input.addEventListener("keypress", function(event) {
    //   // If the user presses the "Enter" key on the keyboard
    //   if (event.key === "Enter") {

    //     alert('Ana');
    //         var search = $("#search").val();
    //         var url='<?php echo e(route("search_title")); ?>'+'?sort=default&&search='+search;
    //         window.location=url;


    //     // event.preventDefault();
    //     // // Trigger the button element with a click
    //     // document.getElementById("myBtn").click();
    //   }
    // });


    // $(".search_result_all1").change(function(){
    //     var val= $(".search_result_all1").val();
    //     $(".search_result_all2").val(val);
    //     $(".search_result_all3").val(val);
    // });
    // $(".search_result_all2").change(function(){
    // var val= $(".search_result_all2").val();
    // $(".search_result_all1").val(val);
    // $(".search_result_all3").val(val);
    // });
    // $(".search_result_all3").change(function(){
    // var val= $(".search_result_all3").val();
    // $(".search_result_all1").val(val);
    // $(".search_result_all2").val(val);
    // });





</script>
<?php /**PATH /home/x6s7iygrqu6j/public_html/resources/views/frontend/header.blade.php ENDPATH**/ ?>