<?php $__env->startSection('title'); ?>
    <?php echo e($product->product_name); ?> - The Marketplace
<?php $__env->stopSection(); ?>
<?php $__env->startSection('banner'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php
    $recent_products = Cookie::get('recentViews');
    $user_id = 0;
    if ($recent_products) {

        $recent_products .= ','. $product->id;
        Cookie::queue('recentViews', $recent_products, 86400);

    } else {

        Cookie::queue('recentViews', $product->id, 86400);
        $recent_products = $product->id;
    }

    $recent_prod_array = array_unique(explode(",", $recent_products));
    $recent_view_products = \App\Models\Product::whereIn('id', $recent_prod_array)->get();
    $current_url = URL::current();
    $reviews = 0;

    if (auth()->user()) {
        $user_id = auth()->user()->id;
    }

    ?>

    <main class="product-page product-page-new pb-0">

        <div class="container pt-5">

            <div class="single-product">
                <div class="column column-img">
                    <?php if(count($product->multi_images)>0): ?>
                        <div class="owl-carousel owl-theme single-img-slider">
                            <div class="item">
                                <div class="img-wrapper" >
                                    <img src="<?php echo e($product->image_url); ?>" class="img-fluid">
                                </div>
                            </div>
                            <?php if(isset($product->multi_images)): ?>
                                <?php $__currentLoopData = $product->multi_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $multi_images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="item">
                                        <div class="img-wrapper" >
                                            <img src="<?php echo e($multi_images->image_multi_url); ?>" class="img-fluid">
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>


                    <?php else: ?>
                        <div class="owl-carousel owl-theme single-img-slider" style="display: block;">
                            <div class="item">
                                <div class="img-wrapper" style="width: 80%;margin: auto;">
                                    <img src="<?php echo e($product->image_url); ?>" class="img-fluid">
                                </div>
                            </div>
                        </div>


                    <?php endif; ?>
                </div>
                <div class="column column-details">
                    <div class="inner-wrapper">
                        <h3 class="product-title"><?php echo e($product->product_name); ?></h3>
                        <div class="product-price">
                            

                            <?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
                                <h3 class="real-price" >£<?php echo e(number_format($product->sale_price,2)); ?></h3>
                                <h3 class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></h3>
                            <?php else: ?>

                                <h3 class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></h3>

                            <?php endif; ?>

                        </div>
                        <div class="product-slider-wrapper">
                            <div class="owl-carousel owl-theme product-pills-slider">
                                <?php $__currentLoopData = $product->prod_size; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sizes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="item" <?php if($sizes->size->size == "One Size"): ?> style="margin-left:207%;"  <?php endif; ?> >
                                        <div class="item-wrapper">
                                            <button onclick="wishlist(<?php echo e($sizes->product_id); ?>, <?php echo e($sizes->size->id); ?>);" class="pills-link-admin pills-link <?php echo ($sizes->quantity > 0 ? '' : 'quantity-disabled' );?>" <?php echo ($sizes->quantity > 0 ? '' : 'disabled' );?> data-size_id = '<?php echo e($sizes->size->id); ?>' data-variation_id = '<?php echo e($sizes->id); ?>' data-toggle="pill" type="button">
                                                <?php echo e($sizes->size->size); ?>

                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <form action="">
                            <h4 class="size-guide"><a type="button"  data-toggle="modal" data-target="#sizeGuide_Modal">View Size Guide</a></h4>
                            <div class="product-quantity">
                                <div class="quantity">
                                    <input type="number" id="number" value="1" readonly/>
                                    <div class="button-wrapper">
                                        <div class="value-button" id="increase" onclick="increaseValue()"
                                             value="Increase Value">+</div>
                                        <div class="value-button" id="decrease" onclick="decreaseValue()"
                                             value="Decrease Value">-</div>
                                    </div>
                                </div>
                                <input type="hidden" name="product_id" id = "product_id" value = "<?php echo e($product->id); ?>">
                                <button class="btn add-to-cart-button" id = "addToCart" disabled style="background:grey;" type="button" >Add to Cart</button>
                            </div>
                        </form>

                        <div class="action-buttons">
                            <a style="color: rgb(173, 173, 173);" type="button" class="btn Add-to-Wishlist" style="color:red;" id = "addWishlist"><i class="fa fa-heart"></i> Add to Wishlist</a>
                            <a type="button" class="btn Add-to-Wishlist" style="color:red;" id = "addWishlist"></a>
                            <a href="#" class="btn"><i class="fas fa-sync-alt"></i> Compare</a>
                        </div>

                    </div>


                </div>
            </div>

            <div style="display:none" class="product-layout">

                <div class="column images-column column-img">
                    <div class="owl-carousel owl-theme single-img-slider">
                        <div class="item">
                            <div class="img-wrapper">
                                <img src="<?php echo e($product->image_url); ?>" class="img-fluid">
                            </div>
                        </div>
                        <?php if(isset($product->multi_images)): ?>
                            <?php $__currentLoopData = $product->multi_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $multi_images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item">
                                    <div class="img-wrapper">
                                        <img src="<?php echo e($multi_images->image_multi_url); ?>" class="img-fluid">
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                <!--
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Brand</a></li>
                        <li class="breadcrumb-item"><a href="#">Sub Brand</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($product->product_name); ?></li>
                        </ol>
                    </nav> -->
                </div>
                <div class="column product-details-column">
                    <a href="javascript:void(0)" class="cross-times">
                        &times;
                    </a>
                    <div class="heading-area">
                        <h3 class="product-title" style="font-weight: 600;"><?php echo e($product->product_name); ?></h3>
                    </div>

                    <ul class="nav nav-pills nav-pills-product" id="pills-products" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="new-product" data-toggle="pill" href="#pills-new-product">New</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " id="used-product" data-toggle="pill" href="#pills-used-product">Used</a>
                        </li>
                    </ul>
                    <div class="tab-content product-pills-content" style="text-align:center;">
                        <div class="tab-pane fade  show active" id="pills-new-product">

                            <div class="product-size-wrapper">
                                <div class="inner product-sizes product-slider-wrapper" id="product-sizes">
                                    <div class="owl-carousel owl-theme product-pills-slider">


                                        <?php $array = array();?>
                                        <?php $__currentLoopData = $new_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sizes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                            if(! empty($sizes['product_size']) ) {
                                                foreach($sizes['product_size'] as $product_size_new) {
                                                    if( !empty($product_size_new['products']) ) {
                                                        array_push($array, $product_size_new['sale_price']);
                                                    }
                                                }

                                            }
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $min=0;
                                            if(count($array) > 0 ){
                                                $min = min($array);
                                            }
                                        ?>

                                        <?php $__currentLoopData = $new_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $sizes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="item"   <?php if( isset($sizes['size']) && $sizes['size']=="One Size" ): ?>  style="width:0% !important; margin-left:207%;" <?php endif; ?>>

                                                <button  class="pills-general pills-link-new-product pills-link
                                                     <?php if(isset($sizes['product_size']) && $sizes['product_size'] != NULL) {
                                                                foreach ($sizes['product_size'] as $product_size) {
                                                                    if(isset($product_size['products']) && $product_size['products'] != NULL) {
                                                                        if($product_size['sale_price'] == $min) {
                                                                            echo 'active';
                                                                            break;
                                                                        }
                                                                    } else {

                                                                        if(isset($sizes["product_size"][0])  || isset($sizes["product_size"][1])  )
                                                                        {
                                                                            //echo $product_size['sale_price'];
                                                                        }
                                                                        else
                                                                        {
                                                                            echo 'quantity-disabled';
                                                                        }
                                                                    }
                                                                }
                                                     }else {
                                                        echo 'quantity-disabled';
                                                     }
                                                     ?>




                                                    " data-product_id = "<?php echo e($product->id); ?>" data-size_id="<?php echo e($sizes['id']); ?>" data-flags='1'  data-toggle="pill" type="button"  >

                                                    <?php echo e($sizes['size']); ?>


                                                    <?php if($sizes['product_size']): ?>

                                                        <?php if(isset($sizes['product_size'][0]["products"])): ?>

                                                            <span class="pill-price">£<?php echo e(number_format($sizes['product_size'][0]['sale_price'],2)); ?> </span>

                                                        <?php endif; ?>

                                                        <?php if(isset($sizes['product_size'][1]['sale_price'])): ?>
                                                            <span class="pill-price">£<?php echo e(number_format($sizes['product_size'][1]['sale_price'],2)); ?>

                                                                <?php else: ?>  <span class="pill-price"><?php if(isset($sizes['product_size'][2]['sale_price'])): ?>  <?php echo e(number_format($sizes['product_size'][2]['sale_price'],2)); ?> <?php endif; ?>

                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </button>
                                            </div>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </div>
                                </div>

                                <!-- <button class="btn p-size-btn-left" id="p-size-btn-left"><i class="uil uil-arrow-left"></i></button>
                                <button class="btn p-size-btn-right" id="p-size-btn-right"><i class="uil uil-arrow-right"></i></button>  -->
                            </div>

                            <div class="pro_upper_box" style="margin-top: -18px;"></div>

                            <div class="tab-content product-size-content">
                                <div class="tab-pane fade show active" id="product-size-1">
                                    <ul>

                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="pills-used-product">
                            <div class="product-size-wrapper">
                                <div class="inner product-sizes product-slider-wrapper" id="used-product-sizes">
                                    <div class="owl-carousel owl-theme product-pills-slider">
                                        <?php $array1 = array();?>


                                        <?php $__currentLoopData = $used_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$sizes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php
                                            if(! empty($sizes['product_size']) ) {
                                                foreach($sizes['product_size'] as $product_size_new) {
                                                    if( !empty($product_size_new['products']) ) {
                                                        array_push($array1, $product_size_new['sale_price']);
                                                    }
                                                }
                                            }
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php
                                        $min1=0;
                                        if(count($array1) > 0 ){
                                            $min1 = min($array1);
                                        }
                                        ?>

                                        <?php $__currentLoopData = $used_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $used_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="item" <?php if(isset($used_product['size']) && $used_product['size']=="One Size"): ?> style="width:0%;margin-left:207%;"  <?php endif; ?>>
                                                <div class="item-wrapper">

                                                    <button class="pills-general pills-link-used-product pills-link
                                                    <?php
                                                    if(isset($used_product['product_size']) && $used_product['product_size'] != NULL) {


                                                        if( !empty($used_product['product_size'])){
                                                            $temperory=0;
                                                            foreach ($used_product['product_size'] as $product_size) {
                                                                if(isset($product_size['products']) && $product_size['products'] != NULL && (int)$product_size['sale_price'] > 0) {

                                                                    $temperory= $temperory+1;
                                                                }

                                                            }
                                                            if($temperory==0)
                                                            {
                                                                echo 'quantity-disabled';
                                                            }
                                                        }

                                                    } else {
                                                        echo 'quantity-disabled';
                                                    }

                                                    ?>"  data-product_id = "<?php echo e($product->id); ?>" data-size_id="<?php echo e($used_product['id']); ?>" data-flags='2'  data-toggle="pill" type="button">
                                                        <?php echo e($used_product['size']); ?>


                                                        <?php
                                                        if( !empty($used_product['product_size'])){
                                                        foreach ($used_product['product_size'] as $product_size) {
                                                        if(isset($product_size['products']) && $product_size['products'] != NULL) {

                                                        ?>
                                                        <span class="pill-price">£<?php echo e(number_format($product_size['sale_price'],2)); ?></span>
                                                        <?php
                                                        break;
                                                        }
                                                        }
                                                        }
                                                        ?>
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div style="margin-top:-11px;"></div>
                                <div class="pro_upper_box" style="padding: 0px 0;border: 0px;" >
                                </div>


                                <!-- <button class="btn p-size-btn-left" id="used-size-btn-left"><i class="uil uil-arrow-left"></i></button>
                                <button class="btn p-size-btn-right" id="used-size-btn-left"><i class="uil uil-arrow-right"></i></button> -->
                            </div>


                            <div class="pro_upper_box"  style="margin-top: -32px;" ></div>

                            <div class="tab-content used-product-size-content">
                                <div class="tab-pane fade show active" id="used-product-size-1">
                                    
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="sizeGuide_Modal" tabindex="-1" role="dialog" aria-labelledby="sizeGuide_ModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="sizeGuide_ModalLabel">Size Guide</h5>
                            <button id = "close_button_model" type="button" class="close"  data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div id="accordionlvl1">
                                <div class="card">
                                    <div class="card-header">
                                        <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#lvl1_collapseOne"
                                                aria-expanded="false" aria-controls="lvl1_collapseOne">
                                            Men
                                        </button>
                                    </div>
                                    <div id="lvl1_collapseOne" class="collapse" data-parent="#accordionlvl1">
                                        <div class="card-body">
                                            <div id="menAcc">
                                                <div class="card">
                                                    <div class="card-header" id="headingOne">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#menAcc_collapseOne" aria-expanded="false" aria-controls="menAcc_collapseOne">
                                                            Clothing
                                                        </button>

                                                    </div>
                                                    <div id="menAcc_collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#menAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="headingTwo">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#menAcc_collapseTwo" aria-expanded="false" aria-controls="menAcc_collapseTwo">
                                                            Footwear
                                                        </button>

                                                    </div>
                                                    <div id="menAcc_collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#menAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="headingThree">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#menAcc_collapseThree" aria-expanded="false"
                                                                aria-controls="menAcc_collapseThree">
                                                            Accessories

                                                        </button>
                                                    </div>
                                                    <div id="menAcc_collapseThree" class="collapse" aria-labelledby="headingThree"
                                                         data-parent="#menAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header">

                                        <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#lvl1_collapsetwo"
                                                aria-expanded="false" aria-controls="lvl1_collapsetwo">
                                            Women
                                        </button>

                                    </div>
                                    <div id="lvl1_collapsetwo" class="collapse" data-parent="#accordionlvl1">
                                        <div class="card-body">
                                            <div id="womenAcc">
                                                <div class="card">
                                                    <div class="card-header" id="headingOne">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#womenAcc_collapseOne" aria-expanded="false" aria-controls="womenAcc_collapseOne">
                                                            Clothing
                                                        </button>

                                                    </div>
                                                    <div id="womenAcc_collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#womenAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="headingTwo">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#womenAcc_collapseTwo" aria-expanded="false" aria-controls="womenAcc_collapseTwo">
                                                            Footwear
                                                        </button>

                                                    </div>
                                                    <div id="womenAcc_collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#womenAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="headingThree">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#womenAcc_collapseThree" aria-expanded="false"
                                                                aria-controls="womenAcc_collapseThree">
                                                            Accessories

                                                        </button>
                                                    </div>
                                                    <div id="womenAcc_collapseThree" class="collapse" aria-labelledby="headingThree"
                                                         data-parent="#womenAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header">

                                        <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#lvl1_collapseThree"
                                                aria-expanded="false" aria-controls="lvl1_collapseThree">
                                            Junior
                                        </button>

                                    </div>
                                    <div id="lvl1_collapseThree" class="collapse" aria-labelle data-parent="#accordionlvl1">
                                        <div class="card-body">
                                            <div id="juniorAcc">
                                                <div class="card">
                                                    <div class="card-header" id="headingOne">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#juniorAcc_collapseOne" aria-expanded="false"
                                                                aria-controls="juniorAcc_collapseOne">
                                                            Clothing

                                                        </button>
                                                    </div>
                                                    <div id="juniorAcc_collapseOne" class="collapse" aria-labelledby="headingOne"
                                                         data-parent="#juniorAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="headingTwo">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#juniorAcc_collapseTwo" aria-expanded="false"
                                                                aria-controls="juniorAcc_collapseTwo">
                                                            Footwear

                                                        </button>
                                                    </div>
                                                    <div id="juniorAcc_collapseTwo" class="collapse" aria-labelledby="headingTwo"
                                                         data-parent="#juniorAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header">

                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#juniorAcc_collapseThree" aria-expanded="false"
                                                                aria-controls="juniorAcc_collapseThree">
                                                            Accessories

                                                        </button>
                                                    </div>
                                                    <div id="juniorAcc_collapseThree" class="collapse" data-parent="#juniorAcc">
                                                        <div class="card-body">
                                                            <div class="table-responsive">
                                                                <table class="table table-striped">
                                                                    <thead>
                                                                    <tr>
                                                                        <th>UK</th>
                                                                        <th>CHEST</th>
                                                                        <th>WAIST</th>
                                                                        <th>HIP</th>
                                                                    </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    <tr>
                                                                        <td>XS</td>
                                                                        <td>31-33"</td>
                                                                        <td>27-29"</td>
                                                                        <td>32-34"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>S</td>
                                                                        <td>34-37"</td>
                                                                        <td>30-32"</td>
                                                                        <td>35-37"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>M</td>
                                                                        <td>37-40"</td>
                                                                        <td>32-35"</td>
                                                                        <td>37-40"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>L</td>
                                                                        <td>40-44"</td>
                                                                        <td>35-39"</td>
                                                                        <td>40-44"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>XL</td>
                                                                        <td>44-48"</td>
                                                                        <td>39-43"</td>
                                                                        <td>44-48"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>2XL</td>
                                                                        <td>48-52"</td>
                                                                        <td>43-47"</td>
                                                                        <td>48-51"</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>3XL</td>
                                                                        <td>43-58"</td>
                                                                        <td>48-53"</td>
                                                                        <td>51-56"</td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="social">
                <p class="mr-3">Share</p>
                <p>
                    <?php $site_url = route('single-product', ['id' => $product->id]);?>
                    <a href="http://www.facebook.com/sharer.php?u=<?=$site_url;?>"><i class="fab fa-facebook-f"></i></a>
                    <a href="mailto:?Subject=The Marketpalce&amp;Body=I%20saw%20this%20and%20thought%20of%20you!%20 <?=$site_url;?>"><i class="fas fa-envelope"></i></a>
                    <a href="https://twitter.com/share?url=<?=$site_url?>&amp;text=Simple%20Share%20Buttons&amp;hashtags=simplesharebuttons" target="_blank"><i class="fab fa-twitter"></i></a>
                    <a href="javascript:void((function()%7Bvar%20e=document.createElement('script');e.setAttribute('type','text/javascript');e.setAttribute('charset','UTF-8');e.setAttribute('src','http://assets.pinterest.com/js/pinmarklet.js?r='+Math.random()*99999999);document.body.appendChild(e)%7D)());"><i class="fab fa-pinterest"></i></a>
                </p>
            </div>

            <div class="product-info">

                <div class="">

                    <p><span>Category:</span>
                        <a href="<?php echo e(route('product.category',['slug'=>$product->shop_category->shop_cat_slug])); ?>">
                            <?php echo e($product->shop_category->shop_cat_name); ?></a>
                    </p>
                </div>

                <div class="">

                    <p><span>Brand:</span>
                        <a href="<?php echo e(route('product.category',['slug'=>$product->shop_category->shop_cat_slug])); ?>">
                            <?php echo e($product->getBrand->brand_name); ?></a>
                    </p>

                </div>

                <div class="sold_by">
                    <p><span>Sold By: </span><a href="#">The Marketplace</a></p>
                </div>
                <div class="">
                    <p><span>SKU: </span> <?php if(is_null($product->sku)) echo ''; else echo $product->sku;?> </p>
                </div>
            </div>

            <div class="product-description">
                <h6>Product Description</h6>
                <p><?php echo $product->product_description; ?></p>
            </div>

            <div class="related-products">
                <h5 class="heading-5">Related Products</h5>
                <?php if(!$related_products->isEmpty()): ?>
                    <div class="owl-carousel owl-theme product-slider" id="slider-men-new">
                        <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="card product-card">
                                <div class="card-header">
                                    <a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
                                        <div class="img-box">
                                            <img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
                                        </div>
                                        <div class="tags">
                                            <?php if((int)$product->discount>0): ?>
                                                <span class="discount-tag">  -<?php echo e($product->discount); ?>% </span>
                                            <?php endif; ?>
                                            <span class="new-tag">New</span>
                                        </div>

                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="product-category">

                                        
                                        <a href=""></a>
                                    </div>
                                    <a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>"
                                       class="product-title"><?php echo e($product->product_name); ?></a>
                                    <?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
                                        <span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
                                        <span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
                                    <?php else: ?>

                                        <span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

                                    <?php endif; ?>


                                </div>
                            </div>


                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
            </div>

            <div class="recently-viewed-products">
                        <div class="container">
                            <h5 class="heading-5">recently viewed products</h5>

                            <div class="owl-carousel owl-theme product-slider" id="slider-men-new">
                                <?php $__currentLoopData = $recent_view_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <div class="card product-card">
                                        <div class="card-header">
                                            <a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>" class="d-block">
                                                <div class="img-box">
                                                    <img data-src="<?php echo e($product->image_url); ?>" class="img-fluid lazy ">
                                                </div>
                                                <div class="tags">
                                                    <?php if((int)$product->discount>0): ?>
                                                        <span class="discount-tag">  -<?php echo e($product->discount); ?>% </span>
                                                    <?php endif; ?>
                                                    <span class="new-tag">New</span>
                                                </div>

                                            </a>
                                        </div>
                                        <div class="card-body">
                                            <div class="product-category">

                                                
                                                <a href="">
                                                </a>
                                            </div>
                                            <a href="<?php echo e(route('single-product', ['id' => $product->id])); ?>"
                                               class="product-title"><?php echo e($product->product_name); ?></a>
                                            <?php if((int)$product->sale_price > 0 && (int)$product->regular_price > $product->sale_price): ?>
                                                <span class="discounted-price">£<?php echo e(number_format($product->sale_price,2)); ?></span>
                                                <span class="real-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>
                                            <?php else: ?>

                                                <span class="discounted-price">£<?php echo e(number_format($product->regular_price,2)); ?></span>

                                            <?php endif; ?>


                                        </div>
                                    </div>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>

                            <div class="alert alert-dismissible fade" role="alert" style="text-align:center;">
                                <button id="error_model" type="button" class="close buttonAlert" data-dismiss="alert" aria-label="Close" onclick="closeup();">
                                    <i class="uil uil-multiply"></i>
                                </button>
                                <p style="display: contents;"></p>
                            </div>


                            <div class="alert alert-dismissible1 fade" role="alert" style="text-align:center;">
                                <button id="error_model" type="button" class="close buttonAlert" data-dismiss="alert" aria-label="Close" onclick="closeup();">
                                    <i class="uil uil-multiply"></i>
                                </button>
                                <p style="display: contents;"></p>
                            </div>
                        </div>
            </div>

        </div>

    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-css'); ?>
    <div class="fixed-buttons">
        <a href="#header" class="btn white-btn go-top"><i class="fas fa-caret-up"></i></a>

        <a href="javascript:void(0)" class="btn blue-btn buy_used"
           style="border-left: 1px solid #25252d;">buy used</a>
        <a href="javascript:void(0)" class="btn blue-btn buy_new">buy
            new</a>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

    <script>
        $(document).ready(function () {

            let cancel = <?php echo e($cancel); ?>;

            if (cancel == 1) {
                $(".sold_by").hide();
                $('.single-product').hide();
                $('.product-layout').show();
                $('.product-details-column').addClass('column-details-fixed');
                $('#new-product').removeClass('active');
                $('#used-product').addClass('active');
                $('#pills-new-product').removeClass('show active');
                $('#pills-used-product').addClass('show active');
                $('#pills-used-product.product-pills-slider').owlCarousel('refresh');
            }

            if ($('.pills-general').hasClass('active') == true) {

                let size_id = $('.pills-general.active').attr('data-size_id');
                let product_id = $('.pills-general.active').attr('data-product_id');
                let flags = $('.pills-general.active').attr('data-flags');
                $.ajax({
                    url: "<?php echo e(route('ProductNew')); ?>",
                    method: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        product_id: product_id,
                        size_id: size_id,
                        flags: flags,
                    },
                    success: function (result) {


                        $('.product-sizes').owlCarousel(
                            {items: 5,}
                        );

                        $('#product-size-1').html(result);


                    }
                });
            }

            if ($('.pills-link-used-product').hasClass('active') == true) {

                let size_id = $('.pills-link-used-product.active').attr('data-size_id');
                let product_id = $('.pills-link-used-product.active').attr('data-product_id');
                let flags = $('.pills-link-used-product.active').attr('data-flags');

                $.ajax({
                    url: "<?php echo e(route('ProductNew')); ?>",
                    method: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        product_id: product_id,
                        size_id: size_id,
                        flags: flags,
                    },
                    success: function (result) {


                        $('#used-product-size-1').html(result);

                    }
                });
            }

            $('#close_button_model').click(function () {
                $('#sizeGuide_Modal').modal('hide');
            });

            $('.buy_new').on('click', function (e) {
                $(".sold_by").hide();
                $('.single-product').hide();
                $('.product-layout').show();
                $('.product-details-column').addClass('column-details-fixed');
                $('#new-product').addClass('active');
                $('#used-product').removeClass('active');
                $('#pills-new-product').addClass('show active');
                $('#pills-used-product').removeClass('show active');
                $('#pills-new-product.product-pills-slider').owlCarousel('refresh');


            });

            $('.buy_used').on('click', function (e) {
                $(".sold_by").hide();
                $('.single-product').hide();
                $('.product-layout').show();
                $('.product-details-column').addClass('column-details-fixed');
                $('#new-product').removeClass('active');
                $('#used-product').addClass('active');
                $('#pills-new-product').removeClass('show active');
                $('#pills-used-product').addClass('show active');
                $('#pills-used-product.product-pills-slider').owlCarousel('refresh');

            });

            $('.product-details-column .cross-times').on('click', function () {
                $('.product-layout').hide();
                $('.product-details-column').removeClass('column-details-fixed');
                $('.single-product').show();
            });

            $('#error_model').click(function () {
                $('.alert-dismissible').modal('hide');
            });

            $('.pills-link-admin').on('click', function () {

                $('.pills-link-admin').removeClass('active');
                $(this).addClass('active');
                $('#product_size').val($(this).data('size_id'));
                $('#addToCart').prop('disabled', false);
                $("#addToCart").css("background-color", "#00a9ec");
            });


            $('#addToCart').on('click', function (e) {

                let quantity = $('#number').val();
                product_id = $('#product_id').val();
                let size_id = $('.pills-link-admin.pills-link.active').data('size_id');
                let variation = $('.pills-link-admin.pills-link.active').data('variation_id');

                $.ajax({
                    url: "<?php echo e(route('admin_cart')); ?>",
                    method: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        quantity: quantity,
                        product_id: product_id,
                        size_id: size_id,
                        variation: variation,
                    },
                    success: function (result) {

                        if (result.status == "true") {

                            $('.alert-dismissible').addClass('success-alert');
                            $('.alert-dismissible').addClass('show').find('p').html("Product added to the cart");

                            parent.location.reload();

                        } else {

                            let lo = "<?php echo route('login.login'); ?>";

                            $('.alert-dismissible').addClass('success-alert');
                            $('.alert-dismissible').addClass('show').find('p').html('User must be logged in. Click <a style="color:#00A9EC !important;" href="' + lo + '">here </a> to sign in');
                        }
                    }
                });
            });

            $('.pills-link-new-product').on('click', function () {
                $('.pills-link-new-product').removeClass('active');
                $(this).addClass('active');
                size_id = $(this).data('size_id');
                product_id = $(this).data('product_id');
                flags = $(this).data('flags');

                $.ajax({
                    url: "<?php echo e(route('ProductNew')); ?>",
                    method: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        product_id: product_id,
                        size_id: size_id,
                        flags: flags,
                    },
                    success: function (result) {
                        $('#product-size-1').html(result);
                    }
                });
            });

            $('.pills-link-used-product').on('click', function () {

                $('.pills-link-used-product').removeClass('active');
                $(this).addClass('active');

                size_id = $(this).data('size_id');
                product_id = $(this).data('product_id');

                $.ajax({
                    url: "<?php echo e(route('ProductNew')); ?>",
                    method: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        product_id: product_id,
                        size_id: size_id,
                        flags: 2,
                    },
                    success: function (result) {

                        $('#used-product-size-1').html(result);
                    }
                });
            });

            $('#addWishlist').on('click', function (e) {

                let product_id = $('#product_id').val();
                let size_id = $('.pills-link-admin.pills-link.active').data('size_id');

                $.ajax({
                    url: "<?php echo e(route('user-wishlist')); ?>",
                    method: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        product_id: product_id,
                        size: size_id
                    },
                    success: function (result) {

                        let obj = JSON.parse(result);
                        let b = parseInt($(".wish").text());

                        if (obj.status == 'deleted') {
                            $(".wish").text(b - 1);
                        }

                        if (obj.status == 'added') {
                            $(".wish").text(b + 1);
                        }

                        if (obj.error) {

                            if (obj.error == "User must be logged in") {
                                $('.alert-dismissible').addClass('success-alert');
                                $('.alert-dismissible').addClass('show').find('p').html(obj.error);

                            } else {

                                $('.alert-dismissible1').addClass('success-alert');
                                $('.alert-dismissible1').addClass('show').find('p').html(obj.error);
                                $("#addWishlist").html('<i class="fa fa-heart"></i>Add to Wishlist');
                                $("#addWishlist").css("color", "#adadad");
                            }
                        }
                        if (obj.message) {
                            $('.alert-dismissible1').addClass('success-alert');
                            $('.alert-dismissible1').addClass('show').find('p').html(obj.message);
                            $("#addWishlist").html('<i class="fa fa-heart"></i>Item in my wish list');
                            $("#addWishlist").css("color", "red");

                            $('#addWishlist').find('.fa-heart').addClass('red-heart');

                            $('.nav-item .nav-button .wishlist-btn ').find('a').html('<span class = "badge">' + obj.message + '<span>');
                        }
                    }
                });
            });
        });

        function closeup() {
            let login = '<?php echo route("login.login");  ?>';
            $(".alert-dismissible1").hide();
            parent.location.reload();
        }

        function wishlist(product_id, size_id) {
            $.ajax({
                url: "<?php echo e(route('user-wishlists')); ?>",
                method: 'post',
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    product_id: product_id,
                    size: size_id
                },
                success: function (result) {

                    let obj = JSON.parse(result);

                    if (obj.value == 1) {
                        $("#addWishlist").html('<i class="fa fa-heart"></i>Item in my wish list');
                        $("#addWishlist").css("color", "red");
                    } else {
                        $("#addWishlist").html('<i class="fa fa-heart"></i>Add to Wishlist');
                        $("#addWishlist").css("color", "#adadad");
                    }
                }

            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/frontend/home/product-single-page.blade.php ENDPATH**/ ?>