


<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.css')); ?>" />
<?php $__env->stopSection(); ?> 
<?php $__env->startSection('body-content'); ?>
<div class="page-wrapper">
    <!-- Page Title -->
    <div class="page-title">
        <div class="row align-items-center">
            <div class="col-sm-6">
                <h2 class="page-title-text"></h2>
            </div>
            <div class="col-sm-6 text-right">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li>Dashboard</li>
                        <li>Order</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Page Body -->
    <div class="page-body">
        <div class="row">
            
            <div class="col-12">
                <div class="panel panel-default">
                
                    <div class="panel-head">
                      
                    </div>
                    
                    <div class="panel-body">
                    <?php if( session()->has('message') ): ?>
                    <div class="alert alert-icon alert-success alert-dismissible fade show">
                            <div class="alert--icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <div class="alert-text">
                                <strong>Well done!</strong>  <?php echo e(session('message')); ?>

                            </div>
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>
                        <div class="table-responsive">
                        <table class="table table-head-bg table-head-primary table table-striped table-bordered basic-datatable" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Reference</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Product</th>
                                    <th>Size</th>
                                    <th>Price</th>
                                   
                                    <th>Status</th>
                                   
                                   
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            <?php if(isset($data)): ?>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <td><?php echo e(date_format($order->created_at,'d/m/Y - H:i')); ?></td>
                                    <td><?php echo e(strtoupper($order->reference)); ?></td>
                                    <td><?php echo e($order->user->first_name); ?> <?php echo e($order->user->last_name); ?></td>
                                    <td><?php echo e($order->user->email); ?></td>
                                    <?php if($order->count >1): ?> <td style="color:red;"> Multiple </td> <?php else: ?> <td> <?php echo e($order->product_name); ?> </td> <?php endif; ?>
                                    <?php if($order->count >1): ?> <td style="color:red;" > Multiple </td> <?php else: ?> <td> <?php echo e($order->size); ?> </td>> <?php endif; ?>
                                    <td>£<?php echo e(number_format((float)$order->final_price, 2, '.', '')); ?></td>
                                   
                                    
                                    
                                    <td><select <?php if($order->status == 'refunded') echo 'disabled'; ?>  size="1" class="form-control m-0 selectOrder" onchange = "get_dist(this,<?php echo $order->id;?>)" id="order<?php echo e($order->id); ?>"  name="order<?php echo e($order->id); ?>">
                                        <option value="processing" <?php echo e(($order->status == 'processing' ? 'selected' : '')); ?>>
                                            Processing
                                        </option>
                                        <option value="completed" <?php echo e(($order->status == 'completed' ? 'selected ' : '')); ?>>
                                            Completed
                                        </option>
                                        <option value="refunded" <?php echo e(($order->status == 'refunded' ? 'selected ' : '')); ?>>
                                            Refunded
                                        </option>
                                        <option value="cancelled" <?php echo e(($order->status == 'cancelled' ? 'selected ' : '')); ?>>
                                            Cancelled
                                        </option>
                                        <option value="onhold" <?php echo e(($order->status == 'onhold' ? 'selected' : '')); ?>>
                                            On-hold
                                        </option>
                                    </select></td>

                                    
                                    <td>
                                        <a href = "<?php echo e(route('product.by.id', ['id' => $order->product_id])); ?>" class="btn btn-primary btn-sm m-1">Product</a> 
                                        <a href = "<?php echo e(route('order.detail.buyer', ['id' => $order->id])); ?>" class="btn btn-primary btn-sm m-1">View</a> 
                                        <a href = "<?php echo e(route('order.delete', ['id' => $order->id])); ?>" class="btn btn-danger btn-sm m-1">Delete</a>
                                    </td> 
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>  
                                
                            </tbody>
                            <tfoot>
                                <tr>
                                <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Total Amount</th>
                                    <th>Payment Type</th>
                                    <th>Status</th>
                                    <th>Action Orders</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                        </div>
                    </div>
                </div>
            </div> 
        </div>
      
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('admin/assets/plugin/datatable/datatables.min.js')); ?>"></script>
<!--<script type="text/javascript" src="<?php echo e(asset('admin/dist/js/demo/datatable.js')); ?>"></script>-->
<script>
$(document).ready(function () {
  var exampleTable = $('#myTable').DataTable({
	order: [[1, 'ASC']],
});  
});
  function get_dist(val , i){
     orderStatus =  $(val).val();
     orderId = i;

     $.ajax({
        url: "<?php echo e(route('order.status')); ?>",
			method: 'post',
			data: {
				_token: "<?php echo e(csrf_token()); ?>",
                orderStatus:orderStatus,
                orderId:orderId,
			
			},
			success: function(result){
				if(result.response.message){
                   console.log(result.response.message);
                    location.reload();
                }
                //result = JSON.parse(result)
				
            }
    });
   
  }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/x6s7iygrqu6j/public_html/staging.t-mp.co.uk/resources/views/admin/order/admin-orders.blade.php ENDPATH**/ ?>